/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftFishHook;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;

public class FishingHookController
extends MobEntityController {
    public FishingHookController() {
        super(EntityFishingHookNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        ServerLevel level = ((CraftWorld)at.getWorld()).getHandle();
        ServerPlayer sp = new ServerPlayer(level.getServer(), level, new GameProfile(UUID.randomUUID(), "dummyfishhook"), ClientInformation.createDefault()){};
        sp.setPos(at.getX(), at.getY(), at.getZ());
        sp.r(at.getYaw());
        sp.s(at.getPitch());
        sp.setYRot(20.0f);
        sp.gc().items.set(sp.gc().selected, (Object)new ItemStack((ItemLike)Items.FISHING_ROD, 1));
        EntityFishingHookNPC handle = new EntityFishingHookNPC((EntityType<? extends FishingHook>)EntityType.FISHING_BOBBER, (Level)level, npc, sp);
        return handle.getBukkitEntity();
    }

    public FishHook getBukkitEntity() {
        return (FishHook)super.getBukkitEntity();
    }

    public static class EntityFishingHookNPC
    extends FishingHook
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityFishingHookNPC(EntityType<? extends FishingHook> types, Level level) {
            this(types, level, null, null);
        }

        public EntityFishingHookNPC(EntityType<? extends FishingHook> types, Level level, NPC npc, ServerPlayer sp) {
            super((Player)sp, level, 0, 0);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public double distanceToSqr(net.minecraft.world.entity.Entity entity) {
            if (entity == this.u()) {
                return 0.0;
            }
            return super.distanceToSqr(entity);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FishingHookNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.k_();
        }

        public boolean isPickable() {
            return this.npc == null ? super.isPickable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Vec3 location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.u().dM();
                NMSImpl.setLife(this, 0);
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.ds().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.push(old);
            }
            return res;
        }
    }

    public static class FishingHookNPC
    extends CraftFishHook
    implements ForwardingNPCHolder {
        public FishingHookNPC(EntityFishingHookNPC entity) {
            super((CraftServer)Bukkit.getServer(), (FishingHook)entity);
        }
    }
}

