/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftLlamaSpit;
import org.bukkit.entity.Entity;

public class LlamaSpitController
extends AbstractEntityController {
    public LlamaSpitController() {
        super(EntityLlamaSpitNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        ServerLevel ws = ((CraftWorld)at.getWorld()).getHandle();
        EntityLlamaSpitNPC handle = new EntityLlamaSpitNPC(NMSImpl.getEntityType(EntityLlamaSpitNPC.class), (Level)ws, npc);
        handle.absMoveTo(at.getX(), at.getY(), at.getZ(), at.getPitch(), at.getYaw());
        return handle.getBukkitEntity();
    }

    public org.bukkit.entity.LlamaSpit getBukkitEntity() {
        return (org.bukkit.entity.LlamaSpit)super.getBukkitEntity();
    }

    public static class EntityLlamaSpitNPC
    extends LlamaSpit
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityLlamaSpitNPC(EntityType<? extends LlamaSpit> types, Level level) {
            this(types, level, null);
        }

        public EntityLlamaSpitNPC(EntityType<? extends LlamaSpit> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public EntityLlamaSpitNPC(Level world, NPC npc, Llama entity) {
            super(world, entity);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new LlamaSpitNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.k_();
        }

        public boolean isPickable() {
            return this.npc == null ? super.isPickable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Vec3 location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
                if (!this.npc.isProtected()) {
                    super.tick();
                }
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.ds().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.push(old);
            }
            return res;
        }
    }

    public static class LlamaSpitNPC
    extends CraftLlamaSpit
    implements ForwardingNPCHolder {
        public LlamaSpitNPC(EntityLlamaSpitNPC entity) {
            super((CraftServer)Bukkit.getServer(), (LlamaSpit)entity);
        }
    }
}

