/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftOminousItemSpawner;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.OminousItemSpawner;
import org.bukkit.inventory.ItemStack;

public class OminousItemSpawnerController
extends MobEntityController {
    public OminousItemSpawnerController() {
        super(EntityOminousItemSpawnerNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        EntityOminousItemSpawnerNPC handle = new EntityOminousItemSpawnerNPC((EntityType<? extends net.minecraft.world.entity.OminousItemSpawner>)EntityType.OMINOUS_ITEM_SPAWNER, (Level)((CraftWorld)at.getWorld()).getHandle(), npc);
        if (npc != null) {
            handle.setItem(CraftItemStack.asNMSCopy((ItemStack)npc.getItemProvider().get()));
        }
        return handle.getBukkitEntity();
    }

    public OminousItemSpawner getBukkitEntity() {
        return (OminousItemSpawner)super.getBukkitEntity();
    }

    public static class EntityOminousItemSpawnerNPC
    extends net.minecraft.world.entity.OminousItemSpawner
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityOminousItemSpawnerNPC(EntityType<? extends net.minecraft.world.entity.OminousItemSpawner> types, Level level) {
            this(types, level, null);
        }

        public EntityOminousItemSpawnerNPC(EntityType<? extends net.minecraft.world.entity.OminousItemSpawner> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new OminousItemSpawnerNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.k_();
        }

        public boolean isPickable() {
            return this.npc == null ? super.isPickable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(ServerLevel worldserver, Vec3 location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.ds().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.push(old);
            }
            return res;
        }
    }

    public static class OminousItemSpawnerNPC
    extends CraftOminousItemSpawner
    implements NPCHolder {
        private final CitizensNPC npc;

        public OminousItemSpawnerNPC(EntityOminousItemSpawnerNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.OminousItemSpawner)entity);
            this.npc = entity.npc;
            this.setItem(this.npc.getItemProvider().get());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

