/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.util.AbstractBlockBreaker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class CitizensBlockBreaker
extends AbstractBlockBreaker {
    public CitizensBlockBreaker(Entity entity, Block target, BlockBreaker.BlockBreakerConfiguration config) {
        super(entity, target, config);
    }

    private net.minecraft.world.item.ItemStack getCurrentItem() {
        return this.configuration.item() != null ? CraftItemStack.asNMSCopy((ItemStack)this.configuration.item()) : (this.getHandle() instanceof LivingEntity ? ((LivingEntity)this.getHandle()).eX() : null);
    }

    @Override
    protected float getDamage(int tickDifference) {
        return this.getStrength(this.getHandle().dP().getBlockState(new BlockPos(this.x, this.y, this.z))) * (float)(tickDifference + 1) * this.configuration.blockStrengthModifier();
    }

    private net.minecraft.world.entity.Entity getHandle() {
        return NMSImpl.getHandle(this.entity);
    }

    protected float getStrength(BlockState block) {
        float base = block.getDestroySpeed(null, BlockPos.ZERO);
        return base < 0.0f ? 0.0f : (!this.isDestroyable(block) ? 1.0f / base / 100.0f : this.strengthMod(block) / base / 30.0f);
    }

    private boolean isDestroyable(BlockState block) {
        if (block.requiresCorrectToolForDrops()) {
            return true;
        }
        net.minecraft.world.item.ItemStack current = this.getCurrentItem();
        return current != null ? current.isCorrectToolForDrops(block) : false;
    }

    @Override
    protected void setBlockDamage(int modifiedDamage) {
        ((ServerLevel)this.getHandle().dP()).destroyBlockProgress(this.getHandle().al(), new BlockPos(this.x, this.y, this.z), modifiedDamage);
    }

    private float strengthMod(BlockState block) {
        net.minecraft.world.item.ItemStack itemstack = this.getCurrentItem();
        float f = itemstack.getDestroySpeed(block);
        if (this.getHandle() instanceof LivingEntity) {
            int i;
            LivingEntity handle = (LivingEntity)this.getHandle();
            if (f > 1.0f && (i = EnchantmentHelper.g((LivingEntity)handle)) > 0) {
                f += (float)(i * i + 1);
            }
            if (MobEffectUtil.hasDigSpeed((LivingEntity)handle)) {
                f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)handle) + 1) * 0.2f;
            }
            if (handle.hasEffect(MobEffects.DIG_SLOWDOWN)) {
                float f1 = 1.0f;
                switch (handle.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                    case 0: {
                        f1 = 0.3f;
                        break;
                    }
                    case 1: {
                        f1 = 0.09f;
                        break;
                    }
                    case 2: {
                        f1 = 0.0027f;
                        break;
                    }
                    default: {
                        f1 = 8.1E-4f;
                    }
                }
                f *= f1;
            }
            if (handle.isEyeInFluid(FluidTags.WATER) && !EnchantmentHelper.i((LivingEntity)handle)) {
                f /= 5.0f;
            }
        }
        if (!this.entity.isOnGround()) {
            f /= 5.0f;
        }
        return f;
    }
}

