/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.citizensnpcs.util.NMS;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;

public class CustomEntityRegistry
extends DefaultedMappedRegistry<EntityType<?>>
implements Supplier<MappedRegistry<EntityType<?>>> {
    private final BiMap<ResourceLocation, EntityType> entities = HashBiMap.create();
    private final BiMap<EntityType, ResourceLocation> entityClasses = this.entities.inverse();
    private final Map<EntityType, Integer> entityIds = Maps.newHashMap();
    private final MappedRegistry<EntityType<?>> wrapped;
    private static final MethodHandle IREGISTRY_LIFECYCLE = NMS.getFirstGetter(MappedRegistry.class, Lifecycle.class);
    private static final MethodHandle IREGISTRY_RESOURCE_KEY = NMS.getFirstGetter(MappedRegistry.class, ResourceKey.class);
    private static final BiMap<EntityType, Class<?>> minecraftClassMap = HashBiMap.create();

    public CustomEntityRegistry(DefaultedRegistry<EntityType<?>> original) throws Throwable {
        super(original.a().getNamespace(), IREGISTRY_RESOURCE_KEY.invoke(original), IREGISTRY_LIFECYCLE.invoke(original), true);
        this.wrapped = (MappedRegistry)original;
    }

    public HolderLookup.RegistryLookup<EntityType<?>> p() {
        return this.wrapped.p();
    }

    public void bindTags(Map<TagKey<EntityType<?>>, List<Holder<EntityType<?>>>> map) {
        this.wrapped.bindTags(map);
    }

    public EntityType byId(int var0) {
        return (EntityType)this.wrapped.byId(var0);
    }

    public EntityType byIdOrThrow(int var0) {
        return (EntityType)this.wrapped.byIdOrThrow(var0);
    }

    public boolean containsKey(ResourceKey<EntityType<?>> var0) {
        return this.wrapped.containsKey(var0);
    }

    public boolean containsKey(ResourceLocation var0) {
        return this.wrapped.containsKey(var0);
    }

    public HolderGetter<EntityType<?>> n() {
        return this.wrapped.n();
    }

    public Set<Map.Entry<ResourceKey<EntityType<?>>, EntityType<?>>> registryKeySet() {
        return this.wrapped.registryKeySet();
    }

    public EntityType findType(Class<?> search) {
        return (EntityType)minecraftClassMap.inverse().get(search);
    }

    @Override
    public MappedRegistry<EntityType<?>> get() {
        return this.wrapped;
    }

    public EntityType get(ResourceKey<EntityType<?>> key) {
        return (EntityType)this.wrapped.get(key);
    }

    public EntityType get(ResourceLocation key) {
        if (this.entities.containsKey((Object)key)) {
            return (EntityType)this.entities.get((Object)key);
        }
        return (EntityType)this.wrapped.get(key);
    }

    public Optional<Holder.Reference<EntityType<?>>> getHolder(int var0) {
        return this.wrapped.getHolder(var0);
    }

    public Optional<Holder.Reference<EntityType<?>>> getHolder(ResourceKey<EntityType<?>> var0) {
        return this.wrapped.getHolder(var0);
    }

    public int getId(EntityType key) {
        if (this.entityIds.containsKey(key)) {
            return this.entityIds.get(key);
        }
        return this.wrapped.getId((Object)key);
    }

    public ResourceLocation getKey(EntityType value) {
        if (this.entityClasses.containsKey((Object)value)) {
            return (ResourceLocation)this.entityClasses.get((Object)value);
        }
        return this.wrapped.getKey((Object)value);
    }

    public Optional<EntityType<?>> getOptional(ResourceKey<EntityType<?>> var0) {
        return this.wrapped.getOptional(var0);
    }

    public Optional<EntityType<?>> getOptional(ResourceLocation var0) {
        if (this.entities.containsKey((Object)var0)) {
            return Optional.of((EntityType)this.entities.get((Object)var0));
        }
        return this.wrapped.getOptional(var0);
    }

    public Optional<Holder.Reference<EntityType<?>>> getRandom(RandomSource paramRandom) {
        return this.wrapped.getRandom(paramRandom);
    }

    public Optional<ResourceKey<EntityType<?>>> getResourceKey(EntityType<?> var0) {
        return this.wrapped.getResourceKey(var0);
    }

    public Optional<HolderSet.Named<EntityType<?>>> getTag(TagKey<EntityType<?>> var0) {
        return this.wrapped.getTag(var0);
    }

    public Stream<TagKey<EntityType<?>>> getTags() {
        return this.wrapped.getTags();
    }

    public Stream<Pair<TagKey<EntityType<?>>, HolderSet.Named<EntityType<?>>>> holders() {
        return this.wrapped.holders();
    }

    public HolderOwner<EntityType<?>> o() {
        return this.wrapped.o();
    }

    public Stream<Holder.Reference<EntityType<?>>> h() {
        return this.wrapped.h();
    }

    public boolean k() {
        return this.wrapped.k();
    }

    public Iterator<EntityType<?>> iterator() {
        return this.wrapped.iterator();
    }

    public Set<ResourceLocation> e() {
        return this.wrapped.e();
    }

    public void put(int entityId, ResourceLocation key, EntityType entityClass) {
        this.entities.put((Object)key, (Object)entityClass);
        this.entityIds.put(entityClass, entityId);
    }

    public Set<ResourceKey<EntityType<?>>> keySet() {
        return this.wrapped.keySet();
    }

    public void m() {
        this.wrapped.m();
    }

    public int b() {
        return this.wrapped.b();
    }

    static {
        minecraftClassMap.put((Object)EntityType.ALLAY, Allay.class);
        minecraftClassMap.put((Object)EntityType.AREA_EFFECT_CLOUD, AreaEffectCloud.class);
        minecraftClassMap.put((Object)EntityType.ARMADILLO, Armadillo.class);
        minecraftClassMap.put((Object)EntityType.ARMOR_STAND, ArmorStand.class);
        minecraftClassMap.put((Object)EntityType.ARROW, Arrow.class);
        minecraftClassMap.put((Object)EntityType.AXOLOTL, Axolotl.class);
        minecraftClassMap.put((Object)EntityType.BAT, Bat.class);
        minecraftClassMap.put((Object)EntityType.BEE, Bee.class);
        minecraftClassMap.put((Object)EntityType.BLAZE, Blaze.class);
        minecraftClassMap.put((Object)EntityType.BLOCK_DISPLAY, Display.BlockDisplay.class);
        minecraftClassMap.put((Object)EntityType.BOAT, Boat.class);
        minecraftClassMap.put((Object)EntityType.BOGGED, Bogged.class);
        minecraftClassMap.put((Object)EntityType.BREEZE, Breeze.class);
        minecraftClassMap.put((Object)EntityType.BREEZE_WIND_CHARGE, BreezeWindCharge.class);
        minecraftClassMap.put((Object)EntityType.CAMEL, Camel.class);
        minecraftClassMap.put((Object)EntityType.CAT, Cat.class);
        minecraftClassMap.put((Object)EntityType.CAVE_SPIDER, CaveSpider.class);
        minecraftClassMap.put((Object)EntityType.CHEST_BOAT, ChestBoat.class);
        minecraftClassMap.put((Object)EntityType.CHEST_MINECART, MinecartChest.class);
        minecraftClassMap.put((Object)EntityType.CHICKEN, Chicken.class);
        minecraftClassMap.put((Object)EntityType.COD, Cod.class);
        minecraftClassMap.put((Object)EntityType.COMMAND_BLOCK_MINECART, MinecartCommandBlock.class);
        minecraftClassMap.put((Object)EntityType.COW, Cow.class);
        minecraftClassMap.put((Object)EntityType.CREEPER, Creeper.class);
        minecraftClassMap.put((Object)EntityType.DOLPHIN, Dolphin.class);
        minecraftClassMap.put((Object)EntityType.DONKEY, Donkey.class);
        minecraftClassMap.put((Object)EntityType.DRAGON_FIREBALL, DragonFireball.class);
        minecraftClassMap.put((Object)EntityType.DROWNED, Drowned.class);
        minecraftClassMap.put((Object)EntityType.EGG, ThrownEgg.class);
        minecraftClassMap.put((Object)EntityType.ELDER_GUARDIAN, ElderGuardian.class);
        minecraftClassMap.put((Object)EntityType.END_CRYSTAL, EndCrystal.class);
        minecraftClassMap.put((Object)EntityType.ENDER_DRAGON, EnderDragon.class);
        minecraftClassMap.put((Object)EntityType.ENDER_PEARL, ThrownEnderpearl.class);
        minecraftClassMap.put((Object)EntityType.ENDERMAN, EnderMan.class);
        minecraftClassMap.put((Object)EntityType.ENDERMITE, Endermite.class);
        minecraftClassMap.put((Object)EntityType.EVOKER, Evoker.class);
        minecraftClassMap.put((Object)EntityType.EVOKER_FANGS, EvokerFangs.class);
        minecraftClassMap.put((Object)EntityType.EXPERIENCE_BOTTLE, ThrownExperienceBottle.class);
        minecraftClassMap.put((Object)EntityType.EXPERIENCE_ORB, ExperienceOrb.class);
        minecraftClassMap.put((Object)EntityType.EYE_OF_ENDER, EyeOfEnder.class);
        minecraftClassMap.put((Object)EntityType.FALLING_BLOCK, FallingBlockEntity.class);
        minecraftClassMap.put((Object)EntityType.FIREWORK_ROCKET, FireworkRocketEntity.class);
        minecraftClassMap.put((Object)EntityType.FOX, Fox.class);
        minecraftClassMap.put((Object)EntityType.FROG, Frog.class);
        minecraftClassMap.put((Object)EntityType.FURNACE_MINECART, MinecartFurnace.class);
        minecraftClassMap.put((Object)EntityType.GHAST, Ghast.class);
        minecraftClassMap.put((Object)EntityType.GIANT, Giant.class);
        minecraftClassMap.put((Object)EntityType.GLOW_ITEM_FRAME, GlowItemFrame.class);
        minecraftClassMap.put((Object)EntityType.GLOW_SQUID, GlowSquid.class);
        minecraftClassMap.put((Object)EntityType.GOAT, Goat.class);
        minecraftClassMap.put((Object)EntityType.GUARDIAN, Guardian.class);
        minecraftClassMap.put((Object)EntityType.HOGLIN, Hoglin.class);
        minecraftClassMap.put((Object)EntityType.HOPPER_MINECART, MinecartHopper.class);
        minecraftClassMap.put((Object)EntityType.HORSE, Horse.class);
        minecraftClassMap.put((Object)EntityType.HUSK, Husk.class);
        minecraftClassMap.put((Object)EntityType.ILLUSIONER, Illusioner.class);
        minecraftClassMap.put((Object)EntityType.INTERACTION, Interaction.class);
        minecraftClassMap.put((Object)EntityType.IRON_GOLEM, IronGolem.class);
        minecraftClassMap.put((Object)EntityType.ITEM, ItemEntity.class);
        minecraftClassMap.put((Object)EntityType.ITEM_DISPLAY, Display.ItemDisplay.class);
        minecraftClassMap.put((Object)EntityType.ITEM_FRAME, ItemFrame.class);
        minecraftClassMap.put((Object)EntityType.OMINOUS_ITEM_SPAWNER, OminousItemSpawner.class);
        minecraftClassMap.put((Object)EntityType.FIREBALL, LargeFireball.class);
        minecraftClassMap.put((Object)EntityType.LEASH_KNOT, LeashFenceKnotEntity.class);
        minecraftClassMap.put((Object)EntityType.LIGHTNING_BOLT, LightningBolt.class);
        minecraftClassMap.put((Object)EntityType.LLAMA, Llama.class);
        minecraftClassMap.put((Object)EntityType.LLAMA_SPIT, LlamaSpit.class);
        minecraftClassMap.put((Object)EntityType.MAGMA_CUBE, MagmaCube.class);
        minecraftClassMap.put((Object)EntityType.MARKER, Marker.class);
        minecraftClassMap.put((Object)EntityType.MINECART, Minecart.class);
        minecraftClassMap.put((Object)EntityType.MOOSHROOM, MushroomCow.class);
        minecraftClassMap.put((Object)EntityType.MULE, Mule.class);
        minecraftClassMap.put((Object)EntityType.OCELOT, Ocelot.class);
        minecraftClassMap.put((Object)EntityType.PAINTING, Painting.class);
        minecraftClassMap.put((Object)EntityType.PANDA, Panda.class);
        minecraftClassMap.put((Object)EntityType.PARROT, Parrot.class);
        minecraftClassMap.put((Object)EntityType.PHANTOM, Phantom.class);
        minecraftClassMap.put((Object)EntityType.PIG, Pig.class);
        minecraftClassMap.put((Object)EntityType.PIGLIN, Piglin.class);
        minecraftClassMap.put((Object)EntityType.PIGLIN_BRUTE, PiglinBrute.class);
        minecraftClassMap.put((Object)EntityType.PILLAGER, Pillager.class);
        minecraftClassMap.put((Object)EntityType.POLAR_BEAR, PolarBear.class);
        minecraftClassMap.put((Object)EntityType.POTION, ThrownPotion.class);
        minecraftClassMap.put((Object)EntityType.PUFFERFISH, Pufferfish.class);
        minecraftClassMap.put((Object)EntityType.RABBIT, Rabbit.class);
        minecraftClassMap.put((Object)EntityType.RAVAGER, Ravager.class);
        minecraftClassMap.put((Object)EntityType.SALMON, Salmon.class);
        minecraftClassMap.put((Object)EntityType.SHEEP, Sheep.class);
        minecraftClassMap.put((Object)EntityType.SHULKER, Shulker.class);
        minecraftClassMap.put((Object)EntityType.SHULKER_BULLET, ShulkerBullet.class);
        minecraftClassMap.put((Object)EntityType.SILVERFISH, Silverfish.class);
        minecraftClassMap.put((Object)EntityType.SKELETON, Skeleton.class);
        minecraftClassMap.put((Object)EntityType.SKELETON_HORSE, SkeletonHorse.class);
        minecraftClassMap.put((Object)EntityType.SLIME, Slime.class);
        minecraftClassMap.put((Object)EntityType.SMALL_FIREBALL, SmallFireball.class);
        minecraftClassMap.put((Object)EntityType.SNIFFER, Sniffer.class);
        minecraftClassMap.put((Object)EntityType.SNOW_GOLEM, SnowGolem.class);
        minecraftClassMap.put((Object)EntityType.SNOWBALL, Snowball.class);
        minecraftClassMap.put((Object)EntityType.SPAWNER_MINECART, MinecartSpawner.class);
        minecraftClassMap.put((Object)EntityType.SPECTRAL_ARROW, SpectralArrow.class);
        minecraftClassMap.put((Object)EntityType.SPIDER, Spider.class);
        minecraftClassMap.put((Object)EntityType.SQUID, Squid.class);
        minecraftClassMap.put((Object)EntityType.STRAY, Stray.class);
        minecraftClassMap.put((Object)EntityType.STRIDER, Strider.class);
        minecraftClassMap.put((Object)EntityType.TADPOLE, Tadpole.class);
        minecraftClassMap.put((Object)EntityType.TEXT_DISPLAY, Display.TextDisplay.class);
        minecraftClassMap.put((Object)EntityType.TNT, PrimedTnt.class);
        minecraftClassMap.put((Object)EntityType.TNT_MINECART, MinecartTNT.class);
        minecraftClassMap.put((Object)EntityType.TRADER_LLAMA, TraderLlama.class);
        minecraftClassMap.put((Object)EntityType.TRIDENT, ThrownTrident.class);
        minecraftClassMap.put((Object)EntityType.TROPICAL_FISH, TropicalFish.class);
        minecraftClassMap.put((Object)EntityType.TURTLE, Turtle.class);
        minecraftClassMap.put((Object)EntityType.VEX, Vex.class);
        minecraftClassMap.put((Object)EntityType.VILLAGER, Villager.class);
        minecraftClassMap.put((Object)EntityType.VINDICATOR, Vindicator.class);
        minecraftClassMap.put((Object)EntityType.WANDERING_TRADER, WanderingTrader.class);
        minecraftClassMap.put((Object)EntityType.WARDEN, Warden.class);
        minecraftClassMap.put((Object)EntityType.WIND_CHARGE, WindCharge.class);
        minecraftClassMap.put((Object)EntityType.WITCH, Witch.class);
        minecraftClassMap.put((Object)EntityType.WITHER, WitherBoss.class);
        minecraftClassMap.put((Object)EntityType.WITHER_SKELETON, WitherSkeleton.class);
        minecraftClassMap.put((Object)EntityType.WITHER_SKULL, WitherSkull.class);
        minecraftClassMap.put((Object)EntityType.WOLF, Wolf.class);
        minecraftClassMap.put((Object)EntityType.ZOGLIN, Zoglin.class);
        minecraftClassMap.put((Object)EntityType.ZOMBIE, Zombie.class);
        minecraftClassMap.put((Object)EntityType.ZOMBIE_HORSE, ZombieHorse.class);
        minecraftClassMap.put((Object)EntityType.ZOMBIE_VILLAGER, ZombieVillager.class);
        minecraftClassMap.put((Object)EntityType.ZOMBIFIED_PIGLIN, ZombifiedPiglin.class);
        minecraftClassMap.put((Object)EntityType.FISHING_BOBBER, FishingHook.class);
    }
}

