/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.MobAI;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class ArmorStandController
extends MobEntityController {
    public ArmorStandController() {
        super(EntityArmorStandNPC.class);
    }

    public ArmorStand getBukkitEntity() {
        return (ArmorStand)super.getBukkitEntity();
    }

    public static class EntityArmorStandNPC
    extends net.minecraft.world.entity.decoration.ArmorStand
    implements NPCHolder,
    MobAI.ForwardingMobAI {
        private MobAI ai;
        private final CitizensNPC npc;

        public EntityArmorStandNPC(EntityType<? extends net.minecraft.world.entity.decoration.ArmorStand> types, Level level) {
            this(types, level, null);
        }

        public EntityArmorStandNPC(EntityType<? extends net.minecraft.world.entity.decoration.ArmorStand> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.ai = new MobAI.BasicMobAI((LivingEntity)this);
                NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
            }
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public net.minecraft.world.entity.Entity changeDimension(DimensionTransition transition) {
            if (this.npc == null) {
                return super.changeDimension(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        @Override
        public MobAI getAI() {
            return this.ai;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ArmorStandNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public InteractionResult interactAt(Player entityhuman, Vec3 vec3d, InteractionHand enumhand) {
            if (this.npc == null) {
                return super.interactAt(entityhuman, vec3d, enumhand);
            }
            PlayerInteractEntityEvent event = new PlayerInteractEntityEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (Entity)this.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)event);
            return event.isCancelled() ? InteractionResult.FAIL : InteractionResult.SUCCESS;
        }

        public boolean isPushable() {
            return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB makeBoundingBox() {
            return NMSBoundingBox.makeBB(this.npc, super.makeBoundingBox());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public void tick() {
            super.tick();
            if (this.npc != null) {
                this.npc.update();
                this.ai.tickAI();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setDeltaMovement(old);
            }
            return res;
        }
    }

    public static class ArmorStandNPC
    extends CraftArmorStand
    implements ForwardingNPCHolder {
        public ArmorStandNPC(EntityArmorStandNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.decoration.ArmorStand)entity);
        }
    }
}

