/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends net.minecraft.world.entity.boss.enderdragon.EnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityType<? extends net.minecraft.world.entity.boss.enderdragon.EnderDragon> types, Level level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityType<? extends net.minecraft.world.entity.boss.enderdragon.EnderDragon> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void aiStep() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (Mob)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.isDeadOrDying()) {
                    this.setHealth(0.0f);
                    return;
                }
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.getYRot();
                        this.positions[i][1] = this.getY();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.getYRot();
                this.positions[this.posPointer][1] = this.getY();
                float[][] pos = NMS.calculateDragonPositions(this.getYRot(), new double[][]{this.getLatencyPos(0, 1.0f), this.getLatencyPos(5, 1.0f), this.getLatencyPos(10, 1.0f), this.getLatencyPos(12, 1.0f), this.getLatencyPos(14, 1.0f), this.getLatencyPos(16, 1.0f)});
                for (int j = 0; j < this.subEntities.length; ++j) {
                    Vec3 vec3 = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
                    this.subEntities[j].setPos(this.getX() + (double)pos[j][0], this.getY() + (double)pos[j][1], this.getZ() + (double)pos[j][2]);
                    this.subEntities[j].xo = this.subEntities[j].xOld = vec3.x;
                    this.subEntities[j].yo = this.subEntities[j].yOld = vec3.y;
                    this.subEntities[j].zo = this.subEntities[j].zOld = vec3.z;
                }
                if (this.getFirstPassenger() != null) {
                    this.setYRot(this.getFirstPassenger().getBukkitYaw() - 180.0f);
                }
                Vec3 mot = this.getDeltaMovement();
                if (mot.x != 0.0 || mot.y != 0.0 || mot.z != 0.0) {
                    mot = mot.multiply(0.98, 0.91, 0.98);
                    if (this.getFirstPassenger() == null) {
                        this.setYRot(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), mot.x, mot.z));
                    }
                    this.setPos(this.getX() + mot.x, this.getY() + mot.y, this.getZ() + mot.z);
                    this.setDeltaMovement(mot);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.inWall |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.subEntities[i].getBoundingBox());
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.level(), this.level().getEntities((net.minecraft.world.entity.Entity)this, this.subEntities[6].getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.level(), this.level().getEntities((net.minecraft.world.entity.Entity)this, this.subEntities[7].getBoundingBox().inflate(4.0, 2.0, 4.0).move(0.0, -2.0, 0.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.level().getEntities((net.minecraft.world.entity.Entity)this, this.subEntities[0].getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.level().getEntities((net.minecraft.world.entity.Entity)this, this.subEntities[1].getBoundingBox().inflate(1.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                super.aiStep();
            }
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        protected boolean canRide(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof Boat || entity instanceof AbstractMinecart)) {
                return !this.npc.isProtected();
            }
            return super.canRide(entity);
        }

        public net.minecraft.world.entity.Entity changeDimension(DimensionTransition transition) {
            if (this.npc == null) {
                return super.changeDimension(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        protected SoundEvent getAmbientSound() {
            return NMSImpl.getSoundEffect(this.npc, super.getAmbientSound(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEvent getDeathSound() {
            return NMSImpl.getSoundEffect(this.npc, super.getDeathSound(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEvent getHurtSound(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float getJumpPower() {
            return NMS.getJumpPower(this.npc, super.getJumpPower());
        }

        public int getMaxFallDistance() {
            return NMS.getFallDistance(this.npc, super.getMaxFallDistance());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction getPistonPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.getPistonPushReaction();
        }

        public boolean isLeashed() {
            return NMSImpl.isLeashed(this.npc, () -> super.isLeashed(), (Mob)this);
        }

        public boolean isPushable() {
            return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void knockback(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.knockback((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AABB makeBoundingBox() {
            return NMSBoundingBox.makeBB(this.npc, super.makeBoundingBox());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected boolean reallyHurt(DamageSource source, float f) {
            if (this.npc == null) {
                return super.reallyHurt(source, f);
            }
            Vec3 old = this.getDeltaMovement();
            boolean res = super.reallyHurt(source, f);
            if (this.getPhaseManager().getCurrentPhase().getPhase() == EnderDragonPhase.HOVERING) {
                this.setDeltaMovement(old);
            }
            return res;
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setDeltaMovement(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.boss.enderdragon.EnderDragon)entity);
        }
    }
}

