/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R1.network.EmptyConnection;
import net.citizensnpcs.nms.v1_21_R1.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_21_R1.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_21_R1.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_21_R1.util.MobAI;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends ServerPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private PlayerAdvancements advancements;
    private final MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTER = NMS.getFirstMethodHandle(ServerPlayerGameMode.class, true, GameType.class, GameType.class);

    public EntityHumanNPC(MinecraftServer minecraftServer, ServerLevel world, GameProfile gameProfile, ClientInformation ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((LivingEntity)this);
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTER.invoke(this.gameMode, GameType.SURVIVAL, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.ai = null;
            this.skinTracker = null;
        }
    }

    public boolean broadcastToPlayer(ServerPlayer player) {
        return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
    }

    public boolean causeFallDamage(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.causeFallDamage(f, f1, damagesource);
        }
        return false;
    }

    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.checkFallDamage(d0, flag, iblockdata, blockposition);
        }
    }

    public void die(DamageSource damagesource) {
        if (this.dead) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((ServerLevel)this.level()).removePlayerImmediately((ServerPlayer)this, Entity.RemovalReason.KILLED);
            ((ServerLevel)this.level()).getChunkSource().removeEntity((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void doTick() {
        boolean navigating;
        if (this.npc == null) {
            super.doTick();
            return;
        }
        super.baseTick();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().hasWanted();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !this.npc.getOrAddTrait(Gravity.class).hasGravity() || !Util.isLoaded(this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe(this.getY(), this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3.ZERO);
        }
        Vec3 mot = this.getDeltaMovement();
        if (Math.abs(mot.x) < (double)0.003f && Math.abs(mot.y) < (double)0.003f && Math.abs(mot.z) < (double)0.003f) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (navigating) {
            if (!this.ai.getNavigation().isDone()) {
                this.ai.getNavigation().tick();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.noPhysics = this.isSpectator();
        if (this.isSpectator()) {
            this.onGround = false;
        }
        this.pushEntities();
        if (this.npc.useMinecraftAI()) {
            this.foodData.tick((Player)this);
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            if (this.takeXpDelay > 0) {
                --this.takeXpDelay;
            }
            AABB axisalignedbb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.level().getEntities((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.playerTouch((Player)this);
            }
        }
        ++this.attackStrengthTicker;
        this.getCooldowns().tick();
        if (!this.npc.hasTrait(EntityPoseTrait.class) || this.npc.getTraitNullable(EntityPoseTrait.class).getPose() == null) {
            this.updatePlayerPose();
        }
    }

    public PlayerAdvancements getAdvancements() {
        if (this.npc == null) {
            return super.getAdvancements();
        }
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.getServer().getFixerUpper(), this.getServer().getPlayerList(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEvent getDeathSound() {
        return NMSImpl.getSoundEffect(this.npc, super.getDeathSound(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public GameProfile getProfile() {
        return super.getGameProfile();
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatsCounter getStats() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public Component getTabListDisplayName() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(""));
        }
        return this.npc != null ? (Component)Messaging.minecraftComponentFromRawMessage(this.npc.getRawName()) : super.getTabListDisplayName();
    }

    public boolean hurt(DamageSource damagesource, float f) {
        boolean damaged = super.hurt(damagesource, f);
        if (damaged && this.hurtMarked) {
            this.hurtMarked = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.hurtMarked = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, ClientInformation clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(PacketFlow.CLIENTBOUND);
            this.connection = new EmptyPacketListener(minecraftServer, conn, this, new CommonListenerCookie(this.getProfile(), 0, clientInfo, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.invulnerableTime = 0;
        this.setSkinFlags((byte)-1);
    }

    public boolean isInWall() {
        if (this.npc == null || this.noPhysics || this.isSleeping()) {
            return super.isInWall();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean isPushable() {
        return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
    }

    public void knockback(double strength, double dx, double dz) {
        NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.knockback((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.jumping) {
            if (this.onGround && this.jumpTicks == 0) {
                this.jumpFromGround();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.moveWithFallDamage(new Vec3((double)this.xxa, (double)this.yya, (double)this.zza));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), this.getYRot());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3 vec) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        this.travel(vec);
        if (!this.npc.isProtected()) {
            this.doCheckFallDamage(this.getX() - x, this.getY() - y, this.getZ() - z, this.onGround);
        }
    }

    public boolean onClimbable() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.onClimbable();
        }
        return false;
    }

    public void push(net.minecraft.world.entity.Entity entity) {
        super.push(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        this.getAdvancements().save();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void tick() {
        super.tick();
        if (this.npc == null) {
            return;
        }
        this.detectEquipmentUpdatesPublic();
        float scale = this.getScale();
        if (scale != this.appliedScale) {
            this.appliedScale = scale;
            this.refreshDimensions();
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().tick();
        this.ai.getJumpControl().tick();
    }

    public void travel(Vec3 vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.travel(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((LivingEntity)this, vec3d);
        }
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
        Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
        boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.setDeltaMovement(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.effectsDirty = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (ServerPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        @Override
        public org.bukkit.entity.Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

