/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPufferFish;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PufferFish;

public class PufferFishController
extends MobEntityController {
    public PufferFishController() {
        super(EntityPufferFishNPC.class);
    }

    public PufferFish getBukkitEntity() {
        return (PufferFish)super.getBukkitEntity();
    }

    public static class EntityPufferFishNPC
    extends Pufferfish
    implements NPCHolder {
        private final CitizensNPC npc;
        private MoveControl oldMoveController;

        public EntityPufferFishNPC(EntityType<? extends Pufferfish> types, Level level) {
            this(types, level, null);
        }

        public EntityPufferFishNPC(EntityType<? extends Pufferfish> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.moveControl;
                this.moveControl = new MoveControl((Mob)this);
            }
        }

        public void aiStep() {
            boolean lastInWater = this.verticalCollision;
            int lastPuffState = this.getPuffState();
            if (this.npc != null) {
                this.verticalCollision = false;
                this.setPuffState(0);
            }
            super.aiStep();
            if (this.npc != null) {
                this.verticalCollision = lastInWater;
                this.setPuffState(lastPuffState);
            }
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        protected boolean canRide(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof Boat || entity instanceof AbstractMinecart)) {
                return !this.npc.isProtected();
            }
            return super.canRide(entity);
        }

        public boolean causeFallDamage(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.causeFallDamage(f, f1, damagesource);
            }
            return false;
        }

        public net.minecraft.world.entity.Entity changeDimension(DimensionTransition transition) {
            if (this.npc == null) {
                return super.changeDimension(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.checkFallDamage(d0, flag, iblockdata, blockposition);
            }
        }

        public void customServerAiStep() {
            super.customServerAiStep();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (Mob)this);
                if (this.npc.useMinecraftAI() && this.moveControl != this.oldMoveController) {
                    this.moveControl = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.moveControl == this.oldMoveController) {
                    this.moveControl = new EntityMoveControl((LivingEntity)this);
                }
                this.npc.update();
            }
        }

        protected SoundEvent getAmbientSound() {
            return NMSImpl.getSoundEffect(this.npc, super.getAmbientSound(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PufferFishNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEvent getDeathSound() {
            return NMSImpl.getSoundEffect(this.npc, super.getDeathSound(), NPC.Metadata.DEATH_SOUND);
        }

        public EntityDimensions getDefaultDimensions(Pose entitypose) {
            if (this.npc == null) {
                return super.getDefaultDimensions(entitypose);
            }
            return super.getDefaultDimensions(entitypose).scale(1.0f / EntityPufferFishNPC.getScale(this.getPuffState())).scale(0.5f);
        }

        protected SoundEvent getHurtSound(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.getHurtSound(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float getJumpPower() {
            return NMS.getJumpPower(this.npc, super.getJumpPower());
        }

        public int getMaxFallDistance() {
            return NMS.getFallDistance(this.npc, super.getMaxFallDistance());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction getPistonPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.getPistonPushReaction();
        }

        public boolean isLeashed() {
            return NMSImpl.isLeashed(this.npc, () -> super.isLeashed(), (Mob)this);
        }

        public boolean isPushable() {
            return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void knockback(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.knockback((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AABB makeBoundingBox() {
            return NMSBoundingBox.makeBB(this.npc, super.makeBoundingBox());
        }

        protected InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.mobInteract(entityhuman, enumhand);
            }
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            if (itemstack.getItem() == Items.WATER_BUCKET && this.isAlive()) {
                return InteractionResult.FAIL;
            }
            return super.mobInteract(entityhuman, enumhand);
        }

        public boolean onClimbable() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.onClimbable();
            }
            return false;
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public void tick() {
            if (this.npc != null) {
                NMSImpl.resetPuffTicks(this);
            }
            super.tick();
            PufferFishTrait trait = null;
            if (this.npc != null && (trait = this.npc.getTraitNullable(PufferFishTrait.class)) != null) {
                this.setPuffState(trait.getPuffState());
            }
        }

        public void travel(Vec3 vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (Mob)this, vec3d)) {
                    super.travel(vec3d);
                }
            } else {
                NMSImpl.flyingMoveLogic((LivingEntity)this, vec3d);
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setDeltaMovement(old);
            }
            return res;
        }

        private static float getScale(int i) {
            switch (i) {
                case 0: {
                    return 0.5f;
                }
                case 1: {
                    return 0.7f;
                }
            }
            return 1.0f;
        }
    }

    public static class PufferFishNPC
    extends CraftPufferFish
    implements ForwardingNPCHolder {
        public PufferFishNPC(EntityPufferFishNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Pufferfish)entity);
        }
    }
}

