/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftBlockDisplay;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;

public class BlockDisplayController
extends MobEntityController {
    public BlockDisplayController() {
        super(EntityBlockDisplayNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        EntityBlockDisplayNPC handle = new EntityBlockDisplayNPC((EntityType<? extends Display.BlockDisplay>)EntityType.BLOCK_DISPLAY, (Level)((CraftWorld)at.getWorld()).getHandle(), npc);
        if (npc != null) {
            ((BlockDisplay)handle.getBukkitEntity()).setBlock(npc.getItemProvider().get().getType().createBlockData());
        }
        return handle.getBukkitEntity();
    }

    public BlockDisplay getBukkitEntity() {
        return (BlockDisplay)super.getBukkitEntity();
    }

    public static class EntityBlockDisplayNPC
    extends Display.BlockDisplay
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityBlockDisplayNPC(EntityType<? extends Display.BlockDisplay> types, Level level) {
            this(types, level, null);
        }

        public EntityBlockDisplayNPC(EntityType<? extends Display.BlockDisplay> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public net.minecraft.world.entity.Entity changeDimension(DimensionTransition transition) {
            if (this.npc == null) {
                return super.changeDimension(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new BlockDisplayNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction getPistonPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.getPistonPushReaction();
        }

        public boolean isPushable() {
            return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB makeBoundingBox() {
            return NMSBoundingBox.makeBB(this.npc, super.makeBoundingBox());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public void tick() {
            super.tick();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setDeltaMovement(old);
            }
            return res;
        }
    }

    public static class BlockDisplayNPC
    extends CraftBlockDisplay
    implements ForwardingNPCHolder {
        public BlockDisplayNPC(EntityBlockDisplayNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Display.BlockDisplay)entity);
        }
    }
}

