/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftBoat;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public org.bukkit.entity.Boat getBukkitEntity() {
        return (org.bukkit.entity.Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends Boat
    implements NPCHolder {
        private float invFriction;
        private float landFriction;
        private Boat.Status lastStatus;
        private final CitizensNPC npc;
        private Boat.Status status;
        private double waterLevel;

        public EntityBoatNPC(EntityType<? extends Boat> types, Level level) {
            this(types, level, null);
        }

        public EntityBoatNPC(EntityType<? extends Boat> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public net.minecraft.world.entity.Entity changeDimension(DimensionTransition transition) {
            if (this.npc == null) {
                return super.changeDimension(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        private boolean checkInWater() {
            AABB axisalignedbb = this.getBoundingBox();
            int i = Mth.floor((double)axisalignedbb.minX);
            int j = Mth.ceil((double)axisalignedbb.maxX);
            int k = Mth.floor((double)axisalignedbb.minY);
            int l = Mth.ceil((double)(axisalignedbb.minY + 0.001));
            int i1 = Mth.floor((double)axisalignedbb.minZ);
            int j1 = Mth.ceil((double)axisalignedbb.maxZ);
            boolean flag = false;
            this.waterLevel = -1.7976931348623157E308;
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.set(k1, l1, i2);
                        FluidState fluid = this.level().getFluidState((BlockPos)blockposition_mutableblockposition);
                        if (!fluid.is(FluidTags.WATER)) continue;
                        float f = (float)l1 + fluid.getHeight((BlockGetter)this.level(), (BlockPos)blockposition_mutableblockposition);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.minY < (double)f;
                    }
                }
            }
            return flag;
        }

        private void floatBoat() {
            double d0 = -this.getGravity();
            double d1 = 0.0;
            this.invFriction = 0.05f;
            if (this.lastStatus == Boat.Status.IN_AIR && this.status != Boat.Status.IN_AIR && this.status != Boat.Status.ON_LAND) {
                this.waterLevel = this.getY(1.0);
                double d2 = (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101;
                if (this.level().noCollision((net.minecraft.world.entity.Entity)this, this.getBoundingBox().move(0.0, d2 - this.getY(), 0.0))) {
                    this.move(MoverType.SELF, new Vec3(0.0, d2 - this.getY(), 0.0));
                    this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                }
                this.status = Boat.Status.IN_WATER;
            } else {
                if (this.status == Boat.Status.IN_WATER) {
                    d1 = (this.waterLevel - this.getY()) / (double)this.getBbHeight();
                    this.invFriction = 0.9f;
                } else if (this.status == Boat.Status.UNDER_FLOWING_WATER) {
                    d0 = -7.0E-4;
                    this.invFriction = 0.9f;
                } else if (this.status == Boat.Status.UNDER_WATER) {
                    d1 = 0.01f;
                    this.invFriction = 0.45f;
                } else if (this.status == Boat.Status.IN_AIR) {
                    this.invFriction = 0.9f;
                } else if (this.status == Boat.Status.ON_LAND) {
                    this.invFriction = this.landFriction;
                    if (this.getControllingPassenger() instanceof Player) {
                        this.landFriction /= 2.0f;
                    }
                }
                Vec3 vec3d = this.getDeltaMovement();
                this.setDeltaMovement(vec3d.x * (double)this.invFriction, vec3d.y + d0, vec3d.z * (double)this.invFriction);
                if (d1 > 0.0) {
                    Vec3 vec3d1 = this.getDeltaMovement();
                    this.setDeltaMovement(vec3d1.x, (vec3d1.y + d1 * (this.getDefaultGravity() / 0.65)) * 0.75, vec3d1.z);
                }
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction getPistonPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.getPistonPushReaction();
        }

        private Boat.Status getStatus() {
            Boat.Status entityboat_Status = this.isUnderwater();
            if (entityboat_Status != null) {
                this.waterLevel = this.getBoundingBox().maxY;
                return entityboat_Status;
            }
            if (this.checkInWater()) {
                return Boat.Status.IN_WATER;
            }
            float f = this.getGroundFriction();
            if (f > 0.0f) {
                this.landFriction = f;
                return Boat.Status.ON_LAND;
            }
            return Boat.Status.IN_AIR;
        }

        public boolean isPushable() {
            return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        private Boat.Status isUnderwater() {
            AABB axisalignedbb = this.getBoundingBox();
            double d0 = axisalignedbb.maxY + 0.001;
            int i = Mth.floor((double)axisalignedbb.minX);
            int j = Mth.ceil((double)axisalignedbb.maxX);
            int k = Mth.floor((double)axisalignedbb.maxY);
            int l = Mth.ceil((double)d0);
            int i1 = Mth.floor((double)axisalignedbb.minZ);
            int j1 = Mth.ceil((double)axisalignedbb.maxZ);
            boolean flag = false;
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.set(k1, l1, i2);
                        FluidState fluid = this.level().getFluidState((BlockPos)blockposition_mutableblockposition);
                        if (!fluid.is(FluidTags.WATER) || !(d0 < (double)((float)blockposition_mutableblockposition.getY() + fluid.getHeight((BlockGetter)this.level(), (BlockPos)blockposition_mutableblockposition)))) continue;
                        if (!fluid.isSource()) {
                            return Boat.Status.UNDER_FLOWING_WATER;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? Boat.Status.UNDER_WATER : null;
        }

        protected AABB makeBoundingBox() {
            return NMSBoundingBox.makeBB(this.npc, super.makeBoundingBox());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void refreshDimensions() {
            if (this.npc == null) {
                super.refreshDimensions();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.firstTick);
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public void tick() {
            if (this.npc != null) {
                this.baseTick();
                if (this.getControllingPassenger() instanceof NPCHolder && ((NPCHolder)this.getControllingPassenger()).getNPC().getNavigator().isNavigating()) {
                    this.setDeltaMovement(this.getControllingPassenger().getDeltaMovement().multiply(20.0, 0.0, 20.0));
                }
                this.npc.update();
                if (this.getHurtTime() > 0) {
                    this.setHurtTime(this.getHurtTime() - 1);
                }
                if (this.getDamage() > 0.0f) {
                    this.setDamage(this.getDamage() - 1.0f);
                }
                this.lastStatus = this.status;
                this.status = this.getStatus();
                this.floatBoat();
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.checkInsideBlocks();
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setDeltaMovement(old);
            }
            return res;
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Boat)entity);
        }
    }
}

