/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftItemFrame;
import org.bukkit.entity.Entity;

public class ItemFrameController
extends MobEntityController {
    public ItemFrameController() {
        super(EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        Entity e = super.createEntity(at, npc);
        ItemFrame item = (ItemFrame)((CraftEntity)e).getHandle();
        item.setDirection(Direction.EAST);
        item.setPos(new Vec3((double)at.getBlockX(), (double)at.getBlockY(), (double)at.getBlockZ()));
        return e;
    }

    public org.bukkit.entity.ItemFrame getBukkitEntity() {
        return (org.bukkit.entity.ItemFrame)super.getBukkitEntity();
    }

    public static class EntityItemFrameNPC
    extends ItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemFrameNPC(EntityType<? extends ItemFrame> types, Level level) {
            this(types, level, null);
        }

        public EntityItemFrameNPC(EntityType<? extends ItemFrame> types, Level level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean broadcastToPlayer(ServerPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.broadcastToPlayer(player));
        }

        public net.minecraft.world.entity.Entity changeDimension(DimensionTransition transition) {
            if (this.npc == null) {
                return super.changeDimension(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ItemFrameNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public PushReaction getPistonPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? PushReaction.IGNORE : super.getPistonPushReaction();
        }

        public boolean isPushable() {
            return this.npc == null ? super.isPushable() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AABB makeBoundingBox() {
            return NMSBoundingBox.makeBB(this.npc, super.makeBoundingBox());
        }

        public void push(net.minecraft.world.entity.Entity entity) {
            super.push(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean save(CompoundTag save) {
            return this.npc == null ? super.save(save) : false;
        }

        public boolean survives() {
            return this.npc == null || !this.npc.isProtected() ? super.survives() : true;
        }

        public void tick() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.tick();
            }
        }

        public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> tagkey, double d0) {
            if (this.npc == null) {
                return super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            }
            Vec3 old = this.getDeltaMovement().add(0.0, 0.0, 0.0);
            boolean res = super.updateFluidHeightAndDoFluidPushing(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.setDeltaMovement(old);
            }
            return res;
        }
    }

    public static class ItemFrameNPC
    extends CraftItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemFrameNPC(EntityItemFrameNPC entity) {
            super((CraftServer)Bukkit.getServer(), (ItemFrame)entity);
            this.npc = entity.npc;
            this.setItem(this.npc.getItemProvider().get());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

