/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import java.util.Random;
import net.citizensnpcs.util.NMS;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.entity.Entity;

public class EntityMoveControl
extends MoveControl {
    protected LivingEntity entity;
    private int jumpTicks;
    protected boolean moving;
    protected double speedMod;
    protected double tx;
    protected double ty;
    protected double tz;

    public EntityMoveControl(LivingEntity entityinsentient) {
        super((Mob)(entityinsentient instanceof Mob ? (Mob)entityinsentient : new Slime(EntityType.SLIME, entityinsentient.level())));
        this.entity = entityinsentient;
        this.tx = entityinsentient.getX();
        this.ty = entityinsentient.getY();
        this.tz = entityinsentient.getZ();
    }

    public double getSpeedModifier() {
        return this.speedMod;
    }

    public double getWantedX() {
        return this.tx;
    }

    public double getWantedY() {
        return this.ty;
    }

    public double getWantedZ() {
        return this.tz;
    }

    public boolean hasWanted() {
        return this.moving;
    }

    protected float rotlerp(float f, float f1, float f2) {
        float f4;
        float f3 = Mth.wrapDegrees((float)(f1 - f));
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        if ((f4 = f + f3) < 0.0f) {
            f4 += 360.0f;
        } else if (f4 > 360.0f) {
            f4 -= 360.0f;
        }
        return f4;
    }

    public void setWantedPosition(double d0, double d1, double d2, double d3) {
        this.tx = d0;
        this.ty = d1;
        this.tz = d2;
        this.speedMod = d3;
        this.moving = true;
    }

    public void tick() {
        this.entity.zza = 0.0f;
        if (!this.moving) {
            return;
        }
        this.moving = false;
        double dX = this.tx - this.entity.getX();
        double dZ = this.tz - this.entity.getZ();
        double dY = this.ty - this.entity.getY();
        double dXZ = Math.sqrt(dX * dX + dZ * dZ);
        double dXYZ = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        if (dXYZ < 2.500000277905201E-7) {
            return;
        }
        if (dXZ > 0.4) {
            float f = (float)Math.toDegrees(Mth.atan2((double)dZ, (double)dX)) - 90.0f;
            this.entity.setYRot(this.rotlerp(this.entity.getYRot(), f, 90.0f));
            NMS.setHeadYaw((Entity)this.entity.getBukkitEntity(), this.entity.getYRot());
        }
        this.entity.zza = (float)(this.speedMod * this.entity.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue());
        this.entity.setSpeed(this.entity.zza);
        if (this.entity instanceof Slime && this.jumpTicks-- <= 0) {
            this.jumpTicks = new Random().nextInt(20) + 10;
            if (((Slime)this.entity).isAggressive()) {
                this.jumpTicks /= 3;
            }
            ((Slime)this.entity).getJumpControl().jump();
            return;
        }
        BlockPos pos = this.entity.blockPosition();
        BlockState bs = this.entity.level().getBlockState(pos);
        VoxelShape vs = bs.getCollisionShape((BlockGetter)this.entity.level(), pos);
        if (dY >= (double)this.entity.maxUpStep() && dXZ < (double)Math.max(1.0f, this.entity.getBbWidth()) || !vs.isEmpty() && this.entity.getY() < vs.max(Direction.Axis.Y) + (double)pos.getY() && !bs.is(BlockTags.DOORS) && !bs.is(BlockTags.FENCES)) {
            NMS.setShouldJump((Entity)this.entity.getBukkitEntity());
        }
    }
}

