/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R1.util.EntityNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.Target;

public class EntityPathfinder
extends PathFinder {
    private final int maxVisitedNodes;
    private final Node[] neighbors = new Node[32];
    private final EntityNodeEvaluator nodeEvaluator;
    private final BinaryHeap openSet = new BinaryHeap();

    public EntityPathfinder(EntityNodeEvaluator var0, int var1) {
        super((NodeEvaluator)var0, var1);
        this.nodeEvaluator = var0;
        this.maxVisitedNodes = var1;
    }

    public Path findPath(PathNavigationRegion var0, LivingEntity var1, Set<BlockPos> var2, float var3, int var4, float var5) {
        this.openSet.clear();
        this.nodeEvaluator.prepare(var0, var1);
        Node var6 = this.nodeEvaluator.getStart();
        if (var6 == null) {
            return null;
        }
        Map<Target, BlockPos> var7 = var2.stream().collect(Collectors.toMap(var0x -> this.nodeEvaluator.getTarget(var0x.getX(), var0x.getY(), var0x.getZ()), Function.identity()));
        Path var8 = this.findPath(var0.getProfiler(), var6, var7, var3, var4, var5);
        this.nodeEvaluator.done();
        return var8;
    }

    public Path findPath(PathNavigationRegion var0, Mob var1, Set<BlockPos> var2, float var3, int var4, float var5) {
        this.openSet.clear();
        this.nodeEvaluator.prepare(var0, var1);
        Node var6 = this.nodeEvaluator.getStart();
        if (var6 == null) {
            return null;
        }
        Map<Target, BlockPos> var7 = var2.stream().collect(Collectors.toMap(var0x -> this.nodeEvaluator.getTarget(var0x.getX(), var0x.getY(), var0x.getZ()), Function.identity()));
        Path var8 = this.findPath(var0.getProfiler(), var6, var7, var3, var4, var5);
        this.nodeEvaluator.done();
        return var8;
    }

    private Path findPath(ProfilerFiller var0, Node var1, Map<Target, BlockPos> var2, float range, int reachRange, float var5) {
        Object var11;
        Set<Target> var6 = var2.keySet();
        var1.g = 0.0f;
        var1.f = var1.h = this.getBestH(var1, var6);
        this.openSet.clear();
        this.openSet.insert(var1);
        ImmutableSet var7 = ImmutableSet.of();
        int var8 = 0;
        HashSet var9 = Sets.newHashSetWithExpectedSize((int)var6.size());
        int var10 = (int)((float)this.maxVisitedNodes * var5);
        while (!this.openSet.isEmpty() && ++var8 < var10) {
            var11 = this.openSet.pop();
            ((Node)var11).closed = true;
            for (Target var13t : var6) {
                if (!(var11.distanceManhattan((Node)var13t) <= (float)reachRange)) continue;
                var13t.setReached();
                var9.add(var13t);
            }
            if (!var9.isEmpty()) break;
            if (!(var11.distanceTo(var1) < range)) continue;
            int var12 = this.nodeEvaluator.getNeighbors(this.neighbors, (Node)var11);
            for (int i = 0; i < var12; ++i) {
                Node var14 = this.neighbors[i];
                float var15 = this.distance((Node)var11, var14);
                var14.walkedDistance = ((Node)var11).walkedDistance + var15;
                float var16 = ((Node)var11).g + var15 + var14.costMalus;
                if (!(var14.walkedDistance < range) || var14.inOpenSet() && !(var16 < var14.g)) continue;
                var14.cameFrom = var11;
                var14.g = var16;
                var14.h = this.getBestH(var14, var6) * 1.5f;
                if (var14.inOpenSet()) {
                    this.openSet.changeCost(var14, var14.g + var14.h);
                    continue;
                }
                var14.f = var14.g + var14.h;
                this.openSet.insert(var14);
            }
        }
        Optional<Object> optional = var11 = !var9.isEmpty() ? var9.stream().map(var1x -> this.reconstructPath(var1x.getBestNode(), (BlockPos)var2.get(var1x), true)).min(Comparator.comparingInt(Path::getNodeCount)) : this.getFallbackDestinations(var2, var6);
        if (((Optional)var11).isEmpty()) {
            return null;
        }
        Path var12 = (Path)((Optional)var11).get();
        return var12;
    }

    private float getBestH(Node var0, Set<Target> var1) {
        float var2 = Float.MAX_VALUE;
        for (Target var4 : var1) {
            float var5 = var0.distanceTo((Node)var4);
            var4.updateBest(var5, var0);
            var2 = Math.min(var5, var2);
        }
        return var2;
    }

    public Optional<Path> getFallbackDestinations(Map<Target, BlockPos> var1, Set<Target> var5) {
        if (Settings.Setting.DISABLE_MC_NAVIGATION_FALLBACK.asBoolean()) {
            return Optional.empty();
        }
        return var5.stream().map(var1x -> this.reconstructPath(var1x.getBestNode(), (BlockPos)var1.get(var1x), false)).min(Comparator.comparingDouble(Path::getDistToTarget).thenComparingInt(Path::getNodeCount));
    }

    private Path reconstructPath(Node var0, BlockPos var1, boolean var2) {
        ArrayList var3 = Lists.newArrayList();
        Node var4 = var0;
        var3.add(0, var0);
        while (var4.cameFrom != null) {
            var4 = var4.cameFrom;
            var3.add(0, var4);
        }
        return new Path((List)var3, var1, var2);
    }
}

