/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R1.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_21_R1.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R1.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public JumpControl getJumpControl();

    public Map<PathType, Float> getMalus();

    public MoveControl getMoveControl();

    public PathNavigation getNavigation();

    default public float getPathfindingMalus(PathType var1) {
        Map<PathType, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.getMalus();
    }

    default public void setPathfindingMalus(PathType water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().tick();
        this.getMoveControl().tick();
        PathNavigation nav = this.getNavigation();
        if (!nav.isDone()) {
            nav.tick();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((LivingEntity)NMSImpl.getHandle(this.getBukkitEntity())).getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)range);
    }

    public static MobAI from(net.minecraft.world.entity.Entity handle) {
        if (handle instanceof Mob) {
            final Mob mob = (Mob)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public JumpControl getJumpControl() {
                    return mob.getJumpControl();
                }

                @Override
                public Map<PathType, Float> getMalus() {
                    return null;
                }

                @Override
                public MoveControl getMoveControl() {
                    return mob.getMoveControl();
                }

                @Override
                public PathNavigation getNavigation() {
                    return mob.getNavigation();
                }

                @Override
                public float getPathfindingMalus(PathType var1) {
                    return mob.getPathfindingMalus(var1);
                }

                @Override
                public void setPathfindingMalus(PathType water, float oldWaterCost) {
                    mob.setPathfindingMalus(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.getSensing().tick();
                    mob.getNavigation().tick();
                    mob.getMoveControl().tick();
                    mob.getLookControl().tick();
                    mob.getJumpControl().tick();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public JumpControl getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<PathType, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public MoveControl getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public PathNavigation getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final LivingEntity entity;
        private final Map<PathType, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(LivingEntity entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (Holder<Attribute>)Attributes.FOLLOW_RANGE, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.level());
            this.malus = Maps.newEnumMap(PathType.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public JumpControl getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<PathType, Float> getMalus() {
            return this.malus;
        }

        @Override
        public MoveControl getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public PathNavigation getNavigation() {
            return this.navigation;
        }
    }
}

