/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.client.MinecraftClient;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.datafixers.util.Pair;
import com.mojang.util.UndashedUuid;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R1.entity.AllayController;
import net.citizensnpcs.nms.v1_21_R1.entity.ArmadilloController;
import net.citizensnpcs.nms.v1_21_R1.entity.ArmorStandController;
import net.citizensnpcs.nms.v1_21_R1.entity.AxolotlController;
import net.citizensnpcs.nms.v1_21_R1.entity.BatController;
import net.citizensnpcs.nms.v1_21_R1.entity.BeeController;
import net.citizensnpcs.nms.v1_21_R1.entity.BlazeController;
import net.citizensnpcs.nms.v1_21_R1.entity.BoggedController;
import net.citizensnpcs.nms.v1_21_R1.entity.BreezeController;
import net.citizensnpcs.nms.v1_21_R1.entity.CamelController;
import net.citizensnpcs.nms.v1_21_R1.entity.CatController;
import net.citizensnpcs.nms.v1_21_R1.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_21_R1.entity.ChickenController;
import net.citizensnpcs.nms.v1_21_R1.entity.CodController;
import net.citizensnpcs.nms.v1_21_R1.entity.CowController;
import net.citizensnpcs.nms.v1_21_R1.entity.CreeperController;
import net.citizensnpcs.nms.v1_21_R1.entity.DolphinController;
import net.citizensnpcs.nms.v1_21_R1.entity.DrownedController;
import net.citizensnpcs.nms.v1_21_R1.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_21_R1.entity.EndermanController;
import net.citizensnpcs.nms.v1_21_R1.entity.EndermiteController;
import net.citizensnpcs.nms.v1_21_R1.entity.EvokerController;
import net.citizensnpcs.nms.v1_21_R1.entity.FoxController;
import net.citizensnpcs.nms.v1_21_R1.entity.FrogController;
import net.citizensnpcs.nms.v1_21_R1.entity.GhastController;
import net.citizensnpcs.nms.v1_21_R1.entity.GiantController;
import net.citizensnpcs.nms.v1_21_R1.entity.GlowSquidController;
import net.citizensnpcs.nms.v1_21_R1.entity.GoatController;
import net.citizensnpcs.nms.v1_21_R1.entity.GuardianController;
import net.citizensnpcs.nms.v1_21_R1.entity.GuardianElderController;
import net.citizensnpcs.nms.v1_21_R1.entity.HoglinController;
import net.citizensnpcs.nms.v1_21_R1.entity.HorseController;
import net.citizensnpcs.nms.v1_21_R1.entity.HorseDonkeyController;
import net.citizensnpcs.nms.v1_21_R1.entity.HorseMuleController;
import net.citizensnpcs.nms.v1_21_R1.entity.HorseSkeletonController;
import net.citizensnpcs.nms.v1_21_R1.entity.HorseZombieController;
import net.citizensnpcs.nms.v1_21_R1.entity.HumanController;
import net.citizensnpcs.nms.v1_21_R1.entity.IllusionerController;
import net.citizensnpcs.nms.v1_21_R1.entity.IronGolemController;
import net.citizensnpcs.nms.v1_21_R1.entity.LlamaController;
import net.citizensnpcs.nms.v1_21_R1.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_21_R1.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_21_R1.entity.OcelotController;
import net.citizensnpcs.nms.v1_21_R1.entity.PandaController;
import net.citizensnpcs.nms.v1_21_R1.entity.ParrotController;
import net.citizensnpcs.nms.v1_21_R1.entity.PhantomController;
import net.citizensnpcs.nms.v1_21_R1.entity.PigController;
import net.citizensnpcs.nms.v1_21_R1.entity.PigZombieController;
import net.citizensnpcs.nms.v1_21_R1.entity.PiglinBruteController;
import net.citizensnpcs.nms.v1_21_R1.entity.PiglinController;
import net.citizensnpcs.nms.v1_21_R1.entity.PillagerController;
import net.citizensnpcs.nms.v1_21_R1.entity.PolarBearController;
import net.citizensnpcs.nms.v1_21_R1.entity.PufferFishController;
import net.citizensnpcs.nms.v1_21_R1.entity.RabbitController;
import net.citizensnpcs.nms.v1_21_R1.entity.RavagerController;
import net.citizensnpcs.nms.v1_21_R1.entity.SalmonController;
import net.citizensnpcs.nms.v1_21_R1.entity.SheepController;
import net.citizensnpcs.nms.v1_21_R1.entity.ShulkerController;
import net.citizensnpcs.nms.v1_21_R1.entity.SilverfishController;
import net.citizensnpcs.nms.v1_21_R1.entity.SkeletonController;
import net.citizensnpcs.nms.v1_21_R1.entity.SkeletonStrayController;
import net.citizensnpcs.nms.v1_21_R1.entity.SkeletonWitherController;
import net.citizensnpcs.nms.v1_21_R1.entity.SlimeController;
import net.citizensnpcs.nms.v1_21_R1.entity.SnifferController;
import net.citizensnpcs.nms.v1_21_R1.entity.SnowmanController;
import net.citizensnpcs.nms.v1_21_R1.entity.SpiderController;
import net.citizensnpcs.nms.v1_21_R1.entity.SquidController;
import net.citizensnpcs.nms.v1_21_R1.entity.StriderController;
import net.citizensnpcs.nms.v1_21_R1.entity.TadpoleController;
import net.citizensnpcs.nms.v1_21_R1.entity.TraderLlamaController;
import net.citizensnpcs.nms.v1_21_R1.entity.TropicalFishController;
import net.citizensnpcs.nms.v1_21_R1.entity.TurtleController;
import net.citizensnpcs.nms.v1_21_R1.entity.VexController;
import net.citizensnpcs.nms.v1_21_R1.entity.VillagerController;
import net.citizensnpcs.nms.v1_21_R1.entity.VindicatorController;
import net.citizensnpcs.nms.v1_21_R1.entity.WanderingTraderController;
import net.citizensnpcs.nms.v1_21_R1.entity.WardenController;
import net.citizensnpcs.nms.v1_21_R1.entity.WitchController;
import net.citizensnpcs.nms.v1_21_R1.entity.WitherController;
import net.citizensnpcs.nms.v1_21_R1.entity.WolfController;
import net.citizensnpcs.nms.v1_21_R1.entity.ZoglinController;
import net.citizensnpcs.nms.v1_21_R1.entity.ZombieController;
import net.citizensnpcs.nms.v1_21_R1.entity.ZombieHuskController;
import net.citizensnpcs.nms.v1_21_R1.entity.ZombieVillagerController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.AreaEffectCloudController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.BlockDisplayController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.BreezeWindChargeController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ChestBoatController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.DragonFireballController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.EvokerFangsController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ExperienceOrbController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.EyeOfEnderController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.GlowItemFrameController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.InteractionController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ItemDisplayController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.LlamaSpitController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MarkerController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartSpawnerController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.OminousItemSpawnerController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ShulkerBulletController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.SpectralArrowController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.TextDisplayController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ThrownPotionController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.ThrownTridentController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.TippedArrowController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.WindChargeController;
import net.citizensnpcs.nms.v1_21_R1.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_21_R1.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_21_R1.util.CitizensEntityTracker;
import net.citizensnpcs.nms.v1_21_R1.util.CustomEntityRegistry;
import net.citizensnpcs.nms.v1_21_R1.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R1.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R1.util.MobAI;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.PlayerAnimationImpl;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.versioned.AllayTrait;
import net.citizensnpcs.trait.versioned.AreaEffectCloudTrait;
import net.citizensnpcs.trait.versioned.ArmadilloTrait;
import net.citizensnpcs.trait.versioned.AxolotlTrait;
import net.citizensnpcs.trait.versioned.BeeTrait;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import net.citizensnpcs.trait.versioned.CamelTrait;
import net.citizensnpcs.trait.versioned.CatTrait;
import net.citizensnpcs.trait.versioned.DisplayTrait;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.trait.versioned.FoxTrait;
import net.citizensnpcs.trait.versioned.FrogTrait;
import net.citizensnpcs.trait.versioned.GoatTrait;
import net.citizensnpcs.trait.versioned.LlamaTrait;
import net.citizensnpcs.trait.versioned.MushroomCowTrait;
import net.citizensnpcs.trait.versioned.PandaTrait;
import net.citizensnpcs.trait.versioned.ParrotTrait;
import net.citizensnpcs.trait.versioned.PhantomTrait;
import net.citizensnpcs.trait.versioned.PiglinTrait;
import net.citizensnpcs.trait.versioned.PolarBearTrait;
import net.citizensnpcs.trait.versioned.PufferFishTrait;
import net.citizensnpcs.trait.versioned.ShulkerTrait;
import net.citizensnpcs.trait.versioned.SnifferTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.trait.versioned.SpellcasterTrait;
import net.citizensnpcs.trait.versioned.TextDisplayTrait;
import net.citizensnpcs.trait.versioned.TropicalFishTrait;
import net.citizensnpcs.trait.versioned.VillagerTrait;
import net.citizensnpcs.trait.versioned.WardenTrait;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.boss.CraftBossBar;
import org.bukkit.craftbukkit.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.inventory.view.CraftAnvilView;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Tameable;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final MethodHandle ARMADILLO_SCUTE_TIME = NMS.getSetter(Armadillo.class, "cn");
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP = NMS.getFirstGetter(AttributeSupplier.class, Map.class);
    private static final MethodHandle ATTRIBUTE_PROVIDER_MAP_SETTER = NMS.getFirstFinalSetter(AttributeSupplier.class, Map.class);
    private static final MethodHandle ATTRIBUTE_SUPPLIER = NMS.getFirstGetter(AttributeMap.class, AttributeSupplier.class);
    private static final MethodHandle AVAILABLE_BEHAVIORS_BY_PRIORITY = NMS.getGetter(Brain.class, "f");
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.POLAR_BEAR, new EntityType[]{EntityType.BEE, EntityType.SILVERFISH, EntityType.SHULKER, EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.DOLPHIN, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST, EntityType.SHULKER, EntityType.PHANTOM});
    private static final MethodHandle BUKKITENTITY_FIELD_SETTER = NMS.getSetter(net.minecraft.world.entity.Entity.class, "bukkitEntity");
    private static final MethodHandle CHUNKMAP_UPDATE_PLAYER_STATUS = NMS.getMethodHandle(ChunkMap.class, "a", true, ServerPlayer.class, Boolean.TYPE);
    private static final Map<Class<?>, net.minecraft.world.entity.EntityType<?>> CITIZENS_ENTITY_TYPES = Maps.newHashMap();
    public static final MethodHandle CONNECTION_DISCONNECT_LISTENER = NMS.getSetter(Connection.class, "p");
    public static final MethodHandle CONNECTION_PACKET_LISTENER = NMS.getSetter(Connection.class, "q");
    private static final MethodHandle CRAFT_BOSSBAR_HANDLE_FIELD = NMS.getFirstSetter(CraftBossBar.class, ServerBossEvent.class);
    private static EntityDataAccessor<Boolean> DATA_NAME_VISIBLE = null;
    private static EntityDataAccessor<Pose> DATA_POSE = null;
    private static final float DEFAULT_SPEED = 1.0f;
    public static final MethodHandle ENDERDRAGON_CHECK_WALLS = NMS.getFirstMethodHandleWithReturnType(EnderDragon.class, true, Boolean.TYPE, AABB.class);
    public static final MethodHandle ENDERDRAGON_HURT = NMS.getMethodHandle(EnderDragon.class, "b", true, List.class);
    public static final MethodHandle ENDERDRAGON_KNOCKBACK = NMS.getMethodHandle(EnderDragon.class, "a", true, ServerLevel.class, List.class);
    private static EntityDataAccessor<Boolean> ENDERMAN_CREEPY = null;
    private static final MethodHandle ENTITY_EYE_HEIGHT = NMS.getSetter(net.minecraft.world.entity.Entity.class, "be");
    private static final MethodHandle ENTITY_FISH_NUM_IN_SCHOOL = NMS.getFirstSetter(AbstractSchoolingFish.class, Integer.TYPE);
    private static MethodHandle ENTITY_NAVIGATION = NMS.getFirstSetter(Mob.class, PathNavigation.class);
    private static CustomEntityRegistry ENTITY_REGISTRY;
    private static MethodHandle ENTITY_REGISTRY_SETTER;
    private static final MethodHandle FALLING_BLOCK_STATE_SETTER;
    private static final MethodHandle FISHING_HOOK_LIFE;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_GETTER;
    private static final MethodHandle FLYING_MOVECONTROL_FLOAT_SETTER;
    public static final MethodHandle FOX_SET_FACEPLANTED;
    private static final Location FROM_LOCATION;
    private static EntityDataAccessor<Float> INTERACTION_HEIGHT;
    private static EntityDataAccessor<Float> INTERACTION_WIDTH;
    private static final MethodHandle JUMP_FIELD;
    private static final MethodHandle LOOK_CONTROL_SETTER;
    private static MethodHandle META_COMPOUND_TAG;
    private static final MethodHandle MINECRAFT_CLIENT;
    private static final MethodHandle MOVE_CONTROLLER_OPERATION;
    private static final MethodHandle NAVIGATION_CREATE_PATHFINDER;
    private static final MethodHandle NAVIGATION_PATH;
    private static final MethodHandle NAVIGATION_PATHFINDER;
    private static final MethodHandle NAVIGATION_WORLD_FIELD;
    public static final MethodHandle PAPER_PLAYER_MOB_COUNTS;
    private static final MethodHandle PLAYER_INFO_ENTRIES_LIST;
    private static final MethodHandle PLAYERINFO_ENTRIES;
    private static final MethodHandle POSITION_CODEC_GETTER;
    private static final MethodHandle PUFFERFISH_DEFLATE;
    private static final MethodHandle PUFFERFISH_INFLATE;
    public static EntityDataAccessor<Integer> RABBIT_TYPE_DATAWATCHER;
    private static final Random RANDOM;
    private static final MethodHandle SERVER_ENTITY_GETTER;
    private static MethodHandle SET_PROFILE_METHOD;
    private static final MethodHandle SIZE_FIELD_GETTER;
    private static final MethodHandle SIZE_FIELD_SETTER;
    private static MethodHandle SKULL_META_PROFILE;
    private static MethodHandle TEAM_FIELD;
    private static final Collection<MethodHandle> TRACKED_ENTITY_SETTERS;

    public NMSImpl() {
        this.loadEntityTypes();
    }

    @Override
    public void activate(Entity entity) {
        NMSImpl.getHandle((Entity)entity).activatedTick = MinecraftServer.currentTick;
    }

    @Override
    public boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason custom) {
        int viewDistance = -1;
        ChunkMap chunkMap = null;
        if (entity instanceof org.bukkit.entity.Player) {
            chunkMap = ((ServerChunkCache)NMSImpl.getHandle((Entity)entity).level().getChunkSource()).chunkMap;
            viewDistance = chunkMap.serverViewDistance;
            chunkMap.serverViewDistance = -1;
        }
        boolean success = NMSImpl.getHandle(entity).level().addFreshEntity(NMSImpl.getHandle(entity), custom);
        if (chunkMap != null) {
            chunkMap.serverViewDistance = viewDistance;
        }
        return success;
    }

    @Override
    public void addOrRemoveFromPlayerList(Entity entity, boolean remove) {
        if (entity == null) {
            return;
        }
        ServerPlayer handle = (ServerPlayer)NMSImpl.getHandle(entity);
        if (handle.level() == null) {
            return;
        }
        List players = handle.level().players();
        boolean changed = false;
        if (remove && players.contains(handle)) {
            players.remove(handle);
            changed = true;
        } else if (!remove && !players.contains(handle)) {
            players.add(handle);
            changed = true;
        }
        if (!changed) {
            return;
        }
        try {
            CHUNKMAP_UPDATE_PLAYER_STATUS.invoke(((ServerLevel)handle.level()).getChunkSource().chunkMap, handle, !remove);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void attack(org.bukkit.entity.LivingEntity attacker, org.bukkit.entity.LivingEntity btarget) {
        LivingEntity source = NMSImpl.getHandle(attacker);
        LivingEntity target = NMSImpl.getHandle(btarget);
        if (source instanceof Player) {
            ((Player)source).attack((net.minecraft.world.entity.Entity)target);
            PlayerAnimation.ARM_SWING.play((org.bukkit.entity.Player)source.getBukkitEntity());
            return;
        }
        boolean hasAttackDamage = source.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE);
        if (source instanceof Mob && hasAttackDamage) {
            ((Mob)source).doHurtTarget((net.minecraft.world.entity.Entity)target);
            return;
        }
        float f = (float)(hasAttackDamage ? source.getAttributeValue(Attributes.ATTACK_DAMAGE) : 1.0);
        DamageSource ds = target.damageSources().mobAttack(source);
        f = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)source.level()), (net.minecraft.world.item.ItemStack)source.getWeaponItem(), (net.minecraft.world.entity.Entity)target, (DamageSource)ds, (float)f);
        boolean flag = target.hurt(target.damageSources().mobAttack(source), f);
        if (!flag) {
            return;
        }
        float k = EnchantmentHelper.modifyKnockback((ServerLevel)((ServerLevel)source.level()), (net.minecraft.world.item.ItemStack)source.getWeaponItem(), (net.minecraft.world.entity.Entity)target, (DamageSource)ds, (float)((float)source.getAttributeValue(Attributes.ATTACK_KNOCKBACK)));
        if (k > 0.0f) {
            target.knockback((double)(k * 0.5f), (double)Mth.sin((float)(source.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(source.getYRot() * ((float)Math.PI / 180)))), (net.minecraft.world.entity.Entity)source, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
            source.setDeltaMovement(source.getDeltaMovement().multiply(0.6, 1.0, 0.6));
        }
        source.setLastHurtMob((net.minecraft.world.entity.Entity)target);
        EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)source.level()), (net.minecraft.world.entity.Entity)target, (DamageSource)ds);
    }

    @Override
    public void cancelMoveDestination(Entity entity) {
        MobAI ai = MobAI.from(NMSImpl.getHandle(entity));
        if (ai == null) {
            return;
        }
        MoveControl control = ai.getMoveControl();
        if (control instanceof EntityMoveControl) {
            ((EntityMoveControl)control).moving = false;
        } else {
            try {
                MOVE_CONTROLLER_OPERATION.invoke(control, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public Iterable<Object> createBundlePacket(List source) {
        return source.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)new ClientboundBundlePacket((Iterable)source));
    }

    @Override
    public EntityPacketTracker createPacketTracker(Entity entity, final EntityPacketTracker.PacketAggregator agg) {
        final net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        final Set linked = Sets.newIdentityHashSet();
        final ServerEntity tracker = new ServerEntity((ServerLevel)handle.level(), handle, handle.getType().updateInterval(), handle.getType().trackDeltas(), agg::send, linked);
        final EnumMap equipment = Maps.newEnumMap(EquipmentSlot.class);
        return new EntityPacketTracker(){

            @Override
            public void link(org.bukkit.entity.Player player) {
                ServerPlayer p = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player);
                handle.unsetRemoved();
                tracker.addPairing(p);
                linked.add(p.connection);
                agg.add(p.getUUID(), packet -> p.connection.send((Packet)packet));
            }

            @Override
            public void run() {
                if (handle instanceof LivingEntity) {
                    boolean changed = false;
                    LivingEntity entity = (LivingEntity)handle;
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        net.minecraft.world.item.ItemStack old = equipment.getOrDefault(slot, net.minecraft.world.item.ItemStack.EMPTY);
                        net.minecraft.world.item.ItemStack curr = entity.getItemBySlot(slot);
                        if (!changed && entity.equipmentHasChanged(old, curr)) {
                            changed = true;
                        }
                        equipment.put(slot, curr);
                    }
                    if (changed) {
                        ArrayList vals = Lists.newArrayList();
                        for (EquipmentSlot slot : EquipmentSlot.values()) {
                            vals.add(Pair.of((Object)slot, (Object)((net.minecraft.world.item.ItemStack)equipment.get(slot))));
                        }
                        agg.send(new ClientboundSetEquipmentPacket(handle.getId(), (List)vals));
                    }
                }
                tracker.sendChanges();
            }

            @Override
            public void unlink(org.bukkit.entity.Player player) {
                ServerPlayer p = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player);
                tracker.removePairing(p);
                linked.remove(p.connection);
                agg.removeConnection(p.getUUID());
            }

            @Override
            public void unlinkAll(Consumer<org.bukkit.entity.Player> callback) {
                handle.remove(Entity.RemovalReason.KILLED);
                for (ServerPlayerConnection link : Lists.newArrayList((Iterable)linked)) {
                    CraftPlayer entity = link.getPlayer().getBukkitEntity();
                    this.unlink((org.bukkit.entity.Player)entity);
                    if (callback == null) continue;
                    callback.accept((org.bukkit.entity.Player)entity);
                }
                linked.clear();
            }
        };
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) throws Throwable {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService sessionService = ((CraftServer)Bukkit.getServer()).getServer().getSessionService();
        if (!(sessionService instanceof YggdrasilMinecraftSessionService)) {
            return sessionService.fetchProfile(profile.getId(), requireSecure).profile();
        }
        URL url = HttpAuthenticationService.constantURL((String)(this.getAuthServerBaseUrl() + UndashedUuid.toString((UUID)profile.getId())));
        url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure));
        MinecraftClient client = MINECRAFT_CLIENT.invoke(sessionService);
        MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)client.get(url, MinecraftProfilePropertiesResponse.class);
        return response.toProfile();
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    @Override
    public BlockBreaker getBlockBreaker(Entity entity, org.bukkit.block.Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return new CitizensBlockBreaker(entity, targetBlock, config);
    }

    public BossBar getBossBar(Entity entity) {
        ServerBossEvent bserver = null;
        try {
            EndDragonFight df;
            if (entity.getType() == EntityType.WITHER) {
                bserver = ((WitherBoss)NMSImpl.getHandle((Entity)entity)).bossEvent;
            } else if (entity.getType() == EntityType.ENDER_DRAGON && (df = ((EnderDragon)NMSImpl.getHandle(entity)).getDragonFight()) != null) {
                bserver = df.dragonEvent;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (bserver == null) {
            return null;
        }
        BossBar ret = Bukkit.createBossBar((String)"", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        try {
            CRAFT_BOSSBAR_HANDLE_FIELD.invoke(ret, bserver);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public BoundingBox getBoundingBox(Entity handle) {
        return NMSBoundingBox.wrap(NMSImpl.getHandle(handle).getBoundingBox());
    }

    @Override
    public BoundingBox getCollisionBox(Object data) {
        return NMSBoundingBox.wrap(((CraftBlockData)data).getState().getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, CollisionContext.empty()).bounds());
    }

    @Override
    public BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        ServerLevel world = ((CraftWorld)block.getWorld()).getHandle();
        VoxelShape shape = ((CraftBlock)block).getNMS().getCollisionShape((BlockGetter)world, ((CraftBlock)block).getPosition());
        return shape.isEmpty() ? BoundingBox.EMPTY : NMSBoundingBox.wrap(shape.bounds());
    }

    @Override
    public Map<String, Object> getComponentMap(ItemStack item) {
        CompoundTag ct;
        Serializable base;
        if (META_COMPOUND_TAG == null) {
            base = item.getItemMeta().getClass();
            while (!((Class)base).getName().contains("CraftMetaItem")) {
                base = ((Class)base).getSuperclass();
            }
            META_COMPOUND_TAG = NMS.getGetter(base, "customTag");
        }
        base = Maps.newHashMap(NMSBridge.super.getComponentMap(item));
        try {
            ct = META_COMPOUND_TAG.invoke(item.getItemMeta());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return base;
        }
        if (ct == null) {
            return base;
        }
        base.put("custom_data", NMSImpl.deserialiseNBT((Tag)ct));
        return base;
    }

    @Override
    public Location getDestination(Entity entity) {
        MoveControl controller;
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        MobAI ai = MobAI.from(handle);
        MoveControl moveControl = controller = ai != null ? ai.getMoveControl() : null;
        if (controller == null || !controller.hasWanted()) {
            return null;
        }
        return new Location(entity.getWorld(), controller.getWantedX(), controller.getWantedY(), controller.getWantedZ());
    }

    @Override
    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().getProfileRepository();
    }

    @Override
    public float getHeadYaw(Entity entity) {
        if (!(entity instanceof org.bukkit.entity.LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((org.bukkit.entity.LivingEntity)entity).getYHeadRot();
    }

    @Override
    public float getHorizontalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        LivingEntity handle = NMSImpl.getHandle((org.bukkit.entity.LivingEntity)entity);
        return handle.zza;
    }

    @Override
    public EntityPacketTracker getPacketTracker(Entity entity) {
        ServerLevel server = (ServerLevel)NMSImpl.getHandle(entity).level();
        final ChunkMap.TrackedEntity tracked = (ChunkMap.TrackedEntity)server.getChunkSource().chunkMap.entityMap.get(entity.getEntityId());
        if (tracked == null) {
            return null;
        }
        return new EntityPacketTracker(){

            @Override
            public void link(org.bukkit.entity.Player player) {
                tracked.updatePlayer((ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player));
            }

            @Override
            public void run() {
            }

            @Override
            public void unlink(org.bukkit.entity.Player player) {
                tracked.removePlayer((ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player));
            }

            @Override
            public void unlinkAll(Consumer<org.bukkit.entity.Player> callback) {
                tracked.broadcastRemoved();
            }
        };
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null || handle.passengers == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)handle.passengers, net.minecraft.world.entity.Entity::getBukkitEntity);
    }

    @Override
    public GameProfile getProfile(org.bukkit.entity.Player player) {
        return ((Player)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player)).getGameProfile();
    }

    @Override
    public GameProfile getProfile(SkullMeta meta) {
        if (SKULL_META_PROFILE == null && (SKULL_META_PROFILE = NMS.getFirstGetter(meta.getClass(), GameProfile.class)) == null) {
            return null;
        }
        try {
            return SKULL_META_PROFILE.invoke(meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public float getRidingHeightOffset(Entity entity, Entity mount) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return (float)(handle.getPassengerRidingPosition((net.minecraft.world.entity.Entity)NMSImpl.getHandle((Entity)mount)).y - handle.position().y);
    }

    @Override
    public String getSoundPath(Sound flag) throws CommandException {
        try {
            SoundEvent effect = CraftSound.bukkitToMinecraft((Sound)flag);
            if (effect == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return effect.getLocation().getPath();
        }
        catch (Throwable e) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    @Override
    public Entity getSource(BlockCommandSender sender) {
        net.minecraft.world.entity.Entity source = ((CraftBlockCommandSender)sender).getWrapper().getEntity();
        return source != null ? source.getBukkitEntity() : null;
    }

    @Override
    public float getSpeedFor(NPC npc) {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof org.bukkit.entity.LivingEntity)) {
            return 1.0f;
        }
        LivingEntity handle = NMSImpl.getHandle((org.bukkit.entity.LivingEntity)npc.getEntity());
        if (handle == null) {
            // empty if block
        }
        return 1.0f;
    }

    @Override
    public float getStepHeight(Entity entity) {
        return NMSImpl.getHandle(entity).maxUpStep();
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> nodes, NavigatorParameters params) {
        ArrayList list = Lists.newArrayList((Iterable)Iterables.transform(nodes, input -> new Node(input.getBlockX(), input.getBlockY(), input.getBlockZ())));
        Node last = list.size() > 0 ? (Node)list.get(list.size() - 1) : null;
        Path path = new Path((List)list, last != null ? new BlockPos(last.x, last.y, last.z) : null, true);
        return this.getTargetNavigator(entity, params, (PathNavigation input) -> input.moveTo(path, (double)params.speed()));
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Location dest, NavigatorParameters params) {
        return this.getTargetNavigator(entity, params, (PathNavigation input) -> input.moveTo(dest.getX(), dest.getY(), dest.getZ(), (double)params.speed()));
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final Entity entity, final NavigatorParameters params, final Function<PathNavigation, Boolean> function) {
        float oldWater;
        final net.minecraft.world.entity.Entity raw = NMSImpl.getHandle(entity);
        raw.setOnGround(true);
        final PathNavigation navigation = NMSImpl.getNavigation(entity);
        float f = oldWater = raw instanceof MobAI ? ((MobAI)raw).getPathfindingMalus(PathType.WATER) : ((Mob)raw).getPathfindingMalus(PathType.WATER);
        if (params.avoidWater() && oldWater >= 0.0f) {
            if (raw instanceof MobAI) {
                ((MobAI)raw).setPathfindingMalus(PathType.WATER, oldWater + 1.0f);
            } else {
                ((Mob)raw).setPathfindingMalus(PathType.WATER, oldWater + 1.0f);
            }
        }
        navigation.getNodeEvaluator().setCanOpenDoors(params.hasExaminer(DoorExaminer.class));
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            private List<org.bukkit.block.Block> getBlocks(Entity entity2, Path path) {
                ArrayList blocks = Lists.newArrayList();
                for (int i = 0; i < path.getNodeCount(); ++i) {
                    Node pp = path.getNode(i);
                    blocks.add(entity2.getWorld().getBlockAt(pp.x, pp.y, pp.z));
                }
                return blocks;
            }

            @Override
            public CancelReason getCancelReason() {
                return this.reason;
            }

            @Override
            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigation);
            }

            @Override
            public void stop() {
                Path path = NMSImpl.getPathEntity(navigation);
                if (params.debug() && path != null) {
                    List<org.bukkit.block.Block> blocks = this.getBlocks(entity, path);
                    Util.sendBlockChanges(blocks, null);
                }
                if (oldWater >= 0.0f) {
                    if (raw instanceof MobAI) {
                        ((MobAI)raw).setPathfindingMalus(PathType.WATER, oldWater);
                    } else {
                        ((Mob)raw).setPathfindingMalus(PathType.WATER, oldWater);
                    }
                }
                navigation.stop();
            }

            @Override
            public boolean update() {
                if (params.speed() != this.lastSpeed) {
                    net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
                    EntityDimensions size = null;
                    try {
                        size = SIZE_FIELD_GETTER.invoke(handle);
                        if (handle instanceof AbstractHorse) {
                            SIZE_FIELD_SETTER.invoke(handle, EntityDimensions.fixed((float)Math.min(0.99f, size.width()), (float)size.height()));
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (!((Boolean)function.apply(navigation)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    try {
                        SIZE_FIELD_SETTER.invoke(handle, size);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (params.debug() && NMSImpl.getPathEntity(navigation) != null) {
                        Util.sendBlockChanges(this.getBlocks(entity, NMSImpl.getPathEntity(navigation)), Material.DANDELION);
                    }
                    this.lastSpeed = params.speed();
                }
                navigation.setSpeedModifier((double)params.speed());
                return navigation.isDone();
            }
        };
    }

    @Override
    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity target, NavigatorParameters parameters) {
        PathNavigation navigation = NMSImpl.getNavigation(entity);
        return navigation == null ? null : new MCTargetNavigator(entity, navigation, target, parameters);
    }

    @Override
    public Entity getVehicle(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return null;
        }
        net.minecraft.world.entity.Entity e = handle.getVehicle();
        return e == handle || e == null ? null : e.getBukkitEntity();
    }

    @Override
    public float getVerticalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        LivingEntity handle = NMSImpl.getHandle((org.bukkit.entity.LivingEntity)entity);
        return handle.xxa;
    }

    @Override
    public double getWidth(Entity entity) {
        return entity.getWidth();
    }

    @Override
    public float getYaw(Entity entity) {
        return NMSImpl.getHandle(entity).getYRot();
    }

    @Override
    public boolean isOnGround(Entity entity) {
        return NMSImpl.getHandle(entity).onGround();
    }

    @Override
    public boolean isSneaking(Entity entity) {
        if (entity instanceof org.bukkit.entity.Player) {
            return ((org.bukkit.entity.Player)entity).isSneaking();
        }
        return NMSImpl.getHandle(entity).getPose() == Pose.CROUCHING;
    }

    @Override
    public boolean isSolid(org.bukkit.block.Block in) {
        BlockState data = ((CraftBlock)in).getNMS();
        return data.isSuffocating((BlockGetter)((CraftWorld)in.getWorld()).getHandle(), new BlockPos(in.getX(), in.getY(), in.getZ()));
    }

    @Override
    public boolean isValid(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return handle.valid && handle.isAlive();
    }

    @Override
    public void load(CommandManager manager) {
        this.registerTraitWithCommand(manager, EnderDragonTrait.class);
        this.registerTraitWithCommand(manager, AreaEffectCloudTrait.class);
        this.registerTraitWithCommand(manager, AllayTrait.class);
        this.registerTraitWithCommand(manager, AxolotlTrait.class);
        this.registerTraitWithCommand(manager, ArmadilloTrait.class);
        this.registerTraitWithCommand(manager, BeeTrait.class);
        this.registerTraitWithCommand(manager, BossBarTrait.class);
        this.registerTraitWithCommand(manager, CamelTrait.class);
        this.registerTraitWithCommand(manager, CatTrait.class);
        this.registerTraitWithCommand(manager, DisplayTrait.class);
        this.registerTraitWithCommand(manager, FoxTrait.class);
        this.registerTraitWithCommand(manager, FrogTrait.class);
        this.registerTraitWithCommand(manager, GoatTrait.class);
        this.registerTraitWithCommand(manager, LlamaTrait.class);
        this.registerTraitWithCommand(manager, MushroomCowTrait.class);
        this.registerTraitWithCommand(manager, ParrotTrait.class);
        this.registerTraitWithCommand(manager, PandaTrait.class);
        this.registerTraitWithCommand(manager, PiglinTrait.class);
        this.registerTraitWithCommand(manager, PhantomTrait.class);
        this.registerTraitWithCommand(manager, PolarBearTrait.class);
        this.registerTraitWithCommand(manager, PufferFishTrait.class);
        this.registerTraitWithCommand(manager, SpellcasterTrait.class);
        this.registerTraitWithCommand(manager, ShulkerTrait.class);
        this.registerTraitWithCommand(manager, SnowmanTrait.class);
        this.registerTraitWithCommand(manager, TextDisplayTrait.class);
        this.registerTraitWithCommand(manager, TropicalFishTrait.class);
        this.registerTraitWithCommand(manager, VillagerTrait.class);
        this.registerTraitWithCommand(manager, WardenTrait.class);
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType(EntityType.ALLAY, AllayController.class);
        EntityControllers.setEntityControllerForType(EntityType.AREA_EFFECT_CLOUD, AreaEffectCloudController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMADILLO, ArmadilloController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARROW, TippedArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.AXOLOTL, AxolotlController.class);
        EntityControllers.setEntityControllerForType(EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BEE, BeeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLOCK_DISPLAY, BlockDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOAT, BoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOGGED, BoggedController.class);
        EntityControllers.setEntityControllerForType(EntityType.BREEZE, BreezeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BREEZE_WIND_CHARGE, BreezeWindChargeController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAMEL, CamelController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAT, CatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAVE_SPIDER, CaveSpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHEST_BOAT, ChestBoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHEST_MINECART, MinecartChestController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType(EntityType.COD, CodController.class);
        EntityControllers.setEntityControllerForType(EntityType.COMMAND_BLOCK_MINECART, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType(EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType(EntityType.DOLPHIN, DolphinController.class);
        EntityControllers.setEntityControllerForType(EntityType.DONKEY, HorseDonkeyController.class);
        EntityControllers.setEntityControllerForType(EntityType.DRAGON_FIREBALL, DragonFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROWNED, DrownedController.class);
        EntityControllers.setEntityControllerForType(EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType(EntityType.ELDER_GUARDIAN, GuardianElderController.class);
        EntityControllers.setEntityControllerForType(EntityType.END_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER, EvokerController.class);
        EntityControllers.setEntityControllerForType(EntityType.EVOKER_FANGS, EvokerFangsController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_ORB, ExperienceOrbController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType(EntityType.EYE_OF_ENDER, EyeOfEnderController.class);
        EntityControllers.setEntityControllerForType(EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREWORK_ROCKET, FireworkController.class);
        EntityControllers.setEntityControllerForType(EntityType.FISHING_BOBBER, FishingHookController.class);
        EntityControllers.setEntityControllerForType(EntityType.FOX, FoxController.class);
        EntityControllers.setEntityControllerForType(EntityType.FROG, FrogController.class);
        EntityControllers.setEntityControllerForType(EntityType.FURNACE_MINECART, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType(EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType(EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType(EntityType.GLOW_ITEM_FRAME, GlowItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.GLOW_SQUID, GlowSquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.GOAT, GoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType(EntityType.HOGLIN, HoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.HOPPER_MINECART, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType(EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType(EntityType.HUSK, ZombieHuskController.class);
        EntityControllers.setEntityControllerForType(EntityType.ILLUSIONER, IllusionerController.class);
        EntityControllers.setEntityControllerForType(EntityType.INTERACTION, InteractionController.class);
        EntityControllers.setEntityControllerForType(EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_DISPLAY, ItemDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.OMINOUS_ITEM_SPAWNER, OminousItemSpawnerController.class);
        EntityControllers.setEntityControllerForType(EntityType.LEASH_KNOT, LeashController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA, LlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.LLAMA_SPIT, LlamaSpitController.class);
        EntityControllers.setEntityControllerForType(EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType(EntityType.MARKER, MarkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPAWNER_MINECART, MinecartSpawnerController.class);
        EntityControllers.setEntityControllerForType(EntityType.MOOSHROOM, MushroomCowController.class);
        EntityControllers.setEntityControllerForType(EntityType.MULE, HorseMuleController.class);
        EntityControllers.setEntityControllerForType(EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType(EntityType.PANDA, PandaController.class);
        EntityControllers.setEntityControllerForType(EntityType.PARROT, ParrotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PHANTOM, PhantomController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN, PiglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIGLIN_BRUTE, PiglinBruteController.class);
        EntityControllers.setEntityControllerForType(EntityType.PILLAGER, PillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType(EntityType.POLAR_BEAR, PolarBearController.class);
        EntityControllers.setEntityControllerForType(EntityType.POTION, ThrownPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.PUFFERFISH, PufferFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType(EntityType.RAVAGER, RavagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SALMON, SalmonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER, ShulkerController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHULKER_BULLET, ShulkerBulletController.class);
        EntityControllers.setEntityControllerForType(EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON_HORSE, HorseSkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType(EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNIFFER, SnifferController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOW_GOLEM, SnowmanController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPECTRAL_ARROW, SpectralArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRAY, SkeletonStrayController.class);
        EntityControllers.setEntityControllerForType(EntityType.STRIDER, StriderController.class);
        EntityControllers.setEntityControllerForType(EntityType.TADPOLE, TadpoleController.class);
        EntityControllers.setEntityControllerForType(EntityType.TEXT_DISPLAY, TextDisplayController.class);
        EntityControllers.setEntityControllerForType(EntityType.TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType(EntityType.TNT_MINECART, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRADER_LLAMA, TraderLlamaController.class);
        EntityControllers.setEntityControllerForType(EntityType.TRIDENT, ThrownTridentController.class);
        EntityControllers.setEntityControllerForType(EntityType.TROPICAL_FISH, TropicalFishController.class);
        EntityControllers.setEntityControllerForType(EntityType.TURTLE, TurtleController.class);
        EntityControllers.setEntityControllerForType(EntityType.VEX, VexController.class);
        EntityControllers.setEntityControllerForType(EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.VINDICATOR, VindicatorController.class);
        EntityControllers.setEntityControllerForType(EntityType.WANDERING_TRADER, WanderingTraderController.class);
        EntityControllers.setEntityControllerForType(EntityType.WARDEN, WardenController.class);
        EntityControllers.setEntityControllerForType(EntityType.WIND_CHARGE, WindChargeController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKELETON, SkeletonWitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType(EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOGLIN, ZoglinController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE, ZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_HORSE, HorseZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE_VILLAGER, ZombieVillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIFIED_PIGLIN, PigZombieController.class);
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        yaw = Util.clamp(yaw);
        handle.setYRot(yaw);
        this.setHeadYaw(entity, yaw);
        handle.setXRot(pitch);
    }

    @Override
    public void look(Entity entity, Location to, boolean headOnly, boolean immediate) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof Mob) && !(handle instanceof MobAI)) {
            double pitch;
            double yaw;
            Location fromLocation = entity.getLocation(FROM_LOCATION);
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double d = yaw = distanceXZ == 0.0 ? 0.0 : Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double d2 = distanceY == 0.0 ? 0.0 : (pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - (double)(handle.getBukkitEntity().getType() == EntityType.PHANTOM ? 45 : 90));
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw = handle.getBukkitEntity().getType() == EntityType.ENDER_DRAGON ? (double)Util.getYawFromVelocity((Entity)handle.getBukkitEntity(), xDiff, zDiff) : (yaw -= 90.0);
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.look(entity, (float)yaw, (float)pitch);
            }
            return;
        }
        if (handle instanceof Mob) {
            ((Mob)handle).getLookControl().setLookAt(to.getX(), to.getY(), to.getZ(), (float)((Mob)handle).getHeadRotSpeed(), (float)((Mob)handle).getMaxHeadXRot());
            while (((LivingEntity)handle).yHeadRot >= 180.0f) {
                ((LivingEntity)handle).yHeadRot -= 360.0f;
            }
            while (((LivingEntity)handle).yHeadRot < -180.0f) {
                ((LivingEntity)handle).yHeadRot += 360.0f;
            }
        } else if (handle instanceof NPCHolder) {
            ((NPCHolder)handle).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(to);
        }
    }

    @Override
    public void look(Entity from, Entity to) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(from);
        net.minecraft.world.entity.Entity target = NMSImpl.getHandle(to);
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof Mob) && !(handle instanceof MobAI)) {
            if (to instanceof org.bukkit.entity.LivingEntity) {
                this.look(from, ((org.bukkit.entity.LivingEntity)to).getEyeLocation(), false, true);
            } else {
                this.look(from, to.getLocation(), false, true);
            }
        } else if (handle instanceof Mob) {
            ((Mob)handle).getLookControl().setLookAt(target, (float)((Mob)handle).getHeadRotSpeed(), (float)((Mob)handle).getMaxHeadXRot());
            while (((LivingEntity)handle).yHeadRot >= 180.0f) {
                ((LivingEntity)handle).yHeadRot -= 360.0f;
            }
            while (((LivingEntity)handle).yHeadRot < -180.0f) {
                ((LivingEntity)handle).yHeadRot += 360.0f;
            }
        } else if (handle instanceof NPCHolder) {
            ((NPCHolder)handle).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(to);
        }
    }

    @Override
    public void markPoseDirty(Entity entity) {
        NMSImpl.getHandle(entity).getEntityData().markDirty(DATA_POSE);
    }

    @Override
    public void mount(Entity entity, Entity passenger) {
        if (NMSImpl.getHandle(passenger) == null) {
            return;
        }
        NMSImpl.getHandle(passenger).startRiding(NMSImpl.getHandle(entity), true);
    }

    @Override
    public void onPlayerInfoAdd(org.bukkit.entity.Player player, Object raw, Function<UUID, MirrorTrait> mirrorTraits) {
        ClientboundPlayerInfoUpdatePacket packet = (ClientboundPlayerInfoUpdatePacket)raw;
        ArrayList list = Lists.newArrayList((Iterable)packet.entries());
        boolean changed = false;
        GameProfile playerProfile = null;
        for (int i = 0; i < list.size(); ++i) {
            MirrorTrait trait;
            ClientboundPlayerInfoUpdatePacket.Entry npcInfo = (ClientboundPlayerInfoUpdatePacket.Entry)list.get(i);
            if (npcInfo == null || (trait = mirrorTraits.apply(npcInfo.profileId())) == null || !trait.isMirroring(player)) continue;
            boolean disableTablist = trait.getNPC().shouldRemoveFromTabList();
            if (disableTablist != npcInfo.listed()) {
                list.set(i, new ClientboundPlayerInfoUpdatePacket.Entry(npcInfo.profileId(), npcInfo.profile(), !disableTablist, npcInfo.latency(), npcInfo.gameMode(), (Component)(!disableTablist ? npcInfo.displayName() : Component.empty()), npcInfo.chatSession()));
                changed = true;
            }
            if (playerProfile == null) {
                playerProfile = NMS.getProfile(player);
            }
            if (trait.mirrorName()) {
                list.set(i, new ClientboundPlayerInfoUpdatePacket.Entry(npcInfo.profileId(), playerProfile, !disableTablist, npcInfo.latency(), npcInfo.gameMode(), (Component)Component.literal((String)Util.possiblyStripBedrockPrefix(playerProfile.getName(), playerProfile.getId())), npcInfo.chatSession()));
                changed = true;
                continue;
            }
            Collection textures = playerProfile.getProperties().get((Object)"textures");
            if (textures == null || textures.size() == 0) continue;
            npcInfo.profile().getProperties().clear();
            for (String key : playerProfile.getProperties().keySet()) {
                npcInfo.profile().getProperties().putAll((Object)key, (Iterable)playerProfile.getProperties().get((Object)key));
            }
            changed = true;
        }
        if (changed) {
            try {
                PLAYER_INFO_ENTRIES_LIST.invoke(packet, list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InventoryView openAnvilInventory(org.bukkit.entity.Player player, Inventory anvil, String title) {
        ServerPlayer handle = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player);
        CitizensAnvilMenu container = new CitizensAnvilMenu(handle.nextContainerCounter(), handle.getInventory(), ContainerLevelAccess.create((Level)handle.level(), (BlockPos)new BlockPos(0, 0, 0)), anvil);
        container.setTitle((Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(title == null ? "" : title)));
        container.getBukkitView().setItem(0, anvil.getItem(0));
        container.getBukkitView().setItem(1, anvil.getItem(1));
        container.checkReachable = false;
        handle.connection.send((Packet)new ClientboundOpenScreenPacket(container.containerId, container.getType(), container.getTitle()));
        handle.containerMenu = container;
        handle.initMenu((AbstractContainerMenu)container);
        return container.getBukkitView();
    }

    @Override
    public void openHorseInventory(Tameable horse, org.bukkit.entity.Player equipper) {
        LivingEntity handle = NMSImpl.getHandle(horse);
        ServerPlayer equipperHandle = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)equipper);
        if (handle == null || equipperHandle == null) {
            return;
        }
        boolean wasTamed = horse.isTamed();
        horse.setTamed(true);
        ((AbstractHorse)handle).openCustomInventoryScreen((Player)equipperHandle);
        horse.setTamed(wasTamed);
    }

    @Override
    public void playAnimation(PlayerAnimation animation, org.bukkit.entity.Player player, Iterable<org.bukkit.entity.Player> to) {
        PlayerAnimationImpl.play(animation, player, to);
    }

    @Override
    public Runnable playerTicker(NPC npc, org.bukkit.entity.Player entity) {
        ServerPlayer player = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)entity);
        return () -> {
            if (!entity.isValid()) {
                return;
            }
            player.doTick();
        };
    }

    @Override
    public void positionInteractionText(org.bukkit.entity.Player player, Entity entity, Entity mount, double offset) {
        NMSImpl.sendPacket(player, new ClientboundBundlePacket(List.of(new ClientboundSetEntityDataPacket(entity.getEntityId(), List.of(new SynchedEntityData.DataItem(INTERACTION_WIDTH, (Object)Float.valueOf(0.0f)).value(), new SynchedEntityData.DataItem(INTERACTION_HEIGHT, (Object)Float.valueOf((float)(offset += (double)this.getRidingHeightOffset(entity, mount)))).value(), new SynchedEntityData.DataItem(DATA_POSE, (Object)Pose.CROAKING).value(), new SynchedEntityData.DataItem(DATA_NAME_VISIBLE, (Object)true).value())), new ClientboundSetPassengersPacket(NMSImpl.getHandle(mount)), new ClientboundSetEntityDataPacket(entity.getEntityId(), List.of(new SynchedEntityData.DataItem(INTERACTION_HEIGHT, (Object)Float.valueOf(999999.0f)).value())))));
    }

    @Override
    public void registerEntityClass(Class<?> clazz) {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && net.minecraft.world.entity.Entity.class.isAssignableFrom(search)) {
            net.minecraft.world.entity.EntityType type = ENTITY_REGISTRY.findType(search);
            ResourceLocation key = ENTITY_REGISTRY.getKey(type);
            if (key == null || type == null) continue;
            CITIZENS_ENTITY_TYPES.put(clazz, type);
            int code = ENTITY_REGISTRY.getId(type);
            ENTITY_REGISTRY.put(code, key, type);
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    private void registerTraitWithCommand(CommandManager manager, Class<? extends Trait> clazz) {
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(clazz));
        manager.register(clazz);
    }

    @Override
    public void remove(Entity entity) {
        NMSImpl.getHandle(entity).remove(Entity.RemovalReason.KILLED);
    }

    @Override
    public void removeFromServerPlayerList(org.bukkit.entity.Player player) {
        ServerPlayer handle = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    @Override
    public void removeFromWorld(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        ((ServerLevel)handle.level()).getChunkSource().removeEntity(handle);
    }

    @Override
    public void removeHookIfNecessary(FishHook entity) {
        FishingHook hook = (FishingHook)NMSImpl.getHandle((Entity)entity);
        net.minecraft.world.entity.Entity hooked = hook.getHookedIn();
        if (hooked == null) {
            return;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)hooked.getBukkitEntity());
        if (npc != null && npc.isProtected()) {
            hook.hookedIn = null;
            hook.getBukkitEntity().remove();
        }
    }

    @Override
    public void replaceTrackerEntry(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        ChunkMap cm = ((ServerLevel)handle.level()).getChunkSource().chunkMap;
        ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)cm.entityMap.get(entity.getEntityId());
        if (entry == null) {
            return;
        }
        entry.broadcastRemoved();
        CitizensEntityTracker newTracker = new CitizensEntityTracker(cm, entry);
        for (MethodHandle setter : TRACKED_ENTITY_SETTERS) {
            try {
                setter.invoke(handle, newTracker);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        cm.entityMap.put(entity.getEntityId(), (Object)newTracker);
    }

    @Override
    public void sendPositionUpdate(Entity from, Collection<org.bukkit.entity.Player> to, boolean position, Float bodyYaw, Float pitch, Float headYaw) {
        List<Packet<?>> toSend = NMSImpl.getPositionUpdate(from, position, bodyYaw, pitch, headYaw);
        for (org.bukkit.entity.Player dest : to) {
            NMSImpl.sendPackets(dest, toSend);
        }
    }

    @Override
    public boolean sendTabListAdd(org.bukkit.entity.Player recipient, org.bukkit.entity.Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        ServerPlayer from = ((CraftPlayer)listPlayer).getHandle();
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(Arrays.asList(from));
        boolean list = from instanceof NPCHolder ? !((NPCHolder)from).getNPC().shouldRemoveFromTabList() : true;
        ClientboundPlayerInfoUpdatePacket.Entry entry = new ClientboundPlayerInfoUpdatePacket.Entry(from.getUUID(), from.getGameProfile(), list, from.connection.latency(), from.gameMode.getGameModeForPlayer(), (Component)(list ? from.getTabListDisplayName() : Component.empty()), from.getChatSession() == null ? null : from.getChatSession().asData());
        try {
            PLAYERINFO_ENTRIES.invoke(packet, Lists.newArrayList((Object[])new ClientboundPlayerInfoUpdatePacket.Entry[]{entry}));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        NMSImpl.sendPacket(recipient, packet);
        return true;
    }

    @Override
    public void sendTabListRemove(org.bukkit.entity.Player recipient, Collection<org.bukkit.entity.Player> players) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull(players);
        NMSImpl.sendPacket(recipient, new ClientboundPlayerInfoRemovePacket(players.stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toList())));
    }

    @Override
    public void sendTeamPacket(org.bukkit.entity.Player recipient, Team team, int mode) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getGetter(team.getClass(), "team");
        }
        try {
            PlayerTeam nmsTeam = TEAM_FIELD.invoke(team);
            if (mode == 1) {
                NMSImpl.sendPacket(recipient, ClientboundSetPlayerTeamPacket.createRemovePacket((PlayerTeam)nmsTeam));
            } else {
                NMSImpl.sendPacket(recipient, ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)nmsTeam, (mode == 0 ? 1 : 0) != 0));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAggressive(Entity entity, boolean aggro) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof Mob)) {
            return;
        }
        ((Mob)handle).setAggressive(aggro);
    }

    @Override
    public void setAllayDancing(Entity entity, boolean dancing) {
        Allay allay = (Allay)NMSImpl.getHandle(entity);
        allay.setDancing(dancing);
    }

    @Override
    public void setArmadilloState(Entity entity, ArmadilloTrait.ArmadilloState state) {
        Armadillo.ArmadilloState s = Armadillo.ArmadilloState.IDLE;
        switch (state) {
            case IDLE: {
                s = Armadillo.ArmadilloState.IDLE;
                break;
            }
            case ROLLING_UP: {
                s = Armadillo.ArmadilloState.ROLLING;
                break;
            }
            case ROLLING_OUT: {
                s = Armadillo.ArmadilloState.UNROLLING;
                break;
            }
            case SCARED: {
                s = Armadillo.ArmadilloState.SCARED;
            }
        }
        ((Armadillo)NMSImpl.getHandle(entity)).switchToState(s);
    }

    @Override
    public void setBodyYaw(Entity entity, float yaw) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle instanceof LivingEntity) {
            ((LivingEntity)handle).yBodyRotO = yaw;
        }
        handle.setYBodyRot(yaw);
        handle.setYRot(yaw);
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox box) {
        NMSImpl.getHandle(entity).setBoundingBox(NMSBoundingBox.convert(box));
    }

    @Override
    public void setCamelPose(Entity entity, CamelTrait.CamelPose pose) {
        if (entity.getType() != EntityType.CAMEL) {
            throw new IllegalStateException();
        }
        Camel camel = (Camel)NMSImpl.getHandle(entity);
        switch (pose) {
            case STANDING: {
                if (!camel.isStanding()) {
                    camel.standUp();
                }
                return;
            }
            case SITTING: {
                if (!camel.isCamelSitting()) {
                    camel.sitDown();
                }
                return;
            }
            case PANIC: {
                if (!camel.isPanicking()) {
                    camel.standUpInstantly();
                }
                return;
            }
        }
    }

    @Override
    public void setCustomName(Entity entity, Object component, String string) {
        NMSImpl.getHandle(entity).setCustomName((Component)component);
    }

    @Override
    public void setDestination(Entity entity, double x, double y, double z, float speed) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        MobAI ai = MobAI.from(handle);
        if (ai != null) {
            ai.getMoveControl().setWantedPosition(x, y, z, (double)speed);
        }
    }

    @Override
    public void setDimensions(Entity entity, EntityDim desired) {
        NMSImpl.setSize(NMSImpl.getHandle(entity), EntityDimensions.fixed((float)desired.width, (float)desired.height));
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean angry) {
        if (ENDERMAN_CREEPY == null) {
            return;
        }
        NMSImpl.getHandle((org.bukkit.entity.LivingEntity)enderman).getEntityData().set(ENDERMAN_CREEPY, (Object)angry);
    }

    @Override
    public void setHeadAndBodyYaw(Entity entity, float yaw) {
        yaw = Util.clamp(yaw);
        this.setBodyYaw(entity, yaw);
        this.setHeadYaw(entity, yaw);
    }

    @Override
    public void setHeadYaw(Entity entity, float yaw) {
        if (!(entity instanceof org.bukkit.entity.LivingEntity)) {
            return;
        }
        ((LivingEntity)NMSImpl.getHandle(entity)).setYHeadRot(Util.clamp(yaw));
    }

    @Override
    public void setKnockbackResistance(org.bukkit.entity.LivingEntity entity, double d) {
        LivingEntity handle = NMSImpl.getHandle(entity);
        handle.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(d);
    }

    @Override
    public void setLocationDirectly(Entity entity, Location location) {
        NMSImpl.getHandle(entity).moveTo(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setLyingDown(Entity cat, boolean lying) {
        ((Cat)NMSImpl.getHandle(cat)).setLying(lying);
    }

    @Override
    public void setNavigationTarget(Entity handle, Entity target, float speed) {
        NMSImpl.getNavigation(handle).moveTo(NMSImpl.getHandle(target), (double)speed);
    }

    @Override
    public void setNavigationType(Entity entity, NMS.MinecraftNavigationType type) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof Mob)) {
            return;
        }
        Mob ei = (Mob)handle;
        switch (type) {
            case GROUND: {
                try {
                    ENTITY_NAVIGATION.invoke(ei, new GroundPathNavigation(ei, ei.level()));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            case WALL_CLIMB: {
                try {
                    ENTITY_NAVIGATION.invoke(ei, new WallClimberNavigation(ei, ei.level()));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setNoGravity(Entity entity, boolean nogravity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        handle.setNoGravity(nogravity);
        if (!(handle instanceof Mob) || !(entity instanceof NPCHolder)) {
            return;
        }
        Mob mob = (Mob)handle;
        NPC npc = ((NPCHolder)entity).getNPC();
        if (!(mob.getMoveControl() instanceof FlyingMoveControl) || npc.data().has("flying-nogravity-float")) {
            return;
        }
        try {
            if (nogravity) {
                boolean old = FLYING_MOVECONTROL_FLOAT_GETTER.invoke(mob.getMoveControl());
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(mob.getMoveControl(), true);
                npc.data().set("flying-nogravity-float", (Object)old);
            } else if (npc.data().has("flying-nogravity-float")) {
                FLYING_MOVECONTROL_FLOAT_SETTER.invoke(mob.getMoveControl(), npc.data().get("flying-nogravity-float"));
                npc.data().remove("flying-nogravity-float");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setOpWithoutSaving(org.bukkit.entity.Player player, boolean op) {
        if (player.isOp() == op) {
            return;
        }
        ServerPlayer playerHandle = ((CraftPlayer)player).getHandle();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        DedicatedPlayerList playerList = ((CraftServer)player.getServer()).getHandle();
        DedicatedServer server = playerList.getServer();
        ServerOpList opList = playerList.getOps();
        if (op) {
            opList.add((StoredUserEntry)new ServerOpListEntry(profile, server.getOperatorUserPermissionLevel(), opList.canBypassPlayerLimit(profile)));
        } else {
            opList.remove((Object)profile);
        }
        playerList.sendPlayerPermissionLevel(playerHandle);
    }

    @Override
    public void setPandaSitting(Entity entity, boolean sitting) {
        ((Panda)NMSImpl.getHandle(entity)).sit(sitting);
    }

    @Override
    public void setPeekShulker(Entity shulker, int peek) {
        ((Shulker)NMSImpl.getHandle(shulker)).setRawPeekAmount(peek);
    }

    @Override
    public void setPiglinDancing(Entity entity, boolean dancing) {
        if (!(NMSImpl.getHandle(entity) instanceof Piglin)) {
            return;
        }
        ((Piglin)NMSImpl.getHandle(entity)).setDancing(dancing);
    }

    @Override
    public void setPitch(Entity entity, float pitch) {
        NMSImpl.getHandle(entity).setXRot(pitch);
    }

    @Override
    public void setPolarBearRearing(Entity entity, boolean rearing) {
        ((PolarBear)NMSImpl.getHandle(entity)).setStanding(rearing);
    }

    @Override
    public void setPose(Entity entity, EntityPoseTrait.EntityPose pose) {
        NMSImpl.getHandle(entity).setPose((Pose)Pose.BY_ID.apply(pose.id()));
    }

    @Override
    public void setProfile(SkullMeta meta, GameProfile profile) {
        if (SET_PROFILE_METHOD == null && (SET_PROFILE_METHOD = NMS.getMethodHandle(meta.getClass(), "setProfile", true, GameProfile.class)) == null) {
            return;
        }
        try {
            SET_PROFILE_METHOD.invoke(meta, profile);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void setShouldJump(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        MobAI ai = MobAI.from(handle);
        if (ai != null) {
            ai.getJumpControl().jump();
        }
        if (handle instanceof LivingEntity) {
            ((LivingEntity)handle).setJumping(true);
        }
    }

    @Override
    public void setSitting(Ocelot ocelot, boolean sitting) {
        this.setSneaking((Entity)ocelot, sitting);
    }

    @Override
    public void setSitting(Tameable tameable, boolean sitting) {
        ((TamableAnimal)NMSImpl.getHandle(tameable)).setInSittingPose(sitting);
    }

    @Override
    public void setSneaking(Entity entity, boolean sneaking) {
        if (entity instanceof org.bukkit.entity.Player) {
            ((org.bukkit.entity.Player)entity).setSneaking(sneaking);
        }
        Pose pose = sneaking ? Pose.CROUCHING : Pose.STANDING;
        NMSImpl.getHandle(entity).setPose(pose);
    }

    @Override
    public void setSnifferState(Entity entity, SnifferTrait.SnifferState state) {
        Sniffer handle = (Sniffer)NMSImpl.getHandle(entity);
        handle.transitionTo(Sniffer.State.valueOf((String)state.name()));
    }

    @Override
    public void setStepHeight(Entity entity, float height) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (!(handle instanceof LivingEntity)) {
            return;
        }
        ((LivingEntity)handle).getAttribute(Attributes.STEP_HEIGHT).setBaseValue((double)height);
    }

    @Override
    public void setTextDisplayComponent(Entity entity, Object component) {
        Display.TextDisplay disp = (Display.TextDisplay)NMSImpl.getHandle(entity);
        disp.setText((Component)component);
    }

    @Override
    public void setVerticalMovement(Entity bukkitEntity, double d) {
        if (!bukkitEntity.getType().isAlive()) {
            return;
        }
        LivingEntity handle = NMSImpl.getHandle((org.bukkit.entity.LivingEntity)bukkitEntity);
        handle.xxa = (float)d;
    }

    @Override
    public void setWardenPose(Entity entity, Object pose) {
        Warden warden = (Warden)NMSImpl.getHandle(entity);
        if (pose == org.bukkit.entity.Pose.DIGGING) {
            if (warden.hasPose(Pose.DIGGING)) {
                return;
            }
            warden.setPose(Pose.DIGGING);
            warden.playSound(SoundEvents.WARDEN_DIG, 5.0f, 1.0f);
        } else if (pose == org.bukkit.entity.Pose.EMERGING) {
            if (warden.hasPose(Pose.EMERGING)) {
                return;
            }
            warden.setPose(Pose.EMERGING);
            warden.playSound(SoundEvents.WARDEN_EMERGE, 5.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (warden.hasPose(Pose.EMERGING)) {
                    warden.setPose(Pose.STANDING);
                }
            }, 134L);
        } else if (pose == org.bukkit.entity.Pose.ROARING) {
            if (warden.hasPose(Pose.ROARING)) {
                return;
            }
            warden.setPose(Pose.ROARING);
            warden.playSound(SoundEvents.WARDEN_ROAR, 3.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (warden.hasPose(Pose.ROARING)) {
                    warden.setPose(Pose.STANDING);
                }
            }, 84L);
        } else {
            warden.setPose(Pose.STANDING);
        }
    }

    @Override
    public boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof org.bukkit.entity.LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.invoke(NMSImpl.getHandle(entity));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void shutdown() {
        if (ENTITY_REGISTRY == null) {
            return;
        }
        try {
            ENTITY_REGISTRY_SETTER.invoke(null, ENTITY_REGISTRY.get());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void sleep(org.bukkit.entity.Player entity, boolean sleep) {
        NMSImpl.getHandle((org.bukkit.entity.LivingEntity)entity).setPose(sleep ? Pose.SLEEPING : Pose.STANDING);
    }

    @Override
    public void trySwim(Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    @Override
    public void trySwim(Entity entity, float power) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (RANDOM.nextFloat() <= 0.85f && handle.isInWater()) {
            handle.setDeltaMovement(handle.getDeltaMovement().x, handle.getDeltaMovement().y + (double)power, handle.getDeltaMovement().z);
        }
    }

    @Override
    public void updateInventoryTitle(org.bukkit.entity.Player player, SpigotUtil.InventoryViewAPI view, String newTitle) {
        ServerPlayer handle = (ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player);
        MenuType menuType = null;
        switch (view.getTopInventory().getType()) {
            case ANVIL: {
                menuType = MenuType.ANVIL;
                break;
            }
            case BARREL: {
                menuType = MenuType.GENERIC_9x3;
                break;
            }
            case BEACON: {
                menuType = MenuType.BEACON;
                break;
            }
            case BLAST_FURNACE: {
                menuType = MenuType.BLAST_FURNACE;
                break;
            }
            case BREWING: {
                menuType = MenuType.BREWING_STAND;
                break;
            }
            case CARTOGRAPHY: {
                menuType = MenuType.CARTOGRAPHY_TABLE;
                break;
            }
            case CHEST: {
                int sz = view.getTopInventory().getSize();
                if (sz > 45) {
                    menuType = MenuType.GENERIC_9x6;
                    break;
                }
                if (sz > 36) {
                    menuType = MenuType.GENERIC_9x5;
                    break;
                }
                if (sz > 27) {
                    menuType = MenuType.GENERIC_9x4;
                    break;
                }
                if (sz > 18) {
                    menuType = MenuType.GENERIC_9x3;
                    break;
                }
                if (sz > 9) {
                    menuType = MenuType.GENERIC_9x2;
                    break;
                }
                menuType = MenuType.GENERIC_9x1;
                break;
            }
            case COMPOSTER: {
                break;
            }
            case PLAYER: 
            case CRAFTING: 
            case CREATIVE: {
                return;
            }
            case DISPENSER: 
            case DROPPER: {
                menuType = MenuType.GENERIC_3x3;
                break;
            }
            case ENCHANTING: {
                menuType = MenuType.ENCHANTMENT;
                break;
            }
            case ENDER_CHEST: {
                menuType = MenuType.GENERIC_9x3;
                break;
            }
            case FURNACE: {
                menuType = MenuType.FURNACE;
                break;
            }
            case GRINDSTONE: {
                menuType = MenuType.GRINDSTONE;
                break;
            }
            case HOPPER: {
                menuType = MenuType.HOPPER;
                break;
            }
            case LECTERN: {
                menuType = MenuType.LECTERN;
                break;
            }
            case LOOM: {
                menuType = MenuType.LOOM;
                break;
            }
            case MERCHANT: {
                menuType = MenuType.MERCHANT;
                break;
            }
            case SHULKER_BOX: {
                menuType = MenuType.SHULKER_BOX;
                break;
            }
            case SMITHING: {
                menuType = MenuType.SMITHING;
                break;
            }
            case SMOKER: {
                menuType = MenuType.SMOKER;
                break;
            }
            case STONECUTTER: {
                menuType = MenuType.STONECUTTER;
                break;
            }
            case WORKBENCH: {
                menuType = MenuType.CRAFTING;
            }
        }
        handle.connection.send((Packet)new ClientboundOpenScreenPacket(handle.containerMenu.containerId, menuType, (Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(newTitle))));
        player.updateInventory();
    }

    @Override
    public void updateNavigationWorld(Entity entity, World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        net.minecraft.world.entity.Entity en = NMSImpl.getHandle(entity);
        if (en == null || !(en instanceof Mob)) {
            return;
        }
        Mob handle = (Mob)en;
        ServerLevel worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.invoke(handle.getNavigation(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (!npc.isSpawned() || !npc.getEntity().getType().isAlive()) {
            return;
        }
        LivingEntity en = NMSImpl.getHandle((org.bukkit.entity.LivingEntity)npc.getEntity());
        if (en instanceof MobAI) {
            ((MobAI)en).updatePathfindingRange(pathfindingRange);
            return;
        }
        if (NAVIGATION_PATHFINDER == null) {
            return;
        }
        PathNavigation navigation = ((Mob)en).getNavigation();
        AttributeInstance inst = en.getAttribute(Attributes.FOLLOW_RANGE);
        inst.setBaseValue((double)pathfindingRange);
        int mc = Mth.floor((double)(en.getAttributeBaseValue(Attributes.FOLLOW_RANGE) * 16.0));
        try {
            NAVIGATION_PATHFINDER.invoke(navigation, NAVIGATION_CREATE_PATHFINDER.invoke(navigation, mc));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void checkAndUpdateHeight(LivingEntity living, EntityDataAccessor<?> datawatcherobject, Consumer<EntityDataAccessor<?>> cb) {
        EntityDimensions size;
        try {
            size = SIZE_FIELD_GETTER.invoke(living);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        float oldw = size.width();
        float oldl = size.height();
        cb.accept(datawatcherobject);
        if (oldw != size.width() || size.height() != oldl) {
            living.setPos(living.getX() - 0.01, living.getY(), living.getZ() - 0.01);
            living.setPos(living.getX() + 0.01, living.getY(), living.getZ() + 0.01);
        }
    }

    public static void clearGoals(NPC npc, GoalSelector ... goalSelectors) {
        if (goalSelectors == null) {
            return;
        }
        int i = 0;
        for (GoalSelector selector : goalSelectors) {
            try {
                Set list = selector.getAvailableGoals();
                if (!list.isEmpty()) {
                    npc.data().set("selector" + i, (Object)Lists.newArrayList((Iterable)list));
                }
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
            ++i;
        }
    }

    private static Object deserialiseNBT(Tag tag) {
        switch (tag.getId()) {
            case 10: {
                CompoundTag ct = (CompoundTag)tag;
                HashMap map = Maps.newHashMapWithExpectedSize((int)ct.size());
                for (String key : ct.getAllKeys()) {
                    map.put(key, NMSImpl.deserialiseNBT(ct.get(key)));
                }
                return map;
            }
            case 9: {
                ListTag list = (ListTag)tag;
                ArrayList res = Lists.newArrayList((Object[])new Object[]{list.size()});
                for (int i = 0; i < list.size(); ++i) {
                    res.add(NMSImpl.deserialiseNBT(list.get(i)));
                }
                return res;
            }
            case 7: {
                return ((ByteArrayTag)tag).getAsByteArray();
            }
            case 11: {
                return ((IntArrayTag)tag).getAsIntArray();
            }
            case 12: {
                return ((LongArrayTag)tag).getAsLongArray();
            }
            case 8: {
                return ((StringTag)tag).getAsString();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 99: {
                return ((NumericTag)tag).getAsNumber();
            }
        }
        throw new IllegalArgumentException();
    }

    public static void flyingMoveLogic(LivingEntity entity, Vec3 vec3d) {
        if (entity.isEffectiveAi() || entity.isControlledByLocalInstance()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = entity.getDeltaMovement().y <= 0.0;
            if (flag && entity.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = 0.01;
                entity.fallDistance = 0.0f;
            }
            FluidState fluid = entity.level().getFluidState(entity.blockPosition());
            if (entity.isInWater() && !entity.canStandOnFluid(fluid)) {
                double d1 = entity.getY();
                float f = entity.isSprinting() ? 0.9f : 0.8f;
                float f1 = 0.02f;
                float f2 = (float)entity.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                if (f2 > 3.0f) {
                    f2 = 3.0f;
                }
                if (!entity.onGround()) {
                    f2 *= 0.5f;
                }
                if (f2 > 0.0f) {
                    f += (0.546f - f) * f2 / 3.0f;
                    f1 += (entity.getSpeed() - f1) * f2 / 3.0f;
                }
                if (entity.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    f = 0.96f;
                }
                entity.moveRelative(f1, vec3d);
                entity.move(MoverType.SELF, entity.getDeltaMovement());
                Vec3 vec3d1 = entity.getDeltaMovement();
                if (entity.horizontalCollision && entity.onClimbable()) {
                    vec3d1 = new Vec3(vec3d1.x, 0.2, vec3d1.z);
                }
                entity.setDeltaMovement(vec3d1.multiply((double)f, 0.8, (double)f));
                Vec3 vec3d2 = entity.getFluidFallingAdjustedMovement(d0, flag, entity.getDeltaMovement());
                entity.setDeltaMovement(vec3d2);
                if (entity.horizontalCollision && entity.isFree(vec3d2.x, vec3d2.y + 0.6 - entity.getY() + d1, vec3d2.z)) {
                    entity.setDeltaMovement(vec3d2.x, 0.3, vec3d2.z);
                }
            } else if (entity.isInLava() && !entity.canStandOnFluid(fluid)) {
                double d1 = entity.getY();
                entity.moveRelative(0.02f, vec3d);
                entity.move(MoverType.SELF, entity.getDeltaMovement());
                if (entity.getFluidHeight(FluidTags.LAVA) <= entity.getFluidJumpThreshold()) {
                    entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.5, 0.8, 0.5));
                    Vec3 vec3 = entity.getFluidFallingAdjustedMovement(d0, flag, entity.getDeltaMovement());
                    entity.setDeltaMovement(vec3);
                } else {
                    entity.setDeltaMovement(entity.getDeltaMovement().scale(0.5));
                }
                if (!entity.isNoGravity()) {
                    entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -d0 / 4.0, 0.0));
                }
                Vec3 vec3d3 = entity.getDeltaMovement();
                if (entity.horizontalCollision && entity.isFree(vec3d3.x, vec3d3.y + 0.6 - entity.getY() + d1, vec3d3.z)) {
                    entity.setDeltaMovement(vec3d3.x, 0.3, vec3d3.z);
                }
            } else if (entity.isFallFlying()) {
                double d6;
                float f4;
                double d5;
                Vec3 vec3d4 = entity.getDeltaMovement();
                if (vec3d4.y > -0.5) {
                    entity.fallDistance = 1.0f;
                }
                Vec3 vec3d5 = entity.getLookAngle();
                float f = entity.getXRot() * ((float)Math.PI / 180);
                double d2 = Math.sqrt(vec3d5.x * vec3d5.x + vec3d5.z * vec3d5.z);
                double d3 = vec3d4.horizontalDistance();
                double d4 = vec3d5.length();
                float f3 = Mth.cos((float)f);
                f3 = (float)((double)(f3 * f3) * Math.min(1.0, d4 / 0.4));
                vec3d4 = entity.getDeltaMovement().add(0.0, d0 * (-1.0 + (double)f3 * 0.75), 0.0);
                if (vec3d4.y < 0.0 && d2 > 0.0) {
                    d5 = vec3d4.y * -0.1 * (double)f3;
                    vec3d4 = vec3d4.add(vec3d5.x * d5 / d2, d5, vec3d5.z * d5 / d2);
                }
                if (f < 0.0f && d2 > 0.0) {
                    d5 = d3 * (double)(-Mth.sin((float)f)) * 0.04;
                    vec3d4 = vec3d4.add(-vec3d5.x * d5 / d2, d5 * 3.2, -vec3d5.z * d5 / d2);
                }
                if (d2 > 0.0) {
                    vec3d4 = vec3d4.add((vec3d5.x / d2 * d3 - vec3d4.x) * 0.1, 0.0, (vec3d5.z / d2 * d3 - vec3d4.z) * 0.1);
                }
                entity.setDeltaMovement(vec3d4.multiply(0.99, 0.98, 0.99));
                entity.move(MoverType.SELF, entity.getDeltaMovement());
                if (entity.horizontalCollision && !entity.level().isClientSide && (f4 = (float)((d6 = d3 - (d5 = entity.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                    entity.playSound(entity.getFallDamageSound0((int)f4), 1.0f, 1.0f);
                    entity.hurt(entity.damageSources().flyIntoWall(), f4);
                }
                if (entity.onGround() && !entity.level().isClientSide && entity.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent((LivingEntity)entity, (boolean)false).isCancelled()) {
                    entity.setSharedFlag(7, false);
                }
            } else {
                BlockPos blockposition = BlockPos.containing((double)entity.getX(), (double)(entity.getBoundingBox().minY - 0.5), (double)entity.getZ());
                float f5 = entity.level().getBlockState(blockposition).getBlock().getFriction();
                float f = entity.onGround() ? f5 * 0.91f : 0.91f;
                Vec3 vec3d6 = entity.handleRelativeFrictionAndCalculateMovement(vec3d, f5);
                double d7 = vec3d6.y;
                if (entity.hasEffect(MobEffects.LEVITATION)) {
                    d7 += (0.05 * (double)(entity.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec3d6.y) * 0.2;
                    entity.fallDistance = 0.0f;
                } else if (entity.level().isClientSide && !entity.level().hasChunkAt(blockposition)) {
                    d7 = entity.getY() > (double)entity.level().getMinBuildHeight() ? -0.1 : 0.0;
                } else if (!entity.isNoGravity()) {
                    d7 -= d0;
                }
                if (entity.shouldDiscardFriction()) {
                    entity.setDeltaMovement(vec3d6.x, d7, vec3d6.z);
                } else {
                    entity.setDeltaMovement(vec3d6.x * (double)f, d7 * 0.98, vec3d6.z * (double)f);
                }
            }
        }
        entity.calculateEntityAnimation(entity instanceof FlyingAnimal);
    }

    public static TreeMap<?, ?> getBehaviorMap(LivingEntity entity) {
        try {
            return AVAILABLE_BEHAVIORS_BY_PRIORITY.invoke(entity.getBrain());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends net.minecraft.world.entity.Entity> net.minecraft.world.entity.EntityType<T> getEntityType(Class<?> clazz) {
        return CITIZENS_ENTITY_TYPES.get(clazz);
    }

    public static net.minecraft.world.entity.Entity getHandle(Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    private static LivingEntity getHandle(org.bukkit.entity.LivingEntity entity) {
        return (LivingEntity)NMSImpl.getHandle((Entity)entity);
    }

    private static LivingEntity getHandle(Tameable entity) {
        return (LivingEntity)NMSImpl.getHandle((Entity)entity);
    }

    public static PathNavigation getNavigation(Entity entity) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof Mob ? ((Mob)handle).getNavigation() : (handle instanceof MobAI ? ((MobAI)handle).getNavigation() : null);
    }

    private static Path getPathEntity(PathNavigation nav) {
        try {
            return nav instanceof EntityNavigation ? ((EntityNavigation)nav).getPathEntity() : NAVIGATION_PATH.invoke(nav);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Packet<?>> getPositionUpdate(Entity from, boolean position, Float bodyYaw, Float pitch, Float headYaw) {
        net.minecraft.world.entity.Entity handle = NMSImpl.getHandle(from);
        if (bodyYaw == null) {
            bodyYaw = Float.valueOf(handle.getYRot());
        }
        if (pitch == null) {
            pitch = Float.valueOf(handle.getXRot());
        }
        ArrayList toSend = Lists.newArrayList();
        if (position) {
            ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)((ServerLevel)handle.level()).getChunkSource().chunkMap.entityMap.get(handle.getId());
            if (entry == null) {
                Messaging.debug("Null tracker entity for ", from);
                return Collections.emptyList();
            }
            VecDeltaCodec vdc = null;
            try {
                ServerEntity serverEntity = SERVER_ENTITY_GETTER.invoke(entry);
                if (serverEntity == null) {
                    Messaging.debug("Null server entity for ", from);
                    return Collections.emptyList();
                }
                vdc = POSITION_CODEC_GETTER.invoke(serverEntity);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
            Vec3 pos = handle.trackingPosition();
            toSend.add(new ClientboundMoveEntityPacket.PosRot(handle.getId(), (short)vdc.encodeX(pos), (short)vdc.encodeY(pos), (short)vdc.encodeZ(pos), (byte)(bodyYaw.floatValue() * 256.0f / 360.0f), (byte)(pitch.floatValue() * 256.0f / 360.0f), handle.onGround));
        } else {
            toSend.add(new ClientboundMoveEntityPacket.Rot(handle.getId(), (byte)(bodyYaw.floatValue() * 256.0f / 360.0f), (byte)(pitch.floatValue() * 256.0f / 360.0f), handle.onGround));
        }
        if (headYaw != null) {
            toSend.add(new ClientboundRotateHeadPacket(handle, (byte)(headYaw.floatValue() * 256.0f / 360.0f)));
        }
        return toSend;
    }

    public static EntityDimensions getSize(net.minecraft.world.entity.Entity entity) {
        try {
            return SIZE_FIELD_GETTER.invoke(entity);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoundEvent getSoundEffect(NPC npc, SoundEvent snd, NPC.Metadata meta) {
        if (npc == null) {
            return snd;
        }
        String data = (String)npc.data().get(meta);
        return data == null ? snd : (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.tryParse((String)data));
    }

    public static boolean isLeashed(NPC npc, Supplier<Boolean> isLeashed, Mob entity) {
        return NMS.isLeashed(npc, isLeashed, () -> entity.dropLeash(true, false));
    }

    public static void minecartItemLogic(AbstractMinecart minecart) {
        NPC npc = ((NPCHolder)minecart).getNPC();
        if (npc == null) {
            return;
        }
        Material mat = Material.getMaterial((String)npc.data().get(NPC.Metadata.MINECART_ITEM, ""), (boolean)false);
        int data = npc.data().get(NPC.Metadata.MINECART_ITEM_DATA, Integer.valueOf(0));
        int offset = npc.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0));
        minecart.setCustomDisplay(mat != null);
        if (mat != null) {
            minecart.setDisplayBlockState(((Block)BuiltInRegistries.BLOCK.byId(mat.getId())).defaultBlockState());
        }
        minecart.setDisplayOffset(offset);
    }

    public static boolean moveFish(NPC npc, Mob handle, Vec3 vec3d) {
        if (npc == null || npc.useMinecraftAI()) {
            return false;
        }
        if (handle.isInWater() && !npc.getNavigator().isNavigating()) {
            handle.moveRelative(handle instanceof Dolphin || handle instanceof Axolotl ? handle.getSpeed() : (handle instanceof Turtle ? 0.1f : 0.01f), vec3d);
            handle.move(MoverType.SELF, handle.getDeltaMovement());
            handle.setDeltaMovement(handle.getDeltaMovement().scale(0.9));
            return true;
        }
        return false;
    }

    public static void resetPuffTicks(Pufferfish fish) {
        try {
            PUFFERFISH_INFLATE.invoke(fish, 0);
            PUFFERFISH_DEFLATE.invoke(fish, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void restoreGoals(NPC npc, GoalSelector ... goalSelectors) {
        if (goalSelectors == null) {
            return;
        }
        int i = 0;
        for (GoalSelector selector : goalSelectors) {
            try {
                Set list = selector.getAvailableGoals();
                list.clear();
                Collection old = (Collection)npc.data().get("selector" + i);
                if (old != null) {
                    list.addAll(old);
                }
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", e.getLocalizedMessage());
            }
            catch (Throwable e) {
                Messaging.logTr("citizens.nms-errors.restoring-goals", e.getLocalizedMessage());
            }
            ++i;
        }
    }

    public static void sendPacket(org.bukkit.entity.Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player)).connection.send(packet);
    }

    public static void sendPackets(org.bukkit.entity.Player player, Iterable<Packet<?>> packets) {
        if (packets == null) {
            return;
        }
        for (Packet<?> packet : packets) {
            ((ServerPlayer)NMSImpl.getHandle((org.bukkit.entity.LivingEntity)player)).connection.send(packet);
        }
    }

    public static void setAttribute(LivingEntity entity, Holder<Attribute> attribute, double value) {
        AttributeInstance attr = entity.getAttribute(attribute);
        if (attr == null) {
            try {
                AttributeSupplier provider = ATTRIBUTE_SUPPLIER.invoke(entity.getAttributes());
                HashMap all = Maps.newHashMap((Map)ATTRIBUTE_PROVIDER_MAP.invoke(provider));
                all.put(attribute, new AttributeInstance(attribute, att -> {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance FOLLOW_RANGE");
                }));
                ATTRIBUTE_PROVIDER_MAP_SETTER.invoke(provider, ImmutableMap.copyOf((Map)all));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            attr = entity.getAttribute(attribute);
        }
        attr.setBaseValue(value);
    }

    public static void setBukkitEntity(net.minecraft.world.entity.Entity entity, CraftEntity bukkitEntity) {
        try {
            BUKKITENTITY_FIELD_SETTER.invoke(entity, bukkitEntity);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setFallingBlockState(FallingBlockEntity handle, BlockState state) {
        try {
            FALLING_BLOCK_STATE_SETTER.invoke(handle, state);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setLife(FishingHook entity, int life) {
        try {
            FISHING_HOOK_LIFE.invoke(entity, life);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setLookControl(Mob mob, LookControl control) {
        try {
            LOOK_CONTROL_SETTER.invoke(mob, control);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setNotInSchool(AbstractFish entity) {
        try {
            if (ENTITY_FISH_NUM_IN_SCHOOL != null) {
                ENTITY_FISH_NUM_IN_SCHOOL.invoke(entity, 2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void setScuteTime(net.minecraft.world.entity.Entity armadillo, int scuteTime) {
        if (ARMADILLO_SCUTE_TIME == null) {
            return;
        }
        try {
            ARMADILLO_SCUTE_TIME.invoke(armadillo, scuteTime);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.world.entity.Entity entity, boolean justCreated) {
        try {
            EntityDimensions entitysize = SIZE_FIELD_GETTER.invoke(entity);
            Pose entitypose = entity.getPose();
            EntityDimensions entitysize1 = entity.getDimensions(entitypose);
            SIZE_FIELD_SETTER.invoke(entity, entitysize1);
            ENTITY_EYE_HEIGHT.invoke(entity, entity.getType().getDimensions().eyeHeight());
            if (entitysize1.width() < entitysize.width()) {
                // empty if block
            }
            AABB axisalignedbb = entity.getBoundingBox();
            entity.setBoundingBox(new AABB(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ, axisalignedbb.minX + (double)entitysize1.width(), axisalignedbb.minY + (double)entitysize1.height(), axisalignedbb.minZ + (double)entitysize1.width()));
            if (entitysize1.width() > entitysize.width() && !justCreated && !entity.level().isClientSide) {
                float f = entitysize.width() - entitysize1.width();
                entity.move(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.world.entity.Entity entity, EntityDimensions size) {
        try {
            SIZE_FIELD_SETTER.invoke(entity, size);
            ENTITY_EYE_HEIGHT.invoke(entity, entity.getType().getDimensions().eyeHeight());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static net.minecraft.world.entity.Entity teleportAcrossWorld(net.minecraft.world.entity.Entity entity, DimensionTransition transition) {
        if (entity.isRemoved()) {
            return null;
        }
        NPC npc = ((NPCHolder)entity).getNPC();
        if (npc == null) {
            return null;
        }
        npc.despawn(DespawnReason.PENDING_RESPAWN);
        npc.spawn(new Location((World)transition.newLevel().getWorld(), transition.pos().x, transition.pos().y, transition.pos().z, transition.yRot(), transition.xRot()));
        net.minecraft.world.entity.Entity handle = ((CraftEntity)npc.getEntity()).getHandle();
        handle.setDeltaMovement(transition.speed());
        handle.portalCooldown = entity.portalCooldown;
        return handle;
    }

    public static void updateAI(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob handle = (Mob)entity;
            handle.getSensing().tick();
            handle.getNavigation().tick();
            handle.getMoveControl().tick();
            handle.getLookControl().tick();
            handle.getJumpControl().tick();
        } else if (entity instanceof MobAI) {
            ((MobAI)entity).tickAI();
        }
    }

    public static void updateMinecraftAIState(NPC npc, Mob entity) {
        if (npc == null) {
            return;
        }
        if (npc.useMinecraftAI()) {
            NMSImpl.restoreGoals(npc, entity.goalSelector, entity.targetSelector);
            if (npc.data().has("behavior-map")) {
                TreeMap behavior = (TreeMap)npc.data().get("behavior-map");
                NMSImpl.getBehaviorMap((LivingEntity)entity).putAll(behavior);
                npc.data().remove("behavior-map");
            }
        } else {
            NMSImpl.clearGoals(npc, entity.goalSelector, entity.targetSelector);
            TreeMap<?, ?> behaviorMap = NMSImpl.getBehaviorMap((LivingEntity)entity);
            if (behaviorMap.size() > 0) {
                npc.data().set("behavior-map", new TreeMap((SortedMap<?, ?>)behaviorMap));
                behaviorMap.clear();
            }
        }
    }

    static {
        FALLING_BLOCK_STATE_SETTER = NMS.getFirstSetter(FallingBlockEntity.class, BlockState.class);
        FISHING_HOOK_LIFE = NMS.getSetter(FishingHook.class, "i");
        FLYING_MOVECONTROL_FLOAT_GETTER = NMS.getFirstGetter(FlyingMoveControl.class, Boolean.TYPE);
        FLYING_MOVECONTROL_FLOAT_SETTER = NMS.getFirstSetter(FlyingMoveControl.class, Boolean.TYPE);
        FOX_SET_FACEPLANTED = NMS.getMethodHandle(Fox.class, "B", true, Boolean.TYPE);
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        INTERACTION_HEIGHT = null;
        INTERACTION_WIDTH = null;
        JUMP_FIELD = NMS.getGetter(LivingEntity.class, "bn");
        LOOK_CONTROL_SETTER = NMS.getFirstSetter(Mob.class, LookControl.class);
        MINECRAFT_CLIENT = NMS.getFirstGetter(YggdrasilMinecraftSessionService.class, MinecraftClient.class);
        MOVE_CONTROLLER_OPERATION = NMS.getSetter(MoveControl.class, "k");
        NAVIGATION_CREATE_PATHFINDER = NMS.getFirstMethodHandleWithReturnType(PathNavigation.class, true, PathFinder.class, Integer.TYPE);
        NAVIGATION_PATH = NMS.getFirstGetter(PathNavigation.class, Path.class);
        NAVIGATION_PATHFINDER = NMS.getFirstFinalSetter(PathNavigation.class, PathFinder.class);
        NAVIGATION_WORLD_FIELD = NMS.getFirstSetter(PathNavigation.class, Level.class);
        PAPER_PLAYER_MOB_COUNTS = NMS.getGetter(ServerPlayer.class, "mobCounts", false);
        PLAYERINFO_ENTRIES = PLAYER_INFO_ENTRIES_LIST = NMS.getFirstFinalSetter(ClientboundPlayerInfoUpdatePacket.class, List.class);
        POSITION_CODEC_GETTER = NMS.getFirstGetter(ServerEntity.class, VecDeltaCodec.class);
        PUFFERFISH_DEFLATE = NMS.getSetter(Pufferfish.class, "cd");
        PUFFERFISH_INFLATE = NMS.getSetter(Pufferfish.class, "cc");
        RABBIT_TYPE_DATAWATCHER = null;
        RANDOM = Util.getFastRandom();
        SERVER_ENTITY_GETTER = NMS.getFirstGetter(ChunkMap.TrackedEntity.class, ServerEntity.class);
        SIZE_FIELD_GETTER = NMS.getFirstGetter(net.minecraft.world.entity.Entity.class, EntityDimensions.class);
        SIZE_FIELD_SETTER = NMS.getFirstSetter(net.minecraft.world.entity.Entity.class, EntityDimensions.class);
        TRACKED_ENTITY_SETTERS = NMS.getSettersOfType(net.minecraft.world.entity.Entity.class, ChunkMap.TrackedEntity.class);
        try {
            ENTITY_REGISTRY = new CustomEntityRegistry(BuiltInRegistries.ENTITY_TYPE);
            ENTITY_REGISTRY_SETTER = NMS.getFinalSetter(BuiltInRegistries.class, "f");
            ENTITY_REGISTRY_SETTER.invoke(ENTITY_REGISTRY);
        }
        catch (Throwable e) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
        }
        try {
            ENDERMAN_CREEPY = (EntityDataAccessor)NMS.getField(EnderMan.class, "ce").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RABBIT_TYPE_DATAWATCHER = NMS.getFirstStaticGetter(Rabbit.class, EntityDataAccessor.class).invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            INTERACTION_HEIGHT = NMS.getGetter(Interaction.class, "d").invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            INTERACTION_WIDTH = NMS.getGetter(Interaction.class, "c").invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DATA_POSE = NMS.getGetter(net.minecraft.world.entity.Entity.class, "at").invoke();
            DATA_NAME_VISIBLE = NMS.getGetter(net.minecraft.world.entity.Entity.class, "aR").invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class MCTargetNavigator
    implements MCTargetStrategy.TargetNavigator {
        private final Entity entity;
        private final PathNavigation navigation;
        private final NavigatorParameters parameters;
        private final Entity target;

        private MCTargetNavigator(Entity entity, PathNavigation navigation, Entity target, NavigatorParameters parameters) {
            this.entity = entity;
            this.navigation = navigation;
            this.target = target;
            this.parameters = parameters;
        }

        @Override
        public Location getCurrentDestination() {
            return NMS.getDestination(this.entity);
        }

        @Override
        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        @Override
        public void setPath() {
            Location location = this.parameters.entityTargetLocationMapper().apply(this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.moveTo(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speed());
        }

        @Override
        public void stop() {
            this.navigation.stop();
        }

        @Override
        public void update() {
            this.navigation.tick();
        }
    }

    private final class CitizensAnvilMenu
    extends AnvilMenu {
        private final Inventory anvil;
        private CraftAnvilView bukkitEntity;

        private CitizensAnvilMenu(int i, net.minecraft.world.entity.player.Inventory playerinventory, ContainerLevelAccess containeraccess, Inventory anvil) {
            super(i, playerinventory, containeraccess);
            this.anvil = anvil;
        }

        protected void clearContainer(Player entityhuman, Container iinventory) {
        }

        public void createResult() {
            super.createResult();
            this.cost.set(0);
        }

        public CraftAnvilView getBukkitView() {
            if (this.bukkitEntity == null) {
                this.bukkitEntity = new CraftAnvilView((HumanEntity)this.player.getBukkitEntity(), (AnvilInventory)new CitizensInventoryAnvil(this.access.getLocation(), this.inputSlots, (Container)this.resultSlots, this, this.anvil), (AnvilMenu)this);
            }
            return this.bukkitEntity;
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final PathNavigation navigation;

        public NavigationIterable(PathNavigation nav) {
            this.navigation = nav;
        }

        @Override
        public Iterator<Vector> iterator() {
            final Path path = NMSImpl.getPathEntity(this.navigation);
            final int npoints = path == null ? 0 : path.getNodeCount();
            return new Iterator<Vector>(){
                Node curr;
                int i;
                {
                    this.curr = npoints > 0 ? path.getNode(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    Node old = this.curr;
                    this.curr = this.i + 1 < npoints ? path.getNode(++this.i) : null;
                    return new Vector(old.x, old.y, old.z);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CitizensInventoryAnvil
    extends CraftInventoryAnvil
    implements ForwardingInventory {
        private final Inventory wrapped;

        public CitizensInventoryAnvil(Location location, Container inventory, Container resultInventory, AnvilMenu container, Inventory wrapped) {
            super(location, inventory, resultInventory);
            this.wrapped = wrapped;
        }

        @Override
        public Inventory getWrapped() {
            return this.wrapped;
        }

        public void setItem(int slot, ItemStack item) {
            super.setItem(slot, item);
            this.wrapped.setItem(slot, item);
        }
    }
}

