/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.citizensnpcs.npc.EntityController;
import org.bukkit.entity.EntityType;

public class EntityControllers {
    private static Map<EntityType, Constructor<? extends EntityController>> TYPES = Maps.newEnumMap(EntityType.class);

    public static boolean controllerExistsForType(EntityType type) {
        return TYPES.containsKey(type);
    }

    public static EntityController createForType(EntityType type) {
        Constructor<? extends EntityController> constructor = TYPES.get(type);
        if (constructor == null) {
            throw new IllegalArgumentException("Unknown EntityType: " + type);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            Throwables.getRootCause((Throwable)ex).printStackTrace();
            return null;
        }
    }

    public static void setEntityControllerForType(EntityType type, Class<? extends EntityController> controller) {
        try {
            Constructor<? extends EntityController> constructor = controller.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            TYPES.put(type, constructor);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

