/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;

@TraitName(value="attributetrait")
public class AttributeTrait
extends Trait {
    @Persist(keyType=Attribute.class)
    private final Map<Attribute, Double> attributes = Maps.newEnumMap(Attribute.class);

    public AttributeTrait() {
        super("attributetrait");
    }

    public Double getAttributeValue(Attribute attribute) {
        return this.attributes.get(attribute);
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.attributes.containsKey(attribute);
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)this.npc.getEntity();
        for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
            le.getAttribute(entry.getKey()).setBaseValue(entry.getValue().doubleValue());
        }
    }

    public void setAttributeValue(Attribute attribute, double value) {
        this.attributes.put(attribute, value);
        this.onSpawn();
    }

    public void setDefaultAttribute(Attribute attribute) {
        this.attributes.remove(attribute);
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)this.npc.getEntity();
        AttributeInstance instance = le.getAttribute(attribute);
        instance.setBaseValue(instance.getDefaultValue());
    }
}

