/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.List;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

@TraitName(value="controllable")
public class Controllable
extends Trait {
    private MovementController controller;
    @Persist
    private BuiltInControls controls;
    @Persist
    private boolean enabled = true;
    @Persist(value="owner_required")
    private boolean ownerRequired;

    public Controllable() {
        super("controllable");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean mount(Player toMount) {
        List<Entity> passengers = NMS.getPassengers(this.npc.getEntity());
        if (passengers.size() != 0) {
            return false;
        }
        boolean found = false;
        for (Entity passenger : passengers) {
            if (passenger == null || passenger != toMount) continue;
            found = true;
            break;
        }
        if (found) {
            return false;
        }
        Controllable.enterOrLeaveVehicle(this.npc, toMount);
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        Action performed = event.getAction();
        if (!NMS.getPassengers(this.npc.getEntity()).contains(event.getPlayer())) {
            return;
        }
        switch (performed) {
            case RIGHT_CLICK_BLOCK: {
                if (event.isCancelled()) {
                    return;
                }
            }
            case RIGHT_CLICK_AIR: {
                this.controller.rightClick(event);
                break;
            }
            case LEFT_CLICK_BLOCK: {
                if (event.isCancelled()) {
                    return;
                }
            }
            case LEFT_CLICK_AIR: {
                this.controller.leftClick(event);
                break;
            }
        }
    }

    @EventHandler
    private void onRightClick(NPCRightClickEvent event) {
        if (!(this.enabled && this.npc.isSpawned() && event.getNPC().equals(this.npc))) {
            return;
        }
        this.controller.rightClickEntity(event);
        event.setDelayedCancellation(true);
    }

    @Override
    public void onSpawn() {
        if (this.controls != null) {
            this.controller = (MovementController)this.controls.factory.apply(this.npc);
            return;
        }
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof Vehicle)) {
            this.controller = new LookAirController(this.npc);
            return;
        }
        this.controller = Util.isAlwaysFlyable(this.npc.getEntity().getType()) ? new PlayerInputAirController(this.npc) : new GroundController(this.npc);
    }

    @Override
    public void run() {
        if (!this.enabled || !this.npc.isSpawned()) {
            return;
        }
        List<Entity> passengers = NMS.getPassengers(this.npc.getEntity());
        if (passengers.size() == 0 || !(passengers.get(0) instanceof Player) || this.npc.getNavigator().isNavigating()) {
            return;
        }
        this.controller.run((Player)passengers.get(0));
    }

    public void setControls(BuiltInControls controls) {
        this.controls = controls;
    }

    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return enabled;
    }

    public void setOwnerRequired(boolean ownerRequired) {
        this.ownerRequired = ownerRequired;
    }

    public boolean toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && NMS.getPassengers(this.npc.getEntity()).size() > 0) {
            NMS.getPassengers(this.npc.getEntity()).get(0).leaveVehicle();
        }
        return this.enabled;
    }

    private static void enterOrLeaveVehicle(NPC npc, Player player) {
        List<Entity> passengers = NMS.getPassengers((Entity)player);
        if (passengers.size() > 0) {
            if (passengers.contains(player)) {
                player.leaveVehicle();
            }
            return;
        }
        if (!player.hasPermission("citizens.npc.controllable." + Util.prettyEnum(npc.getEntity().getType())) || !player.hasPermission("citizens.npc.controllable") || npc.getOrAddTrait(Controllable.class).ownerRequired && !npc.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            return;
        }
        NMS.mount(npc.getEntity(), (Entity)player);
    }

    private static void setMountedYaw(Entity entity) {
        if (entity instanceof EnderDragon || !Settings.Setting.USE_BOAT_CONTROLS.asBoolean()) {
            return;
        }
        Location loc = entity.getLocation();
        Vector vel = entity.getVelocity();
        if (vel.lengthSquared() == 0.0) {
            return;
        }
        double tX = loc.getX() + vel.getX();
        double tZ = loc.getZ() + vel.getZ();
        if (loc.getZ() > tZ) {
            loc.setYaw((float)(-Math.toDegrees(Math.atan((loc.getX() - tX) / (loc.getZ() - tZ)))) + 180.0f);
        } else if (loc.getZ() < tZ) {
            loc.setYaw((float)(-Math.toDegrees(Math.atan((loc.getX() - tX) / (loc.getZ() - tZ)))));
        }
        NMS.look(entity, loc.getYaw(), loc.getPitch());
    }

    private static double updateHorizontalSpeed(Entity handle, Entity passenger, double speed, float speedMod, double maxSpeed) {
        double newSpeed;
        Vector vel = handle.getVelocity();
        double oldSpeed = Math.sqrt(vel.getX() * vel.getX() + vel.getZ() * vel.getZ());
        double horizontal = NMS.getHorizontalMovement(passenger);
        if (Math.abs(Math.abs(horizontal) - 0.98) > 0.02) {
            return speed;
        }
        double yaw = passenger.getLocation().getYaw();
        if (horizontal > 0.0) {
            double dXcos = -Math.sin(yaw * Math.PI / 180.0);
            double dXsin = Math.cos(yaw * Math.PI / 180.0);
            vel = vel.setX(dXcos * speed * (double)speedMod).setZ(dXsin * speed * (double)speedMod);
        }
        if ((newSpeed = Math.sqrt((vel = vel.add(new Vector(passenger.getVelocity().getX() * (double)speedMod * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble(), 0.0, passenger.getVelocity().getZ() * (double)speedMod * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble())).multiply(0.98)).getX() * vel.getX() + vel.getZ() * vel.getZ())) > maxSpeed) {
            vel = vel.multiply(new Vector(maxSpeed / newSpeed, 1.0, maxSpeed / newSpeed));
            newSpeed = maxSpeed;
        }
        handle.setVelocity(vel);
        if (newSpeed > oldSpeed && speed < maxSpeed) {
            return (float)Math.min(maxSpeed, speed + (maxSpeed - speed) / 50.0);
        }
        return (float)Math.max(0.0, speed - speed / 50.0);
    }

    public static interface MovementController {
        public void leftClick(PlayerInteractEvent var1);

        public void rightClick(PlayerInteractEvent var1);

        public void rightClickEntity(NPCRightClickEvent var1);

        public void run(Player var1);
    }

    public static enum BuiltInControls {
        AIR(PlayerInputAirController::new),
        GROUND(GroundController::new),
        GROUND_JUMPLESS(JumplessGroundController::new),
        LOOK_AIR(LookAirController::new);

        private final Function<NPC, MovementController> factory;

        private BuiltInControls(Function<NPC, MovementController> factory) {
            this.factory = factory;
        }
    }

    public static class LookAirController
    implements MovementController {
        private final NPC npc;
        private boolean paused = false;

        public LookAirController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.enterOrLeaveVehicle(this.npc, event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.001));
                return;
            }
            Vector dir = rider.getEyeLocation().getDirection();
            dir.multiply(this.npc.getNavigator().getDefaultParameters().speedModifier());
            this.npc.getEntity().setVelocity(dir);
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }

    public static class PlayerInputAirController
    implements MovementController {
        private final NPC npc;
        private boolean paused = false;
        private double speed;

        public PlayerInputAirController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(-0.25f));
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.enterOrLeaveVehicle(this.npc, event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.001f));
                return;
            }
            this.speed = Controllable.updateHorizontalSpeed(this.npc.getEntity(), (Entity)rider, this.speed, 1.0f, Settings.Setting.MAX_CONTROLLABLE_FLIGHT_SPEED.asDouble());
            boolean shouldJump = NMS.shouldJump((Entity)rider);
            if (shouldJump) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.25f));
            }
            this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().multiply(new Vector(1.0, 0.98, 1.0)));
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }

    public static class GroundController
    implements MovementController {
        private int jumpTicks = 0;
        private final NPC npc;
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;
        private static final float JUMP_VELOCITY = 0.5f;

        public GroundController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.enterOrLeaveVehicle(this.npc, event.getClicker());
        }

        @Override
        public void run(Player rider) {
            boolean onGround = NMS.isOnGround(this.npc.getEntity());
            float impulse = this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 0.5f : 0.5f);
            if (!Util.isHorse(this.npc.getEntity().getType())) {
                this.speed = Controllable.updateHorizontalSpeed(this.npc.getEntity(), (Entity)rider, this.speed, impulse, Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble());
            }
            if (onGround && this.jumpTicks <= 0 && NMS.shouldJump((Entity)rider)) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.5f));
                this.jumpTicks = 10;
            }
            --this.jumpTicks;
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }

    public static class JumplessGroundController
    implements MovementController {
        private final NPC npc;
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;

        public JumplessGroundController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.enterOrLeaveVehicle(this.npc, event.getClicker());
        }

        @Override
        public void run(Player rider) {
            boolean onGround = NMS.isOnGround(this.npc.getEntity());
            float impulse = this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 0.5f : 0.5f);
            if (!Util.isHorse(this.npc.getEntity().getType())) {
                this.speed = Controllable.updateHorizontalSpeed(this.npc.getEntity(), (Entity)rider, this.speed, impulse, Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble());
            }
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }
}

