/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import com.google.common.base.Joiner;
import java.time.Duration;
import java.util.Arrays;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.text.Text;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TextBasePrompt
extends StringPrompt {
    private final Text text;

    public TextBasePrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptInput(ConversationContext context, String original) {
        String[] parts = ChatColor.stripColor((String)original.trim()).split(" ");
        String input = parts[0];
        CommandSender sender = (CommandSender)context.getForWhom();
        Messaging.send(sender, this.getPromptText(context));
        if (input.equalsIgnoreCase("add")) {
            this.text.add(Joiner.on((char)' ').join((Object[])Arrays.copyOfRange(parts, 1, parts.length)));
            return this;
        }
        if (input.equalsIgnoreCase("edit")) {
            if (parts.length < 2) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-index", "missing index");
            } else {
                int index = Integer.parseInt(parts[1]);
                if (!this.text.hasIndex(index)) {
                    Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-index", index);
                } else {
                    this.text.edit(index, Joiner.on((char)' ').join((Object[])Arrays.copyOfRange(parts, 2, parts.length)));
                }
            }
        } else if (input.equalsIgnoreCase("remove")) {
            int index = Integer.parseInt(parts[1]);
            if (!this.text.hasIndex(index)) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-index", new Object[0]);
            } else {
                this.text.remove(index);
            }
        } else if (input.equalsIgnoreCase("page")) {
            try {
                int page = Integer.parseInt(parts[1]);
                if (!this.text.hasPage(page)) {
                    Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-page", new Object[0]);
                }
                context.setSessionData((Object)"page", (Object)page);
            }
            catch (NumberFormatException e) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-page", new Object[0]);
            }
        } else if (input.equalsIgnoreCase("delay")) {
            try {
                int delay = Integer.parseInt(parts[1]);
                this.text.setDelay(delay);
                Messaging.sendTr(sender, "citizens.editors.text.delay-set", delay);
            }
            catch (NumberFormatException e) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-delay", new Object[0]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-delay", new Object[0]);
            }
        } else if (input.equalsIgnoreCase("random")) {
            this.text.toggleRandomTalker();
        } else if (original.trim().equalsIgnoreCase("send text to chat")) {
            this.text.toggleSendTextToChat();
        } else if (original.trim().equalsIgnoreCase("realistic looking")) {
            this.text.toggleRealisticLooking();
        } else if (original.trim().equalsIgnoreCase("speech bubbles")) {
            this.text.toggleSpeechBubbles();
        } else if (original.trim().startsWith("speech bubbles duration")) {
            try {
                Duration duration = SpigotUtil.parseDuration(original.replace("speech bubbles duration", "").trim(), null);
                this.text.setSpeechBubbleDuration(duration);
                Messaging.sendErrorTr(sender, "citizens.commands.npc.text.speech-bubbles-duration-set", duration);
            }
            catch (Exception exception) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.text.invalid-speech-bubbles-duration", new Object[0]);
            }
        } else if (input.equalsIgnoreCase("close") || original.trim().equalsIgnoreCase("talk close")) {
            this.text.toggleTalkClose();
        } else if (input.equalsIgnoreCase("range")) {
            try {
                double range = Math.min(Math.max(0.0, Double.parseDouble(parts[1])), Settings.Setting.MAX_TEXT_RANGE.asDouble());
                this.text.setRange(range);
                Messaging.sendTr(sender, "citizens.editors.text.range-set", range);
            }
            catch (NumberFormatException e) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-range", new Object[0]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-range", new Object[0]);
            }
        } else if (input.equalsIgnoreCase("item")) {
            if (parts.length > 1) {
                this.text.setItemInHandPattern(parts[1]);
                Messaging.sendTr(sender, "citizens.editors.text.talk-item-set", parts[1]);
            } else {
                Messaging.sendErrorTr(sender, "citizens.editors.text.missing-item-set-pattern", new Object[0]);
            }
        } else {
            Messaging.sendErrorTr(sender, "citizens.editors.text.invalid-edit-type", new Object[0]);
        }
        return this;
    }

    private String colorToggleableText(boolean enabled) {
        return (enabled ? "<green>" : "<red>").toString();
    }

    public String getPromptText(ConversationContext context) {
        Messaging.send((CommandSender)((Player)context.getForWhom()), Messaging.tr("citizens.editors.text.start-prompt", this.colorToggleableText(this.text.shouldTalkClose()), this.colorToggleableText(this.text.isRandomTalker()), this.colorToggleableText(this.text.useSpeechBubbles()), this.colorToggleableText(this.text.useRealisticLooking()), this.colorToggleableText(this.text.sendTextToChat())));
        int page = context.getSessionData((Object)"page") == null ? 1 : (Integer)context.getSessionData((Object)"page");
        this.text.sendPage((CommandSender)((Player)context.getForWhom()), page);
        return "";
    }
}

