/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@TraitName(value="bossbar")
public class BossBarTrait
extends Trait {
    private BossBar activeBar;
    @Persist
    private BarColor color = BarColor.PURPLE;
    @Persist
    private List<BarFlag> flags = Lists.newArrayList();
    private Supplier<Double> progressProvider;
    @Persist
    private int range = -1;
    @Persist
    private BarStyle style = BarStyle.SOLID;
    @Persist
    private String title = "";
    @Persist
    private String track;
    @Persist
    private String viewPermission;
    @Persist
    private boolean visible = true;
    private static boolean SUPPORT_ATTRIBUTES = true;

    public BossBarTrait() {
        super("bossbar");
    }

    private BossBar getBar() {
        if (this.npc.isSpawned() && this.isBoss(this.npc.getEntity()) && NMS.getBossBar(this.npc.getEntity()) != null) {
            return (BossBar)NMS.getBossBar(this.npc.getEntity());
        }
        if (this.activeBar == null) {
            this.activeBar = Bukkit.getServer().createBossBar(this.npc.getFullName(), this.color, this.style, this.flags.toArray(new BarFlag[this.flags.size()]));
        }
        return this.activeBar;
    }

    public BarColor getColor() {
        return this.color;
    }

    public List<BarFlag> getFlags() {
        return this.flags;
    }

    public int getRange() {
        return this.range;
    }

    public BarStyle getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTrackingVariable() {
        return this.track;
    }

    public String getViewPermission() {
        return this.viewPermission;
    }

    private boolean isBoss(Entity entity) {
        boolean isBoss;
        boolean bl = isBoss = entity.getType() == EntityType.ENDER_DRAGON || entity.getType() == EntityType.WITHER;
        if (isBoss) {
            this.onDespawn();
        }
        return isBoss;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onDespawn() {
        if (this.activeBar == null) {
            return;
        }
        this.activeBar.removeAll();
        this.activeBar.hide();
        this.activeBar = null;
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        BossBar bar = this.getBar();
        if (bar == null) {
            return;
        }
        if (this.track != null && !this.track.isEmpty()) {
            if (this.track.equalsIgnoreCase("health")) {
                if (this.npc.getEntity() instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)this.npc.getEntity();
                    double maxHealth = entity.getMaxHealth();
                    if (SUPPORT_ATTRIBUTES) {
                        try {
                            maxHealth = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                        }
                        catch (Throwable t) {
                            SUPPORT_ATTRIBUTES = false;
                        }
                    }
                    bar.setProgress(entity.getHealth() / maxHealth);
                }
            } else {
                String replaced = Placeholders.replace(this.track, this.npc.getEntity() instanceof Player ? (Player)this.npc.getEntity() : null);
                Double number = Doubles.tryParse((String)replaced);
                if (number == null) {
                    return;
                }
                if (number >= 1.0 && number <= 100.0) {
                    number = number / 100.0;
                }
                bar.setProgress(Math.max(0.0, Math.min(1.0, number)));
            }
        }
        bar.setTitle(this.title);
        bar.setVisible(this.visible);
        if (this.progressProvider != null) {
            bar.setProgress(this.progressProvider.get().doubleValue());
        }
        if (this.style != null) {
            bar.setStyle(this.style);
        }
        if (this.color != null) {
            bar.setColor(this.color);
        }
        for (BarFlag flag : BarFlag.values()) {
            bar.removeFlag(flag);
        }
        for (BarFlag flag : this.flags) {
            bar.addFlag(flag);
        }
        bar.removeAll();
        for (Player player : CitizensAPI.getLocationLookup().getNearbyPlayers(this.npc.getEntity().getLocation(), this.range > 0 ? (double)this.range : (double)Settings.Setting.BOSSBAR_RANGE.asInt())) {
            if (this.viewPermission != null && !player.hasPermission(this.viewPermission)) continue;
            bar.addPlayer(player);
        }
    }

    public void setColor(BarColor color) {
        this.color = color;
    }

    public void setFlags(Collection<BarFlag> flags) {
        this.flags = Lists.newArrayList(flags);
    }

    public void setFlags(List<BarFlag> flags) {
        this.flags = flags;
    }

    public void setProgressProvider(Supplier<Double> provider) {
        this.progressProvider = provider;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public void setStyle(BarStyle style) {
        this.style = style;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTrackVariable(String variable) {
        this.track = variable;
    }

    public void setViewPermission(String viewpermission) {
        this.viewPermission = viewpermission;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Command(aliases={"npc"}, usage="bossbar --style [style] --color [color] --title [title] --visible [visible] --viewpermission [permission] --flags [flags] --track [health | placeholder] --range [range]", desc="", modifiers={"bossbar"}, min=1, max=1)
    @Requirements(selected=true, ownership=true)
    public static void bossbar(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"style"}) BarStyle style, @Flag(value={"track"}) String track, @Flag(value={"color"}) BarColor color, @Flag(value={"visible"}) Boolean visible, @Flag(value={"range"}) Integer range, @Flag(value={"title"}) String title, @Flag(value={"flags"}) String flags, @Flag(value={"viewpermission"}) String viewpermission) throws CommandException {
        BossBarTrait trait = npc.getOrAddTrait(BossBarTrait.class);
        if (style != null) {
            trait.setStyle(style);
        }
        if (color != null) {
            trait.setColor(color);
        }
        if (track != null) {
            trait.setTrackVariable(track);
        }
        if (title != null) {
            trait.setTitle(Messaging.parseComponents(title));
        }
        if (visible != null) {
            trait.setVisible(visible);
        }
        if (range != null) {
            trait.setRange(range);
        }
        if (viewpermission != null) {
            trait.setViewPermission(viewpermission);
        }
        if (flags != null) {
            ArrayList parsed = Lists.newArrayList();
            for (String s : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)flags)) {
                BarFlag flag = (BarFlag)Util.matchEnum((Enum[])BarFlag.values(), (String)s);
                if (flag == null) continue;
                parsed.add(flag);
            }
            trait.setFlags(parsed);
        }
    }
}

