/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import java.util.function.Supplier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum EquipmentSlot {
    HAND(() -> EquipmentSlotGroup.MAINHAND),
    OFF_HAND(() -> EquipmentSlotGroup.OFFHAND),
    FEET(() -> EquipmentSlotGroup.FEET),
    LEGS(() -> EquipmentSlotGroup.LEGS),
    CHEST(() -> EquipmentSlotGroup.CHEST),
    HEAD(() -> EquipmentSlotGroup.HEAD),
    BODY(() -> EquipmentSlotGroup.BODY);

    private final Supplier<EquipmentSlotGroup> group;

    private EquipmentSlot(Supplier<EquipmentSlotGroup> group) {
        this.group = group;
    }

    @NotNull
    @ApiStatus.Internal
    public EquipmentSlotGroup getGroup() {
        return this.group.get();
    }

    public boolean isHand() {
        return this == HAND || this == OFF_HAND;
    }

    @NotNull
    public EquipmentSlot getOppositeHand() {
        return switch (this.ordinal()) {
            case 0 -> OFF_HAND;
            case 1 -> HAND;
            default -> throw new IllegalArgumentException("Unable to determine an opposite hand for equipment slot: " + this.name());
        };
    }

    public boolean isArmor() {
        return this == HEAD || this == CHEST || this == LEGS || this == FEET || this == BODY;
    }
}

