/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus;

import com.extendedclip.deluxemenus.cache.SimpleCache;
import com.extendedclip.deluxemenus.command.DeluxeMenusCommand;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.config.GeneralConfig;
import com.extendedclip.deluxemenus.dupe.DupeFixer;
import com.extendedclip.deluxemenus.dupe.MenuItemMarker;
import com.extendedclip.deluxemenus.hooks.BaseHeadHook;
import com.extendedclip.deluxemenus.hooks.ExecutableBlocksHook;
import com.extendedclip.deluxemenus.hooks.ExecutableItemsHook;
import com.extendedclip.deluxemenus.hooks.HeadDatabaseHook;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.hooks.ItemsAdderHook;
import com.extendedclip.deluxemenus.hooks.MMOItemsHook;
import com.extendedclip.deluxemenus.hooks.NamedHeadHook;
import com.extendedclip.deluxemenus.hooks.NexoHook;
import com.extendedclip.deluxemenus.hooks.OraxenHook;
import com.extendedclip.deluxemenus.hooks.SimpleItemGeneratorHook;
import com.extendedclip.deluxemenus.hooks.TextureHeadHook;
import com.extendedclip.deluxemenus.hooks.VaultHook;
import com.extendedclip.deluxemenus.libs.adventure.adventure.platform.bukkit.BukkitAudiences;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.bstats.bukkit.Metrics;
import com.extendedclip.deluxemenus.libs.bstats.charts.AdvancedPie;
import com.extendedclip.deluxemenus.libs.bstats.charts.SingleLineChart;
import com.extendedclip.deluxemenus.listener.PlayerListener;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.menu.options.HeadType;
import com.extendedclip.deluxemenus.menu.options.MenuOptions;
import com.extendedclip.deluxemenus.nbt.NbtProvider;
import com.extendedclip.deluxemenus.persistentmeta.PersistentMetaHandler;
import com.extendedclip.deluxemenus.placeholder.Expansion;
import com.extendedclip.deluxemenus.updatechecker.UpdateChecker;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.Messages;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class DeluxeMenus
extends JavaPlugin {
    public static final Map<String, Material> MATERIALS = Arrays.stream(Material.values()).collect(Collectors.toUnmodifiableMap(Enum::name, Function.identity()));
    private static final DebugLevel STACKTRACE_PRINT_LEVEL = DebugLevel.MEDIUM;
    private PersistentMetaHandler persistentMetaHandler;
    private MenuItemMarker menuItemMarker;
    private BukkitAudiences audiences;
    private VaultHook vaultHook;
    private ItemStack head;
    private Map<String, ItemHook> itemHooks;
    private final GeneralConfig generalConfig = new GeneralConfig(this);
    private DeluxeMenusConfig menuConfig;

    public void onLoad() {
        if (NbtProvider.isAvailable()) {
            this.debug(DebugLevel.HIGHEST, Level.INFO, "NMS hook has been setup successfully!");
            return;
        }
        this.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not setup a NMS hook for your server version! The following Item options will not work: nbt_int, nbt_ints, nbt_string and nbt_strings.");
    }

    public void onEnable() {
        this.generalConfig.load();
        if (!this.hookIntoPlaceholderAPI()) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.persistentMetaHandler = new PersistentMetaHandler(this);
        this.menuItemMarker = new MenuItemMarker(this);
        new DupeFixer(this, this.menuItemMarker).register();
        this.audiences = BukkitAudiences.create((Plugin)this);
        this.hookIntoVault();
        this.setUpItemHooks();
        this.menuConfig = new DeluxeMenusConfig(this);
        if (this.menuConfig.loadDefConfig()) {
            this.debug(DebugLevel.HIGHEST, Level.INFO, this.menuConfig.loadGUIMenus() + " GUI menus loaded!");
        } else {
            this.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to load from config.yml. Use /dm reload after fixing your errors.");
        }
        new PlayerListener(this).register();
        if (!new DeluxeMenusCommand(this).register()) {
            this.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not register the DeluxeMenus command!");
        }
        new Expansion(this).register();
        this.setUpBungeeCordMessaging();
        this.setUpUpdateChecker();
        this.setUpMetrics();
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        if (this.audiences != null) {
            this.audiences.close();
            this.audiences = null;
        }
        Menu.unloadForShutdown(this);
        this.itemHooks.clear();
        HandlerList.unregisterAll((Plugin)this);
    }

    public Optional<ItemHook> getItemHook(String id) {
        return Optional.ofNullable(this.itemHooks.get(id));
    }

    public Map<String, ItemHook> getItemHooks() {
        return this.itemHooks;
    }

    public ItemStack getHead() {
        return this.head != null ? this.head : new ItemStack(Material.DIRT, 1);
    }

    public boolean shouldPrintStackTrace() {
        return this.generalConfig.debugLevel().getPriority() <= STACKTRACE_PRINT_LEVEL.getPriority();
    }

    public void printStacktrace(String message, Throwable throwable) {
        if (!this.shouldPrintStackTrace()) {
            return;
        }
        this.getLogger().log(Level.SEVERE, message, throwable);
    }

    public void connect(Player p, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (Exception e) {
            this.debug(DebugLevel.HIGHEST, Level.SEVERE, "There was a problem attempting to send " + p.getName() + " to server " + server + "!");
            this.printStacktrace("There was a problem attempting to send " + p.getName() + " to server " + server + "!", e);
        }
        p.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
    }

    public void sms(CommandSender s, Component msg) {
        this.audiences().sender(s).sendMessage(msg);
    }

    public void sms(CommandSender s, Messages msg) {
        this.audiences().sender(s).sendMessage(msg.message());
    }

    public void debug(@NotNull DebugLevel messageDebugLevel, @NotNull Level level, String ... messages) {
        this.debug(this.generalConfig.debugLevel(), messageDebugLevel, level, messages);
    }

    public void debug(@NotNull DebugLevel generalDebugLevel, @NotNull DebugLevel messageDebugLevel, @NotNull Level level, String ... messages) {
        if (generalDebugLevel.getPriority() > messageDebugLevel.getPriority()) {
            return;
        }
        this.getLogger().log(level, String.join((CharSequence)System.lineSeparator(), messages));
    }

    public MenuItemMarker getMenuItemMarker() {
        return this.menuItemMarker;
    }

    public DeluxeMenusConfig getConfiguration() {
        return this.menuConfig;
    }

    public VaultHook getVault() {
        return this.vaultHook;
    }

    public PersistentMetaHandler getPersistentMetaHandler() {
        return this.persistentMetaHandler;
    }

    public BukkitAudiences audiences() {
        if (this.audiences == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.audiences;
    }

    public void clearCaches() {
        this.itemHooks.values().stream().filter(Objects::nonNull).filter(hook -> hook instanceof SimpleCache).map(hook -> (SimpleCache)((Object)hook)).forEach(SimpleCache::clearCache);
    }

    public void reload() {
        this.generalConfig.reload();
    }

    public GeneralConfig getGeneralConfig() {
        return this.generalConfig;
    }

    private boolean hookIntoPlaceholderAPI() {
        boolean canHook;
        boolean bl = canHook = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        if (!canHook) {
            this.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not hook into PlaceholderAPI!", "DeluxeMenus will now disable!");
            return false;
        }
        this.debug(DebugLevel.HIGHEST, Level.INFO, "Successfully hooked into PlaceholderAPI!");
        return true;
    }

    private void hookIntoVault() {
        if (!Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            return;
        }
        this.vaultHook = new VaultHook();
        if (this.vaultHook.hooked()) {
            this.debug(DebugLevel.HIGHEST, Level.INFO, "Successfully hooked into Vault!");
            return;
        }
        this.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not hook into Vault!", "DeluxeMenus will continue to work but some features (such as the 'has money' requirement) may not be available.");
    }

    private void setUpItemHooks() {
        this.head = !VersionHelper.IS_ITEM_LEGACY ? new ItemStack(Material.PLAYER_HEAD, 1) : new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        this.itemHooks = new HashMap<String, ItemHook>();
        NamedHeadHook namedHeadHook = new NamedHeadHook(this);
        namedHeadHook.register();
        this.itemHooks.put(HeadType.NAMED.getHookName(), namedHeadHook);
        this.itemHooks.put(HeadType.BASE64.getHookName(), new BaseHeadHook(this));
        this.itemHooks.put(HeadType.TEXTURE.getHookName(), new TextureHeadHook(this));
        if (Bukkit.getPluginManager().isPluginEnabled("HeadDatabase")) {
            try {
                Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
                this.itemHooks.put(HeadType.HDB.getHookName(), new HeadDatabaseHook(this));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (Bukkit.getPluginManager().isPluginEnabled("ItemsAdder")) {
            this.itemHooks.put("itemsadder", new ItemsAdderHook());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Nexo")) {
            this.itemHooks.put("nexo", new NexoHook());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Oraxen")) {
            this.itemHooks.put("oraxen", new OraxenHook());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("MMOItems")) {
            this.itemHooks.put("mmoitems", new MMOItemsHook(this));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("ExecutableItems")) {
            this.itemHooks.put("executableitems", new ExecutableItemsHook());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("ExecutableBlocks")) {
            this.itemHooks.put("executableblocks", new ExecutableBlocksHook());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("SimpleItemGenerator")) {
            this.itemHooks.put("simpleitemgenerator", new SimpleItemGeneratorHook(this));
        }
    }

    private void setUpBungeeCordMessaging() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    private void setUpUpdateChecker() {
        if (!this.generalConfig.checkForUpdates()) {
            return;
        }
        UpdateChecker updateChecker = new UpdateChecker(this);
        updateChecker.register();
        if (updateChecker.updateAvailable()) {
            this.debug(DebugLevel.HIGHEST, Level.INFO, "An update for DeluxeMenus (DeluxeMenus v" + updateChecker.getLatestVersion() + ")", "is available at https://www.spigotmc.org/resources/deluxemenus.11734/");
            return;
        }
        this.debug(DebugLevel.HIGHEST, Level.INFO, "You are running the latest version of DeluxeMenus!");
    }

    private void setUpMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 445);
        metrics.addCustomChart(new SingleLineChart("menus", Menu::getLoadedMenuSize));
        metrics.addCustomChart(new AdvancedPie("inventory_types", () -> Menu.getAllMenus().stream().map(Menu::options).map(MenuOptions::type).collect(Collectors.groupingBy(Enum::name, Collectors.summingInt(type -> 1)))));
        metrics.addCustomChart(new AdvancedPie("nbt_usage", () -> {
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            List options = Menu.getAllMenus().stream().map(Menu::getMenuItems).flatMap(c -> c.values().stream().map(TreeMap::values).flatMap(Collection::stream)).map(MenuItem::options).collect(Collectors.toList());
            results.put("Byte", options.stream().filter(option -> option.nbtByte().isPresent()).mapToInt(b -> 1).sum());
            results.put("Bytes", options.stream().filter(option -> !option.nbtBytes().isEmpty()).mapToInt(b -> 1).sum());
            results.put("Short", options.stream().filter(option -> option.nbtShort().isPresent()).mapToInt(s -> 1).sum());
            results.put("Shorts", options.stream().filter(option -> !option.nbtShorts().isEmpty()).mapToInt(s -> 1).sum());
            results.put("Int", options.stream().filter(option -> option.nbtInt().isPresent()).mapToInt(i -> 1).sum());
            results.put("Ints", options.stream().filter(option -> !option.nbtInts().isEmpty()).mapToInt(i -> 1).sum());
            results.put("String", options.stream().filter(option -> option.nbtString().isPresent()).mapToInt(s -> 1).sum());
            results.put("Strings", options.stream().filter(option -> !option.nbtStrings().isEmpty()).mapToInt(s -> 1).sum());
            results.put("Model Data", options.stream().filter(option -> option.customModelData().isPresent()).mapToInt(c -> 1).sum());
            return results;
        }));
    }
}

