/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.DumpCommand;
import com.extendedclip.deluxemenus.command.subcommand.ExecuteCommand;
import com.extendedclip.deluxemenus.command.subcommand.HelpCommand;
import com.extendedclip.deluxemenus.command.subcommand.ListCommand;
import com.extendedclip.deluxemenus.command.subcommand.MetaCommand;
import com.extendedclip.deluxemenus.command.subcommand.OpenCommand;
import com.extendedclip.deluxemenus.command.subcommand.ReloadCommand;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.NamedTextColor;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.TextColor;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;

public class DeluxeMenusCommand
implements TabExecutor {
    private static final TextReplacementConfig.Builder VERSION_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<version>");
    private static final TextReplacementConfig.Builder AUTHORS_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<authors>");
    private final DeluxeMenus plugin;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public DeluxeMenusCommand(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    public boolean register() {
        PluginCommand command = this.plugin.getCommand("deluxemenus");
        if (command == null) {
            return false;
        }
        command.setExecutor((CommandExecutor)this);
        this.registerSubCommands();
        return true;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List<String> arguments = Arrays.asList(args);
        if (arguments.isEmpty()) {
            this.plugin.sms(sender, Messages.PLUGIN_VERSION.message().replaceText((TextReplacementConfig)VERSION_REPLACER_BUILDER.replacement(this.plugin.getDescription().getVersion()).build()).replaceText((TextReplacementConfig)AUTHORS_REPLACER_BUILDER.replacement(this.plugin.getDescription().getAuthors().stream().map(author -> Component.text(author, (TextColor)NamedTextColor.WHITE)).collect(Component.toComponent(Component.text(", ", (TextColor)NamedTextColor.GRAY)))).build()));
            return true;
        }
        SubCommand subCommand = this.subCommands.get(arguments.get(0).toLowerCase());
        if (subCommand != null) {
            subCommand.execute(sender, arguments.subList(1, arguments.size()));
            return true;
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE);
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List<String> arguments = Arrays.asList(args);
        return this.subCommands.values().stream().map(sc -> sc.onTabComplete(sender, arguments)).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void registerSubCommands() {
        List<ReloadCommand> commands = List.of(new DumpCommand(this.plugin), new ExecuteCommand(this.plugin), new HelpCommand(this.plugin), new ListCommand(this.plugin), new MetaCommand(this.plugin), new OpenCommand(this.plugin), new ReloadCommand(this.plugin));
        for (SubCommand subCommand : commands) {
            this.subCommands.put(subCommand.getName(), subCommand);
        }
    }
}

