/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextComponent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.event.ClickEvent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.event.HoverEvent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.NamedTextColor;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.TextColor;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.utils.Messages;
import com.extendedclip.deluxemenus.utils.PaginationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListCommand
extends SubCommand {
    private static final String LIST_PERMISSION = "deluxemenus.list";

    public ListCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "list";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        TreeMap<String, List<Menu>> menus;
        if (!sender.hasPermission(LIST_PERMISSION)) {
            this.plugin.sms(sender, Messages.NO_PERMISSION);
            return;
        }
        if (!arguments.isEmpty() && arguments.get(0).equalsIgnoreCase("all")) {
            Collection<Menu> menus2 = Menu.getAllMenus();
            if (menus2.isEmpty()) {
                this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement("There are no").build()));
                return;
            }
            this.sendSimpleMenuList(sender, Menu.getAllMenus());
            return;
        }
        if (Menu.getAllMenuNames().isEmpty()) {
            this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement("There are no").build()));
            return;
        }
        List configMenus = (List)(menus = Menu.getPathSortedMenus()).remove("config");
        this.sendPaginatedMenuList(sender, menus, configMenus == null ? Collections.emptyList() : configMenus, arguments);
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(LIST_PERMISSION)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return List.of(this.getName());
        }
        if (arguments.size() > 2) {
            return null;
        }
        if (arguments.size() == 1) {
            if (arguments.get(0).isEmpty()) {
                return List.of(this.getName());
            }
            String firstArgument = arguments.get(0).toLowerCase();
            if (this.getName().startsWith(firstArgument)) {
                return List.of(this.getName());
            }
            return null;
        }
        String firstArgument = arguments.get(0).toLowerCase();
        if (!this.getName().equals(firstArgument)) {
            return null;
        }
        String secondArgument = arguments.get(1).toLowerCase();
        int menusCount = Menu.getAllMenuNames().size();
        int menusPerPage = this.plugin.getGeneralConfig().menusListPageSize();
        int pagesCount = (int)Math.ceil((double)menusCount / (double)menusPerPage);
        List<String> completions = Stream.concat(Stream.of("all"), IntStream.rangeClosed(1, pagesCount).mapToObj(String::valueOf)).collect(Collectors.toList());
        if (secondArgument.isEmpty()) {
            return completions;
        }
        return completions.stream().filter(completion -> completion.startsWith(secondArgument)).collect(Collectors.toList());
    }

    private void sendSimpleMenuList(@NotNull CommandSender sender, @NotNull Collection<Menu> menus) {
        TextComponent.Builder list = Component.text();
        list.append(Component.text("The following " + menus.size() + " menus are loaded on the server:", (TextColor)NamedTextColor.GOLD).append(Component.newline()));
        if (sender instanceof ConsoleCommandSender) {
            list.append((Component)Component.newline());
            Component menusList = menus.stream().map(menu -> {
                String menuCommand = this.getMenuDisplayCommand((Menu)menu);
                return menuCommand == null ? (TextComponent)((TextComponent)Component.text(menu.options().name(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text("No menu command", (TextColor)NamedTextColor.RED)) : (TextComponent)((TextComponent)Component.text(menu.options().name(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(menuCommand, (TextColor)NamedTextColor.GREEN));
            }).collect(Component.toComponent(Component.text(" | ", (TextColor)NamedTextColor.WHITE)));
            this.plugin.sms(sender, (Component)((TextComponent.Builder)list.append(menusList)).build());
            return;
        }
        ((TextComponent.Builder)((TextComponent.Builder)list.append((Component)Component.text("**Hover menu name for more info**", (TextColor)NamedTextColor.GRAY))).append((Component)Component.newline())).append((Component)Component.newline());
        Component menusList = menus.stream().map(menu -> {
            String menuCommand = this.getMenuDisplayCommand((Menu)menu);
            return menuCommand == null ? (TextComponent)Component.text(menu.options().name(), (TextColor)NamedTextColor.DARK_AQUA).hoverEvent(HoverEvent.showText(Component.text("No open command", (TextColor)NamedTextColor.GOLD))) : (TextComponent)((TextComponent)Component.text(menu.options().name(), (TextColor)NamedTextColor.DARK_AQUA).hoverEvent(HoverEvent.showText(Component.text("Open Command: ", (TextColor)NamedTextColor.GOLD).append(Component.text(menuCommand, (TextColor)NamedTextColor.YELLOW))))).clickEvent(ClickEvent.suggestCommand(menuCommand));
        }).collect(Component.toComponent(Component.text(", ", (TextColor)NamedTextColor.WHITE)));
        list.append(menusList);
        this.plugin.sms(sender, (Component)list.build());
    }

    private void sendPaginatedMenuList(@NotNull CommandSender sender, @NotNull Map<String, List<Menu>> menus, @NotNull List<Menu> configMenus, @NotNull List<String> args) {
        int menusPerPage = this.plugin.getGeneralConfig().menusListPageSize();
        int totalMenusCount = configMenus.size() + menus.values().stream().mapToInt(List::size).sum();
        int pagesCount = PaginationUtils.getPagesCount(menusPerPage, totalMenusCount);
        int page = PaginationUtils.parsePage(menusPerPage, totalMenusCount, pagesCount, args.isEmpty() ? null : args.get(0));
        Map<String, List<Menu>> paginatedMenus = this.getPaginatedMenus(menus, configMenus.stream().collect(TreeMap::new, (map, menu) -> map.put(menu.options().name(), menu), TreeMap::putAll), page, menusPerPage);
        int pageMenusCount = paginatedMenus.values().stream().mapToInt(List::size).sum();
        Map<String, Object> pageMenusTree = this.convertMenusToTree(paginatedMenus);
        TextComponent.Builder list = Component.text();
        list.append(Component.text("Page " + page + "/" + pagesCount + " - " + pageMenusCount + " menus:", (TextColor)NamedTextColor.GOLD).append(Component.newline()));
        if (sender instanceof ConsoleCommandSender) {
            Component menuList = this.createMenuListForConsole(pageMenusTree, 0);
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)list.append((Component)Component.newline())).append(menuList)).append((Component)Component.newline())).append((Component)Component.text("Use /dm list <page> to view more menus", (TextColor)NamedTextColor.GRAY));
            this.plugin.sms(sender, (Component)list.build());
            return;
        }
        list.append((Component)Component.text("**Hover menu name for more info**", (TextColor)NamedTextColor.GRAY));
        ((TextComponent.Builder)list.append((Component)Component.newline())).append((Component)Component.newline());
        Component menuList = this.createMenuListForPlayer(pageMenusTree, 0);
        list.append(menuList);
        if (page > 1 || page < pagesCount) {
            list.append((Component)Component.newline());
            if (page > 1) {
                list.append(((TextComponent)Component.text("<< Previous", (TextColor)NamedTextColor.GOLD).hoverEvent(HoverEvent.showText(((TextComponent)((TextComponent)Component.text("Click to go to the previous page", (TextColor)NamedTextColor.GRAY).append(Component.newline())).append(Component.newline())).append(Component.text("Executes: /dm list " + (page - 1), (TextColor)NamedTextColor.GRAY))))).clickEvent(ClickEvent.runCommand("/dm list " + (page - 1))));
                if (page < pagesCount) {
                    list.append((Component)Component.text(" | ", (TextColor)NamedTextColor.GREEN));
                }
            }
            if (page < pagesCount) {
                list.append(((TextComponent)Component.text("Next >>", (TextColor)NamedTextColor.GOLD).hoverEvent(HoverEvent.showText(((TextComponent)((TextComponent)Component.text("Click to go to the next page", (TextColor)NamedTextColor.GRAY).append(Component.newline())).append(Component.newline())).append(Component.text("Executes: /dm list " + (page + 1), (TextColor)NamedTextColor.GRAY))))).clickEvent(ClickEvent.runCommand("/dm list " + (page + 1))));
            }
        }
        this.plugin.sms(sender, (Component)list.build());
    }

    private Map<String, List<Menu>> getPaginatedMenus(Map<String, List<Menu>> menus, @NotNull Map<String, Menu> configMenus, int page, int pageSize) {
        LinkedHashMap<String, List<Menu>> paginatedMenus = new LinkedHashMap<String, List<Menu>>();
        int start = (page - 1) * pageSize;
        int end = start + pageSize;
        int count = 0;
        int i = 0;
        for (Map.Entry<String, Menu> entry : configMenus.entrySet()) {
            if (count >= pageSize || i >= end) break;
            if (i < start) {
                ++i;
                continue;
            }
            paginatedMenus.computeIfAbsent("config", k -> new ArrayList()).add(entry.getValue());
            ++count;
            ++i;
        }
        block1: for (Map.Entry<String, Object> entry : menus.entrySet()) {
            if (count >= pageSize || i >= end) break;
            for (Menu menu : (List)entry.getValue()) {
                if (count >= pageSize || i >= end) continue block1;
                if (i < start) {
                    ++i;
                    continue;
                }
                paginatedMenus.computeIfAbsent(entry.getKey(), k -> new ArrayList()).add(menu);
                ++count;
                ++i;
            }
        }
        return paginatedMenus;
    }

    private Component createMenuListForConsole(Map<String, Object> tree, int tabs) {
        TextComponent.Builder list = Component.text();
        for (Map.Entry<String, Object> entry : tree.entrySet()) {
            if (entry.getValue() instanceof List) {
                for (Menu menu : (List)entry.getValue()) {
                    list.append(((TextComponent)((TextComponent)Component.text("  ".repeat(tabs) + "- " + entry.getKey(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(menu.options().name(), (TextColor)NamedTextColor.GREEN))).append(Component.newline()));
                }
                continue;
            }
            ((TextComponent.Builder)list.append((Component)Component.text("  ".repeat(tabs) + "|- " + entry.getKey(), (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.newline());
            list.append(this.createMenuListForConsole((Map)entry.getValue(), tabs + 1));
        }
        return list.build();
    }

    private Component createMenuListForPlayer(Map<String, Object> tree, int tabs) {
        TextComponent.Builder list = Component.text();
        for (Map.Entry<String, Object> entry : tree.entrySet()) {
            if (!(entry.getValue() instanceof List)) {
                ((TextComponent.Builder)list.append((Component)Component.text("  ".repeat(tabs) + "|-" + entry.getKey(), (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.newline());
                list.append(this.createMenuListForPlayer((Map)entry.getValue(), tabs + 1));
                continue;
            }
            for (Menu menu : (List)entry.getValue()) {
                String menuCommand = this.getMenuDisplayCommand(menu);
                ((TextComponent.Builder)list.append(((TextComponent)((TextComponent)((TextComponent)Component.text("  ".repeat(tabs) + "- " + entry.getKey(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(menu.options().name(), (TextColor)NamedTextColor.GREEN))).hoverEvent(HoverEvent.showText(menuCommand != null ? Component.text("Open Command: ", (TextColor)NamedTextColor.GOLD).append(Component.text(menuCommand, (TextColor)NamedTextColor.YELLOW)) : Component.text("No open command", (TextColor)NamedTextColor.GOLD)))).clickEvent(ClickEvent.suggestCommand(menuCommand != null ? menuCommand : "No open command")))).append((Component)Component.newline());
            }
        }
        return list.build();
    }

    private Map<String, Object> convertMenusToTree(Map<String, List<Menu>> menus) {
        LinkedHashMap<String, Object> tree = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, List<Menu>> entry : menus.entrySet()) {
            String[] path = entry.getKey().split("/");
            this.addMenuToTreeRecursively(tree, List.of(path), entry.getValue(), 0);
        }
        return tree;
    }

    private void addMenuToTreeRecursively(Map<String, Object> tree, List<String> path, List<Menu> menus, int step) {
        if (step < 0 || step >= path.size()) {
            return;
        }
        if (step == path.size() - 1) {
            if (!tree.containsKey(path.get(step))) {
                tree.put(path.get(step), new ArrayList<Menu>(menus));
            } else {
                List list = (List)tree.get(path.get(step));
                list.addAll(menus);
            }
            return;
        }
        String value = path.get(step);
        if (!tree.containsKey(value)) {
            tree.put(value, new TreeMap());
        }
        this.addMenuToTreeRecursively((Map)tree.get(value), path, menus, step + 1);
    }

    @Nullable
    public String getMenuDisplayCommand(@NotNull Menu menu) {
        boolean useAdminCommand = this.plugin.getGeneralConfig().useAdminCommandsInMenusList();
        if (useAdminCommand) {
            return "/deluxemenus open " + menu.options().name();
        }
        if (menu.options().commands().isEmpty()) {
            return null;
        }
        return "/" + menu.options().commands().get(0);
    }
}

