/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenCommand
extends SubCommand {
    private static final String OPEN_COMMAND = "deluxemenus.open";

    public OpenCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "open";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        Optional<Menu> menu;
        Player viewer;
        if (!sender.hasPermission(OPEN_COMMAND)) {
            this.plugin.sms(sender, Messages.NO_PERMISSION);
            return;
        }
        boolean player = sender instanceof Player;
        if (arguments.isEmpty()) {
            this.plugin.sms(sender, Messages.WRONG_USAGE_OPEN_COMMAND);
            return;
        }
        if (Menu.getAllMenus().isEmpty()) {
            this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement("There are no").build()));
            return;
        }
        String placeholderPlayer = null;
        if (arguments.size() == 2 && arguments.get(1).startsWith("-p:")) {
            if (!sender.hasPermission("deluxemenus.placeholdersfor")) {
                this.plugin.sms(sender, Messages.NO_PERMISSION_PLAYER_ARGUMENT);
                return;
            }
            placeholderPlayer = arguments.get(1).replace("-p:", "");
        } else if (arguments.size() >= 3 && arguments.get(2).startsWith("-p:")) {
            if (!sender.hasPermission("deluxemenus.placeholdersfor")) {
                this.plugin.sms(sender, Messages.NO_PERMISSION_PLAYER_ARGUMENT);
                return;
            }
            placeholderPlayer = arguments.get(2).replace("-p:", "");
        }
        if (arguments.size() >= 2) {
            if (placeholderPlayer == null) {
                if (player && !sender.hasPermission("deluxemenus.open.others")) {
                    this.plugin.sms(sender, Messages.NO_PERMISSION);
                    return;
                }
                viewer = Bukkit.getPlayerExact((String)arguments.get(1));
            } else if (arguments.size() >= 3) {
                if (!sender.hasPermission("deluxemenus.open.others")) {
                    this.plugin.sms(sender, Messages.NO_PERMISSION);
                    return;
                }
                viewer = Bukkit.getPlayerExact((String)arguments.get(1));
            } else {
                if (!player) {
                    this.plugin.sms(sender, Messages.MUST_SPECIFY_PLAYER);
                    return;
                }
                viewer = (Player)sender;
            }
        } else {
            if (!player) {
                this.plugin.sms(sender, Messages.MUST_SPECIFY_PLAYER);
                return;
            }
            viewer = (Player)sender;
        }
        if (viewer == null) {
            this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(arguments.get(1)).build()));
            return;
        }
        Player placeholder = null;
        if (placeholderPlayer != null) {
            placeholder = Bukkit.getPlayerExact((String)placeholderPlayer);
            if (placeholder == null) {
                this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(placeholderPlayer).build()));
                return;
            }
            if (placeholder.hasPermission("deluxemenus.placeholdersfor.exempt")) {
                this.plugin.sms(sender, Messages.PLAYER_IS_EXEMPT.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(placeholderPlayer).build()));
                return;
            }
        }
        if ((menu = Menu.getMenuByName(arguments.get(0))).isEmpty()) {
            this.plugin.sms(sender, Messages.INVALID_MENU.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(arguments.get(0)).build()));
            return;
        }
        menu.get().openMenu(viewer, null, placeholder);
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(OPEN_COMMAND)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return List.of(this.getName());
        }
        if (arguments.size() > 4) {
            return null;
        }
        if (arguments.size() == 1) {
            if (arguments.get(0).isEmpty()) {
                return List.of(this.getName());
            }
            String firstArgument = arguments.get(0).toLowerCase();
            if (this.getName().startsWith(firstArgument)) {
                return List.of(this.getName());
            }
            return null;
        }
        String firstArgument = arguments.get(0).toLowerCase();
        if (!this.getName().equals(firstArgument)) {
            return null;
        }
        Set<String> menuNames = Menu.getAllMenuNames();
        if (menuNames.isEmpty()) {
            return null;
        }
        if (arguments.size() == 2) {
            String secondArgument = arguments.get(1).toLowerCase();
            if (secondArgument.isEmpty()) {
                return List.copyOf(menuNames);
            }
            return menuNames.stream().filter(menuName -> menuName.toLowerCase().startsWith(secondArgument)).collect(Collectors.toList());
        }
        List<String> onlinePlayerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        if (arguments.size() == 3) {
            String thirdArgument = arguments.get(2).toLowerCase();
            if (thirdArgument.isEmpty()) {
                return Stream.concat(onlinePlayerNames.stream(), Stream.of("-p:")).collect(Collectors.toList());
            }
            if (!thirdArgument.startsWith("-")) {
                return onlinePlayerNames.stream().filter(playerName -> playerName.toLowerCase().startsWith(thirdArgument)).collect(Collectors.toList());
            }
            return onlinePlayerNames.stream().map(playerName -> "-p:" + playerName).filter(playerName -> playerName.toLowerCase().startsWith(thirdArgument)).collect(Collectors.toList());
        }
        if (arguments.size() == 4) {
            String thirdArgument = arguments.get(2).toLowerCase();
            String fourthArgument = arguments.get(3).toLowerCase();
            if (!thirdArgument.startsWith("-p:")) {
                return null;
            }
            if (fourthArgument.isEmpty()) {
                return onlinePlayerNames;
            }
            return onlinePlayerNames.stream().filter(playerName -> playerName.toLowerCase().startsWith(fourthArgument)).collect(Collectors.toList());
        }
        return null;
    }
}

