/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.config;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import org.jetbrains.annotations.NotNull;

public class GeneralConfig {
    private final DeluxeMenus plugin;
    private boolean checkForUpdates = true;
    private DebugLevel debugLevel = this.getDefaultDebugLevel();
    private boolean useAdminCommandsInMenusList = false;
    private int menusListPageSize = 10;
    private int metasListPageSize = 15;

    public GeneralConfig(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.plugin.getConfig().addDefault("check_updates", (Object)this.checkForUpdates);
        this.plugin.getConfig().addDefault("debug", (Object)this.debugLevel.name());
        this.plugin.getConfig().addDefault("use_admin_commands_in_menus_list", (Object)false);
        this.plugin.getConfig().addDefault("menus_list_page_size", (Object)this.menusListPageSize);
        this.plugin.getConfig().addDefault("metas_list_page_size", (Object)this.metasListPageSize);
        this.checkForUpdates = this.plugin.getConfig().getBoolean("check_updates", false);
        this.debugLevel = this.loadDebugLevel();
        this.useAdminCommandsInMenusList = this.plugin.getConfig().getBoolean("use_admin_commands_in_menus_list", false);
        this.menusListPageSize = this.plugin.getConfig().getInt("menus_list_page_size", 10);
        this.metasListPageSize = this.plugin.getConfig().getInt("metas_list_page_size", 15);
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.load();
    }

    public boolean checkForUpdates() {
        return this.checkForUpdates;
    }

    public DebugLevel debugLevel() {
        return this.debugLevel;
    }

    public boolean useAdminCommandsInMenusList() {
        return this.useAdminCommandsInMenusList;
    }

    public int menusListPageSize() {
        return this.menusListPageSize;
    }

    public int metasListPageSize() {
        return this.metasListPageSize;
    }

    @NotNull
    private DebugLevel loadDebugLevel() {
        DebugLevel debugLevel;
        String configDebugLevel = this.plugin.getConfig().getString("debug", "HIGHEST");
        if (configDebugLevel.equalsIgnoreCase("true")) {
            configDebugLevel = "LOWEST";
            this.plugin.getConfig().set("debug", (Object)"LOWEST");
        }
        if (configDebugLevel.equalsIgnoreCase("false")) {
            configDebugLevel = "HIGHEST";
            this.plugin.getConfig().set("debug", (Object)"HIGHEST");
        }
        return (debugLevel = DebugLevel.getByName(configDebugLevel)) == null ? this.getDefaultDebugLevel() : debugLevel;
    }

    private DebugLevel getDefaultDebugLevel() {
        return DebugLevel.LOW;
    }
}

