/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.dupe;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.dupe.marker.ItemMarker;
import com.extendedclip.deluxemenus.dupe.marker.impl.NMSMenuItemMarker;
import com.extendedclip.deluxemenus.dupe.marker.impl.PDCMenuItemMarker;
import com.extendedclip.deluxemenus.dupe.marker.impl.UnavailableMenuItemMarker;
import com.extendedclip.deluxemenus.nbt.NbtProvider;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.regex.Pattern;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MenuItemMarker
implements ItemMarker {
    private static final String DEFAULT_MARK = "DM";
    private static final Pattern MARK_PATTERN = Pattern.compile("^[a-zA-Z0-9]+$");
    private static final boolean SUPPORTS_PDC = VersionHelper.IS_PDC_VERSION;
    private static final boolean SUPPORTS_NMS = NbtProvider.isAvailable();
    private final ItemMarker marker;
    private final String mark;

    public MenuItemMarker(@NotNull DeluxeMenus plugin) {
        this(plugin, DEFAULT_MARK);
    }

    public MenuItemMarker(@NotNull DeluxeMenus plugin, @NotNull String mark) {
        String string = this.mark = DEFAULT_MARK.equals(mark) || MARK_PATTERN.matcher(mark).matches() ? mark : DEFAULT_MARK;
        this.marker = SUPPORTS_PDC ? new PDCMenuItemMarker(plugin, this.mark) : (SUPPORTS_NMS ? new NMSMenuItemMarker(this.mark) : new UnavailableMenuItemMarker());
    }

    @Override
    @NotNull
    public ItemStack mark(@NotNull ItemStack itemStack) {
        return this.marker.mark(itemStack);
    }

    @Override
    @NotNull
    public ItemStack unmark(@NotNull ItemStack itemStack) {
        return this.marker.unmark(itemStack);
    }

    @Override
    public boolean isMarked(@NotNull ItemStack itemStack) {
        return this.marker.isMarked(itemStack);
    }

    @NotNull
    public String getMark() {
        return this.mark;
    }
}

