/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.hooks;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HeadDatabaseHook
implements ItemHook {
    private final DeluxeMenus plugin;
    private final HeadDatabaseAPI api;

    public HeadDatabaseHook(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
        this.api = new HeadDatabaseAPI();
    }

    @Override
    public ItemStack getItem(String ... arguments) {
        if (arguments.length == 0) {
            return this.plugin.getHead().clone();
        }
        try {
            ItemStack item = this.api.getItemHead(arguments[0]);
            return item != null ? item : this.plugin.getHead().clone();
        }
        catch (NullPointerException exception) {
            this.plugin.printStacktrace("Something went wrong while trying to get head database head: " + arguments[0], exception);
            return this.plugin.getHead().clone();
        }
    }

    @Override
    public boolean itemMatchesIdentifiers(@NotNull ItemStack item, String ... arguments) {
        if (arguments.length == 0) {
            return false;
        }
        return arguments[0].equalsIgnoreCase(this.api.getItemID(item));
    }

    @Override
    public String getPrefix() {
        return "hdb-";
    }
}

