/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.hooks;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.cache.SimpleCache;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MMOItemsHook
implements ItemHook,
SimpleCache {
    private final Map<String, ItemStack> cache = new ConcurrentHashMap<String, ItemStack>();
    private final DeluxeMenus plugin;

    public MMOItemsHook(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    @Override
    public ItemStack getItem(String ... arguments) {
        if (arguments.length == 0) {
            return new ItemStack(Material.STONE, 1);
        }
        ItemStack cached = this.cache.get(arguments[0]);
        if (cached != null) {
            return cached.clone();
        }
        String[] splitArgs = arguments[0].split(":", 2);
        if (splitArgs.length != 2) {
            return new ItemStack(Material.STONE, 1);
        }
        Type itemType = MMOItems.plugin.getTypes().get(splitArgs[0]);
        if (itemType == null) {
            return new ItemStack(Material.STONE, 1);
        }
        ItemStack mmoItem = null;
        try {
            mmoItem = (ItemStack)Bukkit.getScheduler().callSyncMethod((Plugin)this.plugin, () -> {
                ItemStack item = MMOItems.plugin.getItem(itemType, splitArgs[1]);
                if (item == null) {
                    return new ItemStack(Material.STONE, 1);
                }
                this.cache.put(arguments[0], item);
                return item;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Error getting MMOItem synchronously.");
        }
        return mmoItem == null ? new ItemStack(Material.STONE, 1) : mmoItem;
    }

    @Override
    public boolean itemMatchesIdentifiers(@NotNull ItemStack item, String ... arguments) {
        if (arguments.length == 0) {
            return false;
        }
        String[] splitArgs = arguments[0].split(":", 2);
        if (splitArgs.length != 2) {
            return false;
        }
        return splitArgs[0].equalsIgnoreCase(MMOItems.getTypeName((ItemStack)item)) && splitArgs[1].equalsIgnoreCase(MMOItems.getID((ItemStack)item));
    }

    @Override
    public String getPrefix() {
        return "mmoitems-";
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

