/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.listener;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.listener.Listener;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerListener
extends Listener {
    private final Cache<UUID, Long> cache = CacheBuilder.newBuilder().expireAfterWrite(75L, TimeUnit.MILLISECONDS).build();
    private final Cache<UUID, Long> shiftCache = CacheBuilder.newBuilder().expireAfterWrite(200L, TimeUnit.MILLISECONDS).build();

    public PlayerListener(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCommandExecute(PlayerCommandPreprocessEvent event) {
        String cmd = event.getMessage().substring(1);
        Optional<Menu> optionalMenu = Menu.getMenuByCommand(cmd.toLowerCase());
        if (optionalMenu.isEmpty()) {
            return;
        }
        Menu menu = optionalMenu.get();
        if (menu.options().registerCommands()) {
            return;
        }
        Player player = event.getPlayer();
        menu.openMenu(player);
        event.setCancelled(true);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (Menu.isInMenu(player)) {
            Menu.closeMenu(this.plugin, player, false);
        }
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player.isSleeping()) {
            event.setCancelled(true);
        }
        if (Menu.isInMenu(player)) {
            Menu.closeMenu(this.plugin, player, true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (Menu.isInMenu(player)) {
            Menu.closeMenu(this.plugin, player, false);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Menu.cleanInventory(this.plugin, player);
                player.updateInventory();
            }, 3L);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Optional<MenuHolder> optionalHolder = Menu.getMenuHolder(player);
        if (optionalHolder.isEmpty()) {
            return;
        }
        MenuHolder holder = optionalHolder.get();
        if (holder.getMenu().isEmpty()) {
            Menu.closeMenu(this.plugin, player, true);
        }
        if (holder.isUpdating()) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        MenuItem item = holder.getItem(slot);
        if (item == null) {
            return;
        }
        if (this.cache.getIfPresent((Object)player.getUniqueId()) != null) {
            return;
        }
        if (this.shiftCache.getIfPresent((Object)player.getUniqueId()) != null) {
            return;
        }
        if (event.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (event.getClick() == ClickType.SHIFT_LEFT) {
            this.shiftCache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
        }
        if (this.handleClick(player, holder, item.options().clickHandler(), item.options().clickRequirements())) {
            return;
        }
        if (event.isShiftClick() && event.isLeftClick() && this.handleClick(player, holder, item.options().shiftLeftClickHandler(), item.options().shiftLeftClickRequirements())) {
            return;
        }
        if (event.isShiftClick() && event.isRightClick() && this.handleClick(player, holder, item.options().shiftRightClickHandler(), item.options().shiftRightClickRequirements())) {
            return;
        }
        if (event.getClick() == ClickType.LEFT && this.handleClick(player, holder, item.options().leftClickHandler(), item.options().leftClickRequirements())) {
            return;
        }
        if (event.getClick() == ClickType.RIGHT && this.handleClick(player, holder, item.options().rightClickHandler(), item.options().rightClickRequirements())) {
            return;
        }
        if (event.getClick() != ClickType.MIDDLE || this.handleClick(player, holder, item.options().middleClickHandler(), item.options().middleClickRequirements())) {
            // empty if block
        }
    }

    private boolean handleClick(@NotNull Player player, @NotNull MenuHolder holder, @NotNull Optional<ClickHandler> handler, @NotNull Optional<RequirementList> requirements) {
        if (handler.isEmpty()) {
            return false;
        }
        if (requirements.isPresent()) {
            ClickHandler denyHandler = requirements.get().getDenyHandler();
            if (!requirements.get().evaluate(holder)) {
                if (denyHandler == null) {
                    return true;
                }
                denyHandler.onClick(holder);
                return true;
            }
        }
        this.cache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
        handler.get().onClick(holder);
        return true;
    }
}

