/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.menu.command.RegistrableMenuCommand;
import com.extendedclip.deluxemenus.menu.options.MenuOptions;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Menu {
    private static final Map<String, Menu> menus = new HashMap<String, Menu>();
    private static final Set<MenuHolder> menuHolders = new HashSet<MenuHolder>();
    private static final Map<UUID, Menu> lastOpenedMenus = new HashMap<UUID, Menu>();
    private final DeluxeMenus plugin;
    private final MenuOptions options;
    private final Map<Integer, TreeMap<Integer, MenuItem>> items;
    private final String path;
    private RegistrableMenuCommand command = null;

    public Menu(@NotNull DeluxeMenus plugin, @NotNull MenuOptions options, @NotNull Map<Integer, TreeMap<Integer, MenuItem>> items, @NotNull String path) {
        this.plugin = plugin;
        this.options = options;
        this.items = items;
        this.path = path;
        if (this.options.registerCommands()) {
            this.command = new RegistrableMenuCommand(plugin, this);
            this.command.register();
        }
        menus.put(this.options.name(), this);
    }

    public static void unload(@NotNull DeluxeMenus plugin, @NotNull String name) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!Menu.isInMenu(p, name)) continue;
            Menu.closeMenu(plugin, p, true);
        }
        Optional<Menu> optionalMenu = Menu.getMenuByName(name);
        if (optionalMenu.isEmpty()) {
            return;
        }
        optionalMenu.get().unregisterCommand();
        menus.remove(name);
    }

    public static void unload(@NotNull DeluxeMenus plugin) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!Menu.isInMenu(p)) continue;
            Menu.closeMenu(plugin, p, true);
        }
        for (Menu menu : Menu.getAllMenus()) {
            menu.unregisterCommand();
        }
        menus.clear();
        menuHolders.clear();
        lastOpenedMenus.clear();
    }

    private void unregisterCommand() {
        if (this.command != null) {
            this.command.unregister();
        }
        this.command = null;
    }

    public static void unloadForShutdown(@NotNull DeluxeMenus plugin) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!Menu.isInMenu(player)) continue;
            Menu.closeMenuForShutdown(plugin, player);
        }
        menus.clear();
    }

    public static int getLoadedMenuSize() {
        return menus.size();
    }

    @NotNull
    public static Set<String> getAllMenuNames() {
        return menus.keySet();
    }

    @NotNull
    public static Collection<Menu> getAllMenus() {
        return menus.values();
    }

    @NotNull
    public static TreeMap<String, List<Menu>> getPathSortedMenus() {
        return menus.values().stream().map(m -> Map.entry(m.path(), m)).collect(TreeMap::new, (tree, entry) -> {
            List list = tree.computeIfAbsent((String)entry.getKey(), k -> new ArrayList());
            list.add((Menu)entry.getValue());
            tree.put((String)entry.getKey(), list);
        }, (tree1, tree2) -> {
            for (Map.Entry entry : tree2.entrySet()) {
                List list = tree1.computeIfAbsent((String)entry.getKey(), k -> new ArrayList());
                list.addAll((Collection)entry.getValue());
                tree1.put((String)entry.getKey(), list);
            }
        });
    }

    @NotNull
    public static Optional<Menu> getMenuByName(@NotNull String name) {
        return menus.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(name)).findFirst().map(Map.Entry::getValue);
    }

    @NotNull
    public static Optional<Menu> getMenuByCommand(@NotNull String command) {
        return menus.values().stream().filter(m -> m.getMenuCommandUsed(command).isPresent()).findFirst();
    }

    public static boolean isMenuCommand(@NotNull String command) {
        return Menu.getMenuByCommand(command).isPresent();
    }

    public static boolean isInMenu(@NotNull Player player) {
        return menuHolders.stream().anyMatch(h -> h.getViewerName().equals(player.getName()));
    }

    public static boolean isInMenu(@NotNull Player player, @NotNull String menu) {
        return menuHolders.stream().anyMatch(h -> h.getMenuName().equals(menu) && h.getViewerName().equals(player.getName()));
    }

    public static Optional<MenuHolder> getMenuHolder(@NotNull Player player) {
        return menuHolders.stream().filter(h -> h.getViewerName().equals(player.getName())).findFirst();
    }

    public static Optional<Menu> getOpenMenu(@NotNull Player player) {
        return Menu.getMenuHolder(player).flatMap(MenuHolder::getMenu);
    }

    public static Optional<Menu> getLastMenu(@NotNull Player player) {
        return Optional.ofNullable(lastOpenedMenus.get(player.getUniqueId()));
    }

    public static void cleanInventory(@NotNull DeluxeMenus plugin, @NotNull Player player) {
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (itemStack == null || !plugin.getMenuItemMarker().isMarked(itemStack)) continue;
            plugin.debug(DebugLevel.LOWEST, Level.INFO, "Found a DeluxeMenus item in a player's inventory. Removing it.");
            player.getInventory().remove(itemStack);
        }
        player.updateInventory();
    }

    public static void closeMenu(@NotNull DeluxeMenus plugin, @NotNull Player player, boolean close, boolean executeCloseActions) {
        Optional<MenuHolder> optionalHolder = Menu.getMenuHolder(player);
        if (optionalHolder.isEmpty()) {
            return;
        }
        MenuHolder holder = optionalHolder.get();
        holder.stopPlaceholderUpdate();
        if (executeCloseActions) {
            holder.getMenu().map(Menu::options).map(MenuOptions::closeHandler).flatMap(h -> h).ifPresent(h -> h.onClick(holder));
        }
        if (close) {
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                player.closeInventory();
                Menu.cleanInventory(plugin, player);
            });
        }
        menuHolders.remove(holder);
        lastOpenedMenus.put(player.getUniqueId(), holder.getMenu().orElse(null));
    }

    public static void closeMenuForShutdown(@NotNull DeluxeMenus plugin, @NotNull Player player) {
        Menu.getMenuHolder(player).ifPresent(MenuHolder::stopPlaceholderUpdate);
        player.closeInventory();
        Menu.cleanInventory(plugin, player);
    }

    public static void closeMenu(@NotNull DeluxeMenus plugin, @NotNull Player player, boolean close) {
        Menu.closeMenu(plugin, player, close, false);
    }

    private boolean hasOpenBypassPerm(@NotNull Player viewer) {
        return viewer.hasPermission("deluxemenus.openrequirement.bypass." + this.options.name()) || viewer.hasPermission("deluxemenus.openrequirement.bypass.*");
    }

    private boolean handleOpenRequirements(@NotNull MenuHolder holder) {
        if (this.options.openRequirements().isEmpty()) {
            return true;
        }
        RequirementList openRequirements = this.options.openRequirements().get();
        if (openRequirements.getRequirements() == null) {
            return true;
        }
        if (holder.getViewer() != null && this.hasOpenBypassPerm(holder.getViewer())) {
            return true;
        }
        if (!openRequirements.evaluate(holder)) {
            if (openRequirements.getDenyHandler() != null) {
                openRequirements.getDenyHandler().onClick(holder);
            }
            return false;
        }
        return true;
    }

    private boolean handleArgRequirements(@NotNull MenuHolder holder) {
        for (RequirementList rl : this.options.argumentRequirements()) {
            if (rl.getRequirements() == null || rl.evaluate(holder)) continue;
            if (rl.getDenyHandler() != null) {
                rl.getDenyHandler().onClick(holder);
            }
            return false;
        }
        return true;
    }

    public void openMenu(@NotNull Player viewer) {
        this.openMenu(viewer, null, null);
    }

    public void openMenu(@NotNull Player viewer, @Nullable Map<String, String> args, @Nullable Player placeholderPlayer) {
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        MenuHolder holder = new MenuHolder(this.plugin, viewer);
        if (placeholderPlayer != null) {
            holder.setPlaceholderPlayer(placeholderPlayer);
        }
        holder.setTypedArgs(args);
        holder.parsePlaceholdersInArguments(this.options.parsePlaceholdersInArguments());
        holder.parsePlaceholdersAfterArguments(this.options.parsePlaceholdersAfterArguments());
        if (!this.handleArgRequirements(holder)) {
            return;
        }
        if (!this.handleOpenRequirements(holder)) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HashSet<MenuItem> activeItems = new HashSet<MenuItem>();
            block0: for (Map.Entry<Integer, TreeMap<Integer, MenuItem>> entry : this.items.entrySet()) {
                for (MenuItem menuItem : entry.getValue().values()) {
                    int slot = menuItem.options().slot();
                    if (slot >= this.options.size()) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Item set to slot " + slot + " for menu: " + this.options.name() + " exceeds the inventory size!", "This item will not be added to the menu!");
                        continue;
                    }
                    if (menuItem.options().viewRequirements().isPresent()) {
                        if (!menuItem.options().viewRequirements().get().evaluate(holder)) continue;
                        activeItems.add(menuItem);
                        continue block0;
                    }
                    activeItems.add(menuItem);
                    continue block0;
                }
            }
            if (activeItems.isEmpty()) {
                return;
            }
            holder.setMenuName(this.options.name());
            holder.setActiveItems(activeItems);
            this.options.openHandler().ifPresent(h -> h.onClick(holder));
            String title = StringUtils.color(holder.setPlaceholdersAndArguments(this.options.title()));
            Inventory inventory = this.options.type() != InventoryType.CHEST ? Bukkit.createInventory((InventoryHolder)holder, (InventoryType)this.options.type(), (String)title) : Bukkit.createInventory((InventoryHolder)holder, (int)this.options.size(), (String)title);
            holder.setInventory(inventory);
            boolean update = false;
            for (MenuItem item : activeItems) {
                ItemStack iStack = item.getItemStack(holder);
                if (iStack == null) continue;
                iStack = this.plugin.getMenuItemMarker().mark(iStack);
                int slot = item.options().slot();
                if (slot >= this.options.size()) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Item set to slot " + slot + " for menu: " + this.options.name() + " exceeds the inventory size!", "This item will not be added to the menu!");
                    continue;
                }
                if (item.options().updatePlaceholders()) {
                    update = true;
                }
                inventory.setItem(item.options().slot(), iStack);
            }
            boolean bl = update;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (Menu.isInMenu(holder.getViewer())) {
                    Menu.closeMenu(this.plugin, holder.getViewer(), false);
                }
                viewer.openInventory(inventory);
                menuHolders.add(holder);
                if (updatePlaceholders) {
                    holder.startUpdatePlaceholdersTask();
                }
            });
        });
    }

    @NotNull
    public Map<Integer, TreeMap<Integer, MenuItem>> getMenuItems() {
        return this.items;
    }

    @NotNull
    public Optional<String> getMenuCommandUsed(@NotNull String command) {
        return this.options.commands().stream().filter(c -> c.equalsIgnoreCase(command)).findFirst();
    }

    @NotNull
    public MenuOptions options() {
        return this.options;
    }

    @NotNull
    public String path() {
        return this.path;
    }
}

