/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.options.CustomModelDataComponent;
import com.extendedclip.deluxemenus.menu.options.HeadType;
import com.extendedclip.deluxemenus.menu.options.LoreAppendMode;
import com.extendedclip.deluxemenus.menu.options.MenuItemOptions;
import com.extendedclip.deluxemenus.nbt.NbtProvider;
import com.extendedclip.deluxemenus.utils.Constants;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.ItemUtils;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Light;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuItem {
    private final DeluxeMenus plugin;
    private final MenuItemOptions options;

    public MenuItem(@NotNull DeluxeMenus plugin, @NotNull MenuItemOptions options) {
        this.plugin = plugin;
        this.options = options;
    }

    public ItemStack getItemStack(@NotNull MenuHolder holder) {
        Object blockDataMeta;
        BlockData blockData;
        Object color;
        BlockStateMeta blockStateMeta;
        BannerMeta meta;
        Player viewer = holder.getViewer();
        ItemStack itemStack = null;
        int amount = 1;
        String stringMaterial = this.options.material();
        String lowercaseStringMaterial = stringMaterial.toLowerCase(Locale.ROOT);
        if (ItemUtils.isPlaceholderOption(lowercaseStringMaterial)) {
            stringMaterial = holder.setPlaceholdersAndArguments(stringMaterial.substring("placeholder-".length()));
            lowercaseStringMaterial = stringMaterial.toLowerCase(Locale.ENGLISH);
        }
        if (ItemUtils.isPlayerItem(lowercaseStringMaterial)) {
            ItemStack playerItem = Constants.INVENTORY_ITEM_ACCESSORS.get(lowercaseStringMaterial).apply(viewer.getInventory());
            if (playerItem == null || playerItem.getType() == Material.AIR) {
                return new ItemStack(Material.AIR);
            }
            itemStack = playerItem.clone();
            amount = playerItem.getAmount();
        }
        int temporaryAmount = amount;
        String finalMaterial = lowercaseStringMaterial;
        ItemHook pluginHook = this.plugin.getItemHooks().values().stream().filter(x -> finalMaterial.startsWith(x.getPrefix())).findFirst().orElse(null);
        if (pluginHook != null) {
            itemStack = pluginHook.getItem(viewer, holder.setPlaceholdersAndArguments(stringMaterial.substring(pluginHook.getPrefix().length())));
        }
        if (ItemUtils.isWaterBottle(stringMaterial)) {
            itemStack = ItemUtils.createWaterBottles(amount);
        }
        if (itemStack == null) {
            Material material = Material.getMaterial((String)stringMaterial.toUpperCase(Locale.ROOT));
            if (material == null) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Material: " + stringMaterial + " is not valid! Setting to Stone.");
                itemStack = new ItemStack(Material.STONE, temporaryAmount);
            } else {
                itemStack = new ItemStack(material, temporaryAmount);
            }
        }
        if (ItemUtils.isBanner(itemStack.getType()) && (meta = (BannerMeta)itemStack.getItemMeta()) != null) {
            if (!this.options.bannerMeta().isEmpty()) {
                meta.setPatterns(this.options.bannerMeta());
            }
            itemStack.setItemMeta((ItemMeta)meta);
        }
        if (ItemUtils.isShield(itemStack.getType()) && (blockStateMeta = (BlockStateMeta)itemStack.getItemMeta()) != null) {
            Banner banner = (Banner)blockStateMeta.getBlockState();
            if (this.options.baseColor().isPresent()) {
                banner.setBaseColor(this.options.baseColor().get());
                banner.update();
                blockStateMeta.setBlockState((BlockState)banner);
            }
            if (!this.options.bannerMeta().isEmpty()) {
                banner.setPatterns(this.options.bannerMeta());
                banner.update();
                blockStateMeta.setBlockState((BlockState)banner);
            }
            itemStack.setItemMeta((ItemMeta)blockStateMeta);
        }
        if (ItemUtils.hasPotionMeta(itemStack) && (meta = (PotionMeta)itemStack.getItemMeta()) != null) {
            Object color2;
            if (this.options.rgb().isPresent() && (color2 = this.parseRGBColor(holder.setPlaceholdersAndArguments(this.options.rgb().get()))) != null) {
                meta.setColor((Color)color2);
            }
            if (!this.options.potionEffects().isEmpty()) {
                for (PotionEffect effect : this.options.potionEffects()) {
                    meta.addCustomEffect(effect, true);
                }
            }
            itemStack.setItemMeta((ItemMeta)meta);
        }
        if (itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        if (this.options.damage().isPresent()) {
            String parsedDamage = holder.setPlaceholdersAndArguments(this.options.damage().get());
            try {
                ItemMeta meta2;
                int damage = Integer.parseInt(parsedDamage);
                if (damage > 0 && (meta2 = itemStack.getItemMeta()) instanceof Damageable) {
                    ((Damageable)meta2).setDamage(damage);
                    itemStack.setItemMeta(meta2);
                }
            }
            catch (NumberFormatException exception) {
                this.plugin.printStacktrace("Invalid damage found: " + parsedDamage + ".", exception);
            }
        }
        if (this.options.amount() != -1) {
            amount = this.options.amount();
        }
        if (this.options.dynamicAmount().isPresent()) {
            try {
                int dynamicAmount = (int)Double.parseDouble(holder.setPlaceholdersAndArguments(this.options.dynamicAmount().get()));
                amount = Math.max(dynamicAmount, 1);
            }
            catch (NumberFormatException dynamicAmount) {
                // empty catch block
            }
        }
        if (amount > 64) {
            amount = 64;
        }
        itemStack.setAmount(amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        if (VersionHelper.IS_CUSTOM_MODEL_DATA && this.options.customModelData().isPresent()) {
            try {
                int modelData = Integer.parseInt(holder.setPlaceholdersAndArguments(this.options.customModelData().get()));
                itemMeta.setCustomModelData(Integer.valueOf(modelData));
            }
            catch (Exception modelData) {
                // empty catch block
            }
        }
        if (VersionHelper.IS_CUSTOM_MODEL_DATA_COMPONENT && this.options.customModelDataComponent().isPresent()) {
            itemMeta.setCustomModelDataComponent(this.parseCustomModelDataComponent(this.options.customModelDataComponent().get(), itemMeta.getCustomModelDataComponent(), holder));
        }
        if (this.options.displayName().isPresent()) {
            String displayName = holder.setPlaceholdersAndArguments(this.options.displayName().get());
            itemMeta.setDisplayName(StringUtils.color(displayName));
        }
        ArrayList<String> lore = new ArrayList<String>();
        List itemLore = Objects.requireNonNullElse(itemMeta.getLore(), new ArrayList());
        LoreAppendMode mode = this.options.loreAppendMode().orElse(LoreAppendMode.OVERRIDE);
        if (!this.options.hasLore() && this.options.loreAppendMode().isEmpty()) {
            mode = LoreAppendMode.IGNORE;
        }
        switch (mode) {
            case IGNORE: {
                lore.addAll(itemLore);
                break;
            }
            case TOP: {
                lore.addAll(this.getMenuItemLore(holder, this.options.lore()));
                lore.addAll(itemLore);
                break;
            }
            case BOTTOM: {
                lore.addAll(itemLore);
                lore.addAll(this.getMenuItemLore(holder, this.options.lore()));
                break;
            }
            case OVERRIDE: {
                lore.addAll(this.getMenuItemLore(holder, this.options.lore()));
            }
        }
        itemMeta.setLore(lore);
        if (this.options.unbreakable()) {
            itemMeta.setUnbreakable(true);
        }
        if (VersionHelper.HAS_DATA_COMPONENTS) {
            if (this.options.hideTooltip().isPresent()) {
                String hideTooltip = holder.setPlaceholdersAndArguments(this.options.hideTooltip().get());
                itemMeta.setHideTooltip(Boolean.parseBoolean(hideTooltip));
            }
            if (this.options.enchantmentGlintOverride().isPresent()) {
                String enchantmentGlintOverride = holder.setPlaceholdersAndArguments(this.options.enchantmentGlintOverride().get());
                itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(Boolean.parseBoolean(enchantmentGlintOverride)));
            }
            if (this.options.rarity().isPresent()) {
                String rarity = holder.setPlaceholdersAndArguments(this.options.rarity().get());
                try {
                    itemMeta.setRarity(ItemRarity.valueOf((String)rarity.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Rarity " + rarity + " is not a valid!");
                }
            }
        }
        if (VersionHelper.HAS_TOOLTIP_STYLE) {
            NamespacedKey itemModel;
            NamespacedKey tooltipStyle;
            if (this.options.tooltipStyle().isPresent() && (tooltipStyle = NamespacedKey.fromString((String)holder.setPlaceholdersAndArguments(this.options.tooltipStyle().get()))) != null) {
                itemMeta.setTooltipStyle(tooltipStyle);
            }
            if (this.options.itemModel().isPresent() && (itemModel = NamespacedKey.fromString((String)holder.setPlaceholdersAndArguments(this.options.itemModel().get()))) != null) {
                itemMeta.setItemModel(itemModel);
            }
        }
        if (VersionHelper.HAS_ARMOR_TRIMS && ItemUtils.hasArmorMeta(itemStack)) {
            Optional<String> trimMaterialName = this.options.trimMaterial();
            Optional<String> trimPatternName = this.options.trimPattern();
            if (trimMaterialName.isPresent() && trimPatternName.isPresent()) {
                TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.match(holder.setPlaceholdersAndArguments(trimMaterialName.get()));
                TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.match(holder.setPlaceholdersAndArguments(trimPatternName.get()));
                if (trimMaterial != null && trimPattern != null) {
                    ArmorTrim armorTrim = new ArmorTrim(trimMaterial, trimPattern);
                    ArmorMeta armorMeta = (ArmorMeta)itemMeta;
                    armorMeta.setTrim(armorTrim);
                    itemStack.setItemMeta((ItemMeta)armorMeta);
                } else {
                    if (trimMaterial == null) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Trim material " + trimMaterialName.get() + " is not a valid!");
                    }
                    if (trimPattern == null) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Trim pattern " + trimPatternName.get() + " is not a valid!");
                    }
                }
            } else if (trimMaterialName.isPresent()) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Trim pattern is not set for item with trim material " + trimMaterialName.get());
            } else if (trimPatternName.isPresent()) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Trim material is not set for item with trim pattern " + trimPatternName.get());
            }
        }
        if (itemMeta instanceof LeatherArmorMeta && this.options.rgb().isPresent()) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            color = this.parseRGBColor(holder.setPlaceholdersAndArguments(this.options.rgb().get()));
            if (color != null) {
                leatherArmorMeta.setColor((Color)color);
            } else {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Invalid rgb colors found for leather armor: " + this.options.rgb().get());
            }
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        } else if (itemMeta instanceof FireworkEffectMeta && this.options.rgb().isPresent()) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemMeta;
            color = this.parseRGBColor(holder.setPlaceholdersAndArguments(this.options.rgb().get()));
            if (color != null) {
                fireworkEffectMeta.setEffect(FireworkEffect.builder().withColor((Color)color).build());
            } else {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Invalid RGB color found for firework or firework star: " + this.options.rgb().get());
            }
            itemStack.setItemMeta((ItemMeta)fireworkEffectMeta);
        } else if (itemMeta instanceof EnchantmentStorageMeta && !this.options.enchantments().isEmpty()) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            for (Map.Entry entry : this.options.enchantments().entrySet()) {
                boolean result = enchantmentStorageMeta.addStoredEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
                if (result) continue;
                this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Failed to add enchantment " + ((Enchantment)entry.getKey()).getName() + " to item " + String.valueOf(itemStack.getType()));
            }
            itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            itemStack.setItemMeta(itemMeta);
        }
        if (!(itemMeta instanceof EnchantmentStorageMeta) && !this.options.enchantments().isEmpty()) {
            this.options.enchantments().forEach((enchantment, level) -> itemMeta.addEnchant(enchantment, level.intValue(), true));
        }
        if (this.options.lightLevel().isPresent() && itemMeta instanceof BlockDataMeta && (blockData = (blockDataMeta = (BlockDataMeta)itemMeta).getBlockData(itemStack.getType())) instanceof Light) {
            Light light = (Light)blockData;
            String parsedLightLevel = holder.setPlaceholdersAndArguments(this.options.lightLevel().get());
            try {
                int lightLevel = Math.min(Integer.parseInt(parsedLightLevel), light.getMaximumLevel());
                light.setLevel(Math.max(lightLevel, 0));
                if (lightLevel < 0) {
                    this.plugin.debug(DebugLevel.MEDIUM, Level.WARNING, "Invalid light level found for light block: " + parsedLightLevel + ". Setting to 0.");
                }
                if (lightLevel > light.getMaximumLevel()) {
                    this.plugin.debug(DebugLevel.MEDIUM, Level.WARNING, "Invalid light level found for light block: " + parsedLightLevel + ". Setting to " + light.getMaximumLevel() + ".");
                }
                blockDataMeta.setBlockData((BlockData)light);
            }
            catch (Exception exception) {
                this.plugin.printStacktrace("Invalid light level found for light block: " + parsedLightLevel, exception);
            }
        }
        if (!this.options.itemFlags().isEmpty()) {
            for (ItemFlag flag : this.options.itemFlags()) {
                itemMeta.addItemFlags(new ItemFlag[]{flag});
                if (flag != ItemFlag.HIDE_ATTRIBUTES || !VersionHelper.HAS_DATA_COMPONENTS) continue;
                itemMeta.setAttributeModifiers((Multimap)ImmutableMultimap.of());
            }
        }
        itemStack.setItemMeta(itemMeta);
        if (NbtProvider.isAvailable()) {
            String[] parts;
            String[] parts2;
            String tag;
            String tag2;
            if (this.options.nbtString().isPresent() && (tag2 = holder.setPlaceholdersAndArguments(this.options.nbtString().get())).contains(":")) {
                String[] parts22 = tag2.split(":", 2);
                itemStack = NbtProvider.setString(itemStack, parts22[0], parts22[1]);
            }
            if (this.options.nbtByte().isPresent() && (tag = holder.setPlaceholdersAndArguments(this.options.nbtByte().get())).contains(":")) {
                parts2 = tag.split(":");
                itemStack = NbtProvider.setByte(itemStack, parts2[0], Byte.parseByte(parts2[1]));
            }
            if (this.options.nbtShort().isPresent() && (tag = holder.setPlaceholdersAndArguments(this.options.nbtShort().get())).contains(":")) {
                parts2 = tag.split(":");
                itemStack = NbtProvider.setShort(itemStack, parts2[0], Short.parseShort(parts2[1]));
            }
            if (this.options.nbtInt().isPresent() && (tag = holder.setPlaceholdersAndArguments(this.options.nbtInt().get())).contains(":")) {
                parts2 = tag.split(":");
                itemStack = NbtProvider.setInt(itemStack, parts2[0], Integer.parseInt(parts2[1]));
            }
            for (String nbtTag : this.options.nbtStrings()) {
                String string = holder.setPlaceholdersAndArguments(nbtTag);
                if (!string.contains(":")) continue;
                parts = string.split(":", 2);
                itemStack = NbtProvider.setString(itemStack, parts[0], parts[1]);
            }
            for (String nbtTag : this.options.nbtBytes()) {
                String string = holder.setPlaceholdersAndArguments(nbtTag);
                if (!string.contains(":")) continue;
                parts = string.split(":");
                itemStack = NbtProvider.setByte(itemStack, parts[0], Byte.parseByte(parts[1]));
            }
            for (String nbtTag : this.options.nbtShorts()) {
                String string = holder.setPlaceholdersAndArguments(nbtTag);
                if (!string.contains(":")) continue;
                parts = string.split(":");
                itemStack = NbtProvider.setShort(itemStack, parts[0], Short.parseShort(parts[1]));
            }
            for (String nbtTag : this.options.nbtInts()) {
                String string = holder.setPlaceholdersAndArguments(nbtTag);
                if (!string.contains(":")) continue;
                parts = string.split(":");
                itemStack = NbtProvider.setInt(itemStack, parts[0], Integer.parseInt(parts[1]));
            }
        }
        return itemStack;
    }

    private boolean isHeadItem(@NotNull String material) {
        Optional<HeadType> headType = HeadType.parseHeadType(material);
        headType.ifPresent(this.options::headType);
        return headType.isPresent();
    }

    @NotNull
    private Optional<ItemStack> getItemFromHook(String hookName, String ... args) {
        return this.plugin.getItemHook(hookName).map(itemHook -> itemHook.getItem(args));
    }

    protected List<String> getMenuItemLore(@NotNull MenuHolder holder, @NotNull List<String> lore) {
        return lore.stream().map(holder::setPlaceholdersAndArguments).map(StringUtils::color).map(line -> line.split("\n")).flatMap(Arrays::stream).map(line -> line.split("\\\\n")).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    @NotNull
    private org.bukkit.inventory.meta.components.CustomModelDataComponent parseCustomModelDataComponent(@NotNull CustomModelDataComponent unparsedComponent, @NotNull org.bukkit.inventory.meta.components.CustomModelDataComponent component, @NotNull MenuHolder holder) {
        if (!unparsedComponent.colors().isEmpty()) {
            List colors = unparsedComponent.colors().stream().map(holder::setPlaceholdersAndArguments).map(this::parseRGBColor).filter(Objects::nonNull).collect(Collectors.toList());
            component.setColors(colors);
        }
        if (!unparsedComponent.flags().isEmpty()) {
            List flags = unparsedComponent.flags().stream().map(holder::setPlaceholdersAndArguments).map(Boolean::parseBoolean).collect(Collectors.toList());
            component.setFlags(flags);
        }
        if (!unparsedComponent.floats().isEmpty()) {
            List floats = unparsedComponent.floats().stream().map(holder::setPlaceholdersAndArguments).map(Float::parseFloat).collect(Collectors.toList());
            component.setFloats(floats);
        }
        if (!unparsedComponent.strings().isEmpty()) {
            List strings = unparsedComponent.strings().stream().map(holder::setPlaceholdersAndArguments).collect(Collectors.toList());
            component.setStrings(strings);
        }
        return component;
    }

    @Nullable
    private Color parseRGBColor(@NotNull String input) {
        Color color = StringUtils.parseRGBColor(input);
        if (color == null) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Invalid RGB color found: " + input);
        }
        return color;
    }

    @NotNull
    public MenuItemOptions options() {
        return this.options;
    }
}

