/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.persistentmeta;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DataAction {
    SET,
    REMOVE,
    ADD,
    SUBTRACT,
    SWITCH;

    static final Map<String, DataAction> BY_NAME;

    @Nullable
    public static DataAction getActionByName(@NotNull String name) {
        return BY_NAME.get(name.toUpperCase(Locale.ROOT));
    }

    static {
        BY_NAME = Arrays.stream(DataAction.values()).collect(Collectors.toUnmodifiableMap(Enum::name, Function.identity()));
    }
}

