/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.placeholder;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.options.MenuOptions;
import com.extendedclip.deluxemenus.persistentmeta.DataType;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Expansion
extends PlaceholderExpansion {
    private final DeluxeMenus plugin;

    public Expansion(@NotNull DeluxeMenus instance) {
        this.plugin = instance;
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @NotNull
    public List<String> getPlaceholders() {
        return List.of("%deluxemenus_is_in_menu%", "%deluxemenus_opened_menu%", "%deluxemenus_last_menu%", "%deluxemenus_meta_has_value_<key>_[type]%", "%deluxemenus_meta_<key>_<type>_[default-value]%");
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String input) {
        String parsedInputLower;
        if (offlinePlayer == null || !offlinePlayer.isOnline()) {
            return null;
        }
        Player onlinePlayer = offlinePlayer.getPlayer();
        if (onlinePlayer == null) {
            return null;
        }
        String parsedInput = PlaceholderAPI.setBracketPlaceholders((Player)onlinePlayer, (String)input);
        switch (parsedInputLower = parsedInput.toLowerCase()) {
            case "is_in_menu": {
                return this.getBooleanAsString(Menu.getMenuHolder(onlinePlayer).isPresent());
            }
            case "opened_menu": {
                return Menu.getOpenMenu(onlinePlayer).map(Menu::options).map(MenuOptions::name).orElse("");
            }
            case "last_menu": {
                return Menu.getLastMenu(onlinePlayer).map(Menu::options).map(MenuOptions::name).orElse("");
            }
        }
        if (!parsedInputLower.startsWith("meta_")) {
            return null;
        }
        if (!VersionHelper.IS_PDC_VERSION || this.plugin.getPersistentMetaHandler() == null) {
            return null;
        }
        if (parsedInputLower.startsWith("meta_has_value_")) {
            String hasValueInput = parsedInput.substring(15);
            String[] hasValueParts = hasValueInput.split("_", 2);
            if (hasValueParts.length < 1 || hasValueParts.length > 2) {
                return null;
            }
            NamespacedKey key = this.plugin.getPersistentMetaHandler().getKey(hasValueParts[0]);
            if (key == null) {
                return this.getBooleanAsString(false);
            }
            if (hasValueParts.length == 1) {
                return this.getBooleanAsString(this.plugin.getPersistentMetaHandler().hasMetaValue(onlinePlayer, key));
            }
            DataType<?, ?> type = DataType.getSupportedTypeByName(hasValueParts[1]);
            if (type == null) {
                return this.getBooleanAsString(false);
            }
            return this.getBooleanAsString(this.plugin.getPersistentMetaHandler().hasMetaValue(onlinePlayer, key, type));
        }
        String getValueInput = parsedInput.substring(5);
        if (!getValueInput.contains("_")) {
            return null;
        }
        String[] parts = getValueInput.split("_", 3);
        if (parts.length < 2) {
            return null;
        }
        NamespacedKey key = this.plugin.getPersistentMetaHandler().getKey(parts[0]);
        if (key == null) {
            return this.getBooleanAsString(false);
        }
        DataType<?, ?> type = DataType.getSupportedTypeByName(parts[1]);
        if (type == null) {
            return this.getBooleanAsString(false);
        }
        Object result = this.plugin.getPersistentMetaHandler().getMetaValue(onlinePlayer, key, type);
        if (result != null) {
            return String.valueOf(result);
        }
        return parts.length > 2 ? parts[2] : "";
    }

    @NotNull
    private String getBooleanAsString(boolean value) {
        return value ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }
}

