/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.options.CustomModelDataComponent;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.requirement.wrappers.ItemWrapper;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class HasItemRequirement
extends Requirement {
    private final DeluxeMenus plugin;
    private final ItemWrapper wrapper;
    private final boolean invert;

    public HasItemRequirement(DeluxeMenus plugin, ItemWrapper wrapper, boolean invert) {
        this.plugin = plugin;
        this.wrapper = wrapper;
        this.invert = invert;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        String materialName = holder.setPlaceholdersAndArguments(this.wrapper.getMaterial());
        Material material = DeluxeMenus.MATERIALS.get(materialName.toUpperCase());
        ItemHook pluginHook = null;
        if (material == null && (pluginHook = (ItemHook)this.plugin.getItemHooks().values().stream().filter(x -> materialName.toLowerCase().startsWith(x.getPrefix())).findFirst().orElse(null)) == null) {
            return this.invert;
        }
        if (material == Material.AIR) {
            return this.invert == (holder.getViewer().getInventory().firstEmpty() == -1);
        }
        ItemStack[] armor = this.wrapper.checkArmor() ? holder.getViewer().getInventory().getArmorContents() : null;
        ItemStack[] offHand = this.wrapper.checkOffhand() ? holder.getViewer().getInventory().getExtraContents() : null;
        ItemStack[] inventory = holder.getViewer().getInventory().getStorageContents();
        int total = 0;
        for (ItemStack itemToCheck : inventory) {
            if (!this.isRequiredItem(itemToCheck, holder, material, pluginHook)) continue;
            total += itemToCheck.getAmount();
        }
        if (offHand != null) {
            for (ItemStack itemToCheck : offHand) {
                if (!this.isRequiredItem(itemToCheck, holder, material, pluginHook)) continue;
                total += itemToCheck.getAmount();
            }
        }
        if (armor != null) {
            for (ItemStack itemToCheck : armor) {
                if (!this.isRequiredItem(itemToCheck, holder, material, pluginHook)) continue;
                total += itemToCheck.getAmount();
            }
        }
        return this.invert == total < this.wrapper.getAmount();
    }

    private boolean isRequiredItem(ItemStack itemToCheck, MenuHolder holder, Material material, ItemHook pluginHook) {
        if (itemToCheck == null || itemToCheck.getType() == Material.AIR) {
            return false;
        }
        if (pluginHook != null ? !pluginHook.itemMatchesIdentifiers(itemToCheck, holder.setPlaceholdersAndArguments(this.wrapper.getMaterial().substring(pluginHook.getPrefix().length()))) : this.wrapper.getMaterial() != null && itemToCheck.getType() != material) {
            return false;
        }
        if (this.wrapper.hasData() && itemToCheck.getDurability() != this.wrapper.getData()) {
            return false;
        }
        ItemMeta metaToCheck = itemToCheck.getItemMeta();
        if (this.wrapper.isStrict()) {
            if (metaToCheck != null) {
                if (VersionHelper.IS_CUSTOM_MODEL_DATA && metaToCheck.hasCustomModelData()) {
                    return false;
                }
                if (VersionHelper.IS_CUSTOM_MODEL_DATA_COMPONENT && !this.isEmptyModelData(metaToCheck.getCustomModelDataComponent())) {
                    return false;
                }
                if (metaToCheck.hasLore()) {
                    return false;
                }
                return !metaToCheck.hasDisplayName();
            }
        } else {
            String loreToCheck;
            String lore;
            List loreX;
            if (metaToCheck == null) {
                if (this.wrapper.getCustomData() != 0 || this.wrapper.getName() != null || this.wrapper.getLore() != null || this.wrapper.getLoreList() != null) {
                    return false;
                }
                if (VersionHelper.IS_CUSTOM_MODEL_DATA_COMPONENT && !this.isEmptyModelData(this.wrapper.getCustomModelDataComponent())) {
                    return false;
                }
            }
            if (this.wrapper.getCustomData() != 0 && VersionHelper.IS_CUSTOM_MODEL_DATA) {
                if (!metaToCheck.hasCustomModelData()) {
                    return false;
                }
                if (metaToCheck.getCustomModelData() != this.wrapper.getCustomData()) {
                    return false;
                }
            }
            if (VersionHelper.IS_CUSTOM_MODEL_DATA_COMPONENT && !this.isEmptyModelData(this.wrapper.getCustomModelDataComponent()) && !this.itemModelComponentContains(holder, metaToCheck.getCustomModelDataComponent(), this.wrapper.getCustomModelDataComponent())) {
                return false;
            }
            if (this.wrapper.getName() != null) {
                if (!metaToCheck.hasDisplayName()) {
                    return false;
                }
                String name = StringUtils.color(holder.setPlaceholdersAndArguments(this.wrapper.getName()));
                String nameToCheck = StringUtils.color(holder.setPlaceholdersAndArguments(metaToCheck.getDisplayName()));
                if (this.wrapper.checkNameContains() && this.wrapper.checkNameIgnoreCase() ? !org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)nameToCheck, (CharSequence)name) : (this.wrapper.checkNameContains() ? !nameToCheck.contains(name) : (this.wrapper.checkNameIgnoreCase() ? !nameToCheck.equalsIgnoreCase(name) : !nameToCheck.equals(name)))) {
                    return false;
                }
            }
            if (this.wrapper.getLoreList() != null) {
                loreX = metaToCheck.getLore();
                if (loreX == null) {
                    return false;
                }
                lore = this.wrapper.getLoreList().stream().map(holder::setPlaceholdersAndArguments).map(StringUtils::color).collect(Collectors.joining("&&"));
                loreToCheck = loreX.stream().map(holder::setPlaceholdersAndArguments).map(StringUtils::color).collect(Collectors.joining("&&"));
                if (this.wrapper.checkLoreContains() && this.wrapper.checkLoreIgnoreCase() ? !org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)loreToCheck, (CharSequence)lore) : (this.wrapper.checkLoreContains() ? !loreToCheck.contains(lore) : (this.wrapper.checkLoreIgnoreCase() ? !loreToCheck.equalsIgnoreCase(lore) : !loreToCheck.equals(lore)))) {
                    return false;
                }
            }
            if (this.wrapper.getLore() != null) {
                loreX = metaToCheck.getLore();
                if (loreX == null) {
                    return false;
                }
                lore = StringUtils.color(holder.setPlaceholdersAndArguments(this.wrapper.getLore()));
                loreToCheck = loreX.stream().map(holder::setPlaceholdersAndArguments).map(StringUtils::color).collect(Collectors.joining("&&"));
                if (this.wrapper.checkLoreContains() && this.wrapper.checkLoreIgnoreCase()) {
                    return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)loreToCheck, (CharSequence)lore);
                }
                if (this.wrapper.checkLoreContains()) {
                    return loreToCheck.contains(lore);
                }
                if (this.wrapper.checkLoreIgnoreCase()) {
                    return loreToCheck.equalsIgnoreCase(lore);
                }
                return loreToCheck.equals(lore);
            }
        }
        return true;
    }

    private boolean isEmptyModelData(@NotNull org.bukkit.inventory.meta.components.CustomModelDataComponent modelData) {
        return modelData.getColors().isEmpty() && modelData.getFlags().isEmpty() && modelData.getFloats().isEmpty() && modelData.getStrings().isEmpty();
    }

    private boolean isEmptyModelData(@NotNull CustomModelDataComponent modelData) {
        return modelData.colors().isEmpty() && modelData.flags().isEmpty() && modelData.floats().isEmpty() && modelData.strings().isEmpty();
    }

    private boolean itemModelComponentContains(MenuHolder holder, @NotNull org.bukkit.inventory.meta.components.CustomModelDataComponent modelData, @NotNull CustomModelDataComponent wrapper) {
        if (!wrapper.colors().isEmpty()) {
            List colors = wrapper.colors().stream().map(holder::setPlaceholdersAndArguments).map(StringUtils::parseRGBColor).filter(Objects::nonNull).collect(Collectors.toList());
            for (Color color : colors) {
                if (modelData.getColors().contains(color)) continue;
                return false;
            }
        }
        if (!wrapper.flags().isEmpty()) {
            List flags = wrapper.flags().stream().map(holder::setPlaceholdersAndArguments).map(Boolean::parseBoolean).collect(Collectors.toList());
            for (Boolean flag : flags) {
                if (modelData.getFlags().contains(flag)) continue;
                return false;
            }
        }
        if (!wrapper.floats().isEmpty()) {
            List floats = wrapper.floats().stream().map(holder::setPlaceholdersAndArguments).map(Float::parseFloat).collect(Collectors.toList());
            for (Float floatValue : floats) {
                if (modelData.getFloats().contains(floatValue)) continue;
                return false;
            }
        }
        if (!wrapper.strings().isEmpty()) {
            List strings = wrapper.strings().stream().map(holder::setPlaceholdersAndArguments).collect(Collectors.toList());
            for (String string : strings) {
                if (modelData.getStrings().contains(string)) continue;
                return false;
            }
        }
        return true;
    }
}

