/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.requirement;

import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class IsObjectRequirement
extends Requirement {
    private final String input;
    private final String object;

    public IsObjectRequirement(String input, String object) {
        this.input = input;
        this.object = object;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        String toCheck = holder.setPlaceholdersAndArguments(this.input);
        switch (this.object) {
            case "int": {
                return Ints.tryParse((String)toCheck) != null;
            }
            case "double": {
                return Doubles.tryParse((String)toCheck) != null;
            }
            case "player": {
                try {
                    UUID id = UUID.fromString(toCheck);
                    return Bukkit.getPlayer((UUID)id) != null;
                }
                catch (IllegalArgumentException e) {
                    return Bukkit.getPlayerExact((String)toCheck) != null;
                }
            }
            case "uuid": {
                try {
                    UUID.fromString(toCheck);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        holder.getPlugin().debug(DebugLevel.HIGHEST, Level.INFO, "Invalid object: " + this.object + " in \"is object\" check.");
        return false;
    }
}

