/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import com.extendedclip.deluxemenus.utils.Constants;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public final class ItemUtils {
    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isPlaceholderOption(@NotNull String material) {
        return material.toLowerCase(Locale.ROOT).startsWith("placeholder-");
    }

    public static boolean isPlayerItem(@NotNull String material) {
        return Constants.INVENTORY_ITEM_ACCESSORS.containsKey(material);
    }

    public static boolean isWaterBottle(@NotNull String material) {
        return material.equalsIgnoreCase("water_bottle");
    }

    public static boolean isBanner(@NotNull Material material) {
        return material.name().endsWith("_BANNER");
    }

    public static boolean isShield(@NotNull Material material) {
        return material == Material.SHIELD;
    }

    public static boolean hasArmorMeta(@NotNull ItemStack itemStack) {
        return itemStack.getItemMeta() instanceof ArmorMeta;
    }

    public static boolean hasPotionMeta(@NotNull ItemStack itemStack) {
        return itemStack.getItemMeta() instanceof PotionMeta;
    }

    @NotNull
    public static ItemStack createWaterBottles(int amount) {
        ItemStack itemStack = new ItemStack(Material.POTION, amount);
        PotionMeta itemMeta = (PotionMeta)itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setBasePotionType(PotionType.WATER);
            itemStack.setItemMeta((ItemMeta)itemMeta);
        }
        return itemStack;
    }
}

