/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("&(#[a-f0-9]{6})", 2);

    @NotNull
    public static String color(@NotNull String input) {
        Matcher m = HEX_PATTERN.matcher(input);
        if (VersionHelper.IS_HEX_VERSION) {
            while (m.find()) {
                input = input.replace(m.group(), ChatColor.of((String)m.group(1)).toString());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    @NotNull
    public static String replacePlaceholdersAndArguments(@NotNull String input, @Nullable Map<String, String> arguments, @Nullable Player player, boolean parsePlaceholdersInsideArguments, boolean parsePlaceholdersAfterArguments) {
        if (player == null) {
            return StringUtils.replaceArguments(input, arguments, null, parsePlaceholdersInsideArguments);
        }
        if (parsePlaceholdersAfterArguments) {
            return StringUtils.replacePlaceholders(StringUtils.replaceArguments(input, arguments, player, parsePlaceholdersInsideArguments), player);
        }
        return StringUtils.replaceArguments(StringUtils.replacePlaceholders(input, player), arguments, player, parsePlaceholdersInsideArguments);
    }

    @NotNull
    public static String replacePlaceholders(@NotNull String input, @NotNull Player player) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)input);
    }

    @NotNull
    public static String replaceArguments(@NotNull String input, @Nullable Map<String, String> arguments, @Nullable Player player, boolean parsePlaceholdersInsideArguments) {
        if (arguments == null || arguments.isEmpty()) {
            return input;
        }
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            String value = player != null && parsePlaceholdersInsideArguments ? StringUtils.replacePlaceholders(entry.getValue(), player) : entry.getValue();
            input = input.replace("{" + entry.getKey() + "}", value);
        }
        return input;
    }

    @Nullable
    public static Color parseRGBColor(@NotNull String input) {
        String[] parts = input.split(",");
        try {
            return Color.fromRGB((int)Integer.parseInt(parts[0].trim()), (int)Integer.parseInt(parts[1].trim()), (int)Integer.parseInt(parts[2].trim()));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

