/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.activitylog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import me.lucko.spark.paper.common.activitylog.Activity;

public class ActivityLog {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser PARSER = new JsonParser();
    private final Path file;
    private final LinkedList<Activity> log = new LinkedList();
    private final Object[] mutex = new Object[0];

    public ActivityLog(Path file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLog(Activity activity) {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            this.log.addFirst(activity);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.save();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getLog() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new LinkedList<Activity>(this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        JsonArray array = new JsonArray();
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            for (Activity activity : this.log) {
                if (activity.shouldExpire()) continue;
                array.add((JsonElement)activity.serialize());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)array, (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        JsonArray array;
        if (!Files.exists(this.file, new LinkOption[0])) {
            Object[] objectArray = this.mutex;
            synchronized (this.mutex) {
                this.log.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
            array = PARSER.parse((Reader)reader).getAsJsonArray();
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
            return;
        }
        boolean save = false;
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            this.log.clear();
            for (JsonElement element : array) {
                try {
                    Activity activity = Activity.deserialize(element);
                    if (activity.shouldExpire()) {
                        save = true;
                        continue;
                    }
                    this.log.add(activity);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var3_8] (shouldn't be in output)
            if (save) {
                try {
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }
}

