/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.util;

import com.google.common.base.Strings;
import java.lang.management.MemoryUsage;
import java.util.Locale;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.paper.common.util.FormatUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class StatisticFormatter
extends Enum<StatisticFormatter> {
    private static final String BAR_TRUE_CHARACTER = "\u2503";
    private static final String BAR_FALSE_CHARACTER = "\u257b";
    private static final /* synthetic */ StatisticFormatter[] $VALUES;

    public static StatisticFormatter[] values() {
        return (StatisticFormatter[])$VALUES.clone();
    }

    public static StatisticFormatter valueOf(String name) {
        return Enum.valueOf(StatisticFormatter.class, name);
    }

    public static TextComponent formatTps(double tps) {
        NamedTextColor color = tps > 18.0 ? NamedTextColor.GREEN : (tps > 16.0 ? NamedTextColor.YELLOW : NamedTextColor.RED);
        return Component.text((String)((tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0)), (TextColor)color);
    }

    public static TextComponent formatTickDurations(DoubleAverageInfo average) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatTickDuration(average.min()))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.GRAY))).append((Component)StatisticFormatter.formatTickDuration(average.median()))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.GRAY))).append((Component)StatisticFormatter.formatTickDuration(average.percentile95th()))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.GRAY))).append((Component)StatisticFormatter.formatTickDuration(average.max()))).build();
    }

    public static TextComponent formatTickDuration(double duration) {
        NamedTextColor color = duration >= 50.0 ? NamedTextColor.RED : (duration >= 40.0 ? NamedTextColor.YELLOW : NamedTextColor.GREEN);
        return Component.text((String)String.format(Locale.ENGLISH, "%.1f", duration), (TextColor)color);
    }

    public static TextComponent formatCpuUsage(double usage) {
        NamedTextColor color = usage > 0.9 ? NamedTextColor.RED : (usage > 0.65 ? NamedTextColor.YELLOW : NamedTextColor.GREEN);
        return Component.text((String)FormatUtil.percent(usage, 1.0), (TextColor)color);
    }

    public static TextComponent formatPingRtts(double min, double median, double percentile95th, double max) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)StatisticFormatter.formatPingRtt(min))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.GRAY))).append((Component)StatisticFormatter.formatPingRtt(median))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.GRAY))).append((Component)StatisticFormatter.formatPingRtt(percentile95th))).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.GRAY))).append((Component)StatisticFormatter.formatPingRtt(max))).build();
    }

    public static TextComponent formatPingRtt(double ping) {
        NamedTextColor color = ping >= 200.0 ? NamedTextColor.RED : (ping >= 100.0 ? NamedTextColor.YELLOW : NamedTextColor.GREEN);
        return Component.text((int)((int)Math.ceil(ping)), (TextColor)color);
    }

    public static TextComponent generateMemoryUsageDiagram(MemoryUsage usage, int length) {
        double used = usage.getUsed();
        double committed = usage.getCommitted();
        double max = usage.getMax();
        int usedChars = (int)(used * (double)length / max);
        int committedChars = (int)(committed * (double)length / max);
        TextComponent.Builder line = (TextComponent.Builder)Component.text().content(Strings.repeat((String)BAR_TRUE_CHARACTER, (int)usedChars)).color((TextColor)NamedTextColor.YELLOW);
        if (committedChars > usedChars) {
            line.append((Component)Component.text((String)Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(committedChars - usedChars - 1)), (TextColor)NamedTextColor.GRAY));
            line.append((Component)Component.text((String)BAR_FALSE_CHARACTER, (TextColor)NamedTextColor.RED));
        }
        if (length > committedChars) {
            line.append((Component)Component.text((String)Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(length - committedChars)), (TextColor)NamedTextColor.GRAY));
        }
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)line.build())).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).build();
    }

    public static TextComponent generateMemoryPoolDiagram(MemoryUsage usage, MemoryUsage collectionUsage, int length) {
        double used;
        double collectionUsed = used = (double)usage.getUsed();
        if (collectionUsage != null) {
            collectionUsed = collectionUsage.getUsed();
        }
        double committed = usage.getCommitted();
        double max = usage.getMax();
        int usedChars = (int)(used * (double)length / max);
        int collectionUsedChars = (int)(collectionUsed * (double)length / max);
        int committedChars = (int)(committed * (double)length / max);
        TextComponent.Builder line = (TextComponent.Builder)Component.text().content(Strings.repeat((String)BAR_TRUE_CHARACTER, (int)collectionUsedChars)).color((TextColor)NamedTextColor.YELLOW);
        if (usedChars > collectionUsedChars) {
            line.append((Component)Component.text((String)BAR_TRUE_CHARACTER, (TextColor)NamedTextColor.RED));
            line.append((Component)Component.text((String)Strings.repeat((String)BAR_TRUE_CHARACTER, (int)(usedChars - collectionUsedChars - 1)), (TextColor)NamedTextColor.YELLOW));
        }
        if (committedChars > usedChars) {
            line.append((Component)Component.text((String)Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(committedChars - usedChars - 1)), (TextColor)NamedTextColor.GRAY));
            line.append((Component)Component.text((String)BAR_FALSE_CHARACTER, (TextColor)NamedTextColor.YELLOW));
        }
        if (length > committedChars) {
            line.append((Component)Component.text((String)Strings.repeat((String)BAR_FALSE_CHARACTER, (int)(length - committedChars)), (TextColor)NamedTextColor.GRAY));
        }
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)line.build())).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).build();
    }

    public static TextComponent generateDiskUsageDiagram(double used, double max, int length) {
        int usedChars = (int)(used * (double)length / max);
        int freeChars = length - usedChars;
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)Strings.repeat((String)BAR_TRUE_CHARACTER, (int)usedChars), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)Strings.repeat((String)BAR_FALSE_CHARACTER, (int)freeChars), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).build();
    }

    private static /* synthetic */ StatisticFormatter[] $values() {
        return new StatisticFormatter[0];
    }

    static {
        $VALUES = StatisticFormatter.$values();
    }
}

