/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.util.log;

import java.util.logging.Level;

public interface Logger {
    public static final Logger FALLBACK = new Logger(){

        @Override
        public void log(Level level, String msg) {
            if (level.intValue() >= 1000) {
                System.err.println(msg);
            } else {
                System.out.println(msg);
            }
        }

        @Override
        public void log(Level level, String msg, Throwable throwable) {
            if (Logger.isSevere(level)) {
                System.err.println(msg);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            } else {
                System.out.println(msg);
                if (throwable != null) {
                    throwable.printStackTrace(System.out);
                }
            }
        }
    };

    public void log(Level var1, String var2);

    public void log(Level var1, String var2, Throwable var3);

    public static boolean isSevere(Level level) {
        return level.intValue() >= 1000;
    }

    public static boolean isWarning(Level level) {
        return level.intValue() >= 900;
    }
}

