/*
 * Decompiled with CFR 0.152.
 */
package me.uwpctf;

import me.uwpctf.GameProperties;
import me.uwpctf.Helpers;
import me.uwpctf.Players;
import me.uwpctf.Teams;
import me.uwpctf.YamlHandler;
import me.uwpctf.dbHandler;
import me.uwpctf.values;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FlagLogic
implements Listener {
    private static int captureDistance = 1;
    static YamlHandler yamlHandler = new YamlHandler();
    private static values val = yamlHandler.readYaml();
    static World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
    static Location blue = new Location(gameWorld, (double)val.getBlueNetheriteX(), (double)val.getBlueNetheriteY(), (double)val.getBlueNetheriteZ());
    static Location red = new Location(gameWorld, (double)val.getRedNetheriteX(), (double)val.getRedNetheriteY(), (double)val.getRedNetheriteZ());

    public static void calculateCaptures() {
        for (Player p : Players.getPlayers()) {
            if (FlagLogic.playerCanStealThisFlag(p, "Red")) {
                FlagLogic.playerStoleRedFlagTasks(p);
            }
            if (FlagLogic.playerCanStealThisFlag(p, "Blue")) {
                FlagLogic.playerStoleBlueFlagTasks(p);
            }
            if (FlagLogic.playerCanRecoverThisFlag(p, "Red")) {
                FlagLogic.playerRecoveredRedFlagTasks(p);
            }
            if (FlagLogic.playerCanRecoverThisFlag(p, "Blue")) {
                FlagLogic.playerRecoveredBlueFlagTasks(p);
            }
            if (FlagLogic.playerCanCaptureThisFlag(p, "Red")) {
                FlagLogic.playerCapturedRedFlagTasks(p);
            }
            if (!FlagLogic.playerCanCaptureThisFlag(p, "Blue")) continue;
            FlagLogic.playerCapturedBlueFlagTasks(p);
        }
    }

    public static void spawnBlueFlag(Location loc) {
        loc.getBlock().setType(Material.BLUE_BANNER);
    }

    public static void spawnRedFlag(Location loc) {
        loc.getBlock().setType(Material.RED_BANNER);
    }

    public static void removeBlueFlag(Location loc) {
        if (loc != null) {
            loc.getBlock().setType(Material.AIR);
        }
    }

    public static void removeRedFlag(Location loc) {
        if (loc != null) {
            loc.getBlock().setType(Material.AIR);
        }
    }

    private static boolean playerCanRecoverThisFlag(Player p, String team) {
        if (p.isDead() || p.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (team.equalsIgnoreCase("Blue") && Teams.getTeam(p).equalsIgnoreCase("Blue") && GameProperties.blueFlagOnGround().booleanValue() && Helpers.withinDistance(p.getLocation(), GameProperties.blueFlagCurrentLocation(), captureDistance) && !GameProperties.blueFlagLocationBase().equals((Object)GameProperties.blueFlagCurrentLocation())) {
            return true;
        }
        return team.equalsIgnoreCase("Red") && Teams.getTeam(p).equalsIgnoreCase("Red") && GameProperties.redFlagOnGround() != false && Helpers.withinDistance(p.getLocation(), GameProperties.redFlagCurrentLocation(), captureDistance) && !GameProperties.redFlagLocationBase().equals((Object)GameProperties.redFlagCurrentLocation());
    }

    private static boolean playerCanStealThisFlag(Player p, String flag) {
        if (p.isDead() || p.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (flag.equalsIgnoreCase("Blue") && Teams.getTeam(p).equalsIgnoreCase("Red") && GameProperties.blueFlagOnGround().booleanValue() && Helpers.withinDistance(p.getLocation(), GameProperties.blueFlagCurrentLocation(), captureDistance)) {
            return true;
        }
        return flag.equalsIgnoreCase("Red") && Teams.getTeam(p).equalsIgnoreCase("Blue") && GameProperties.redFlagOnGround() != false && Helpers.withinDistance(p.getLocation(), GameProperties.redFlagCurrentLocation(), captureDistance);
    }

    private static boolean playerCanCaptureThisFlag(Player p, String flag) {
        if (p.isDead() || p.getGameMode() == GameMode.SPECTATOR) {
            return false;
        }
        if (flag.equalsIgnoreCase("Blue") && Teams.getTeam(p).equalsIgnoreCase("Red") && p.equals((Object)GameProperties.blueFlagCarrier()) && Helpers.withinDistance(p.getLocation(), red, captureDistance)) {
            GameProperties.setBlueFlagCarrier(null);
            return true;
        }
        if (flag.equalsIgnoreCase("Red") && Teams.getTeam(p).equalsIgnoreCase("Blue") && p.equals((Object)GameProperties.redFlagCarrier()) && Helpers.withinDistance(p.getLocation(), blue, captureDistance)) {
            GameProperties.setRedFlagCarrier(null);
            return true;
        }
        return false;
    }

    private static void playerRecoveredRedFlagTasks(Player p) {
        FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.red.getEntries().contains(p.getName())) {
                player.sendMessage(ChatColor.GREEN + playerWhoStole + " has recovered the flag!");
                continue;
            }
            if (!Teams.blue.getEntries().contains(p.getName())) continue;
            player.sendMessage(ChatColor.RED + playerWhoStole + " returned flag to red!");
        }
    }

    private static void playerRecoveredBlueFlagTasks(Player p) {
        FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.blue.getEntries().contains(p.getName())) {
                player.sendMessage(ChatColor.GREEN + playerWhoStole + " has recovered the flag!");
                continue;
            }
            if (!Teams.red.getEntries().contains(p.getName())) continue;
            player.sendMessage(ChatColor.RED + playerWhoStole + " returned flag to blue!");
        }
    }

    private static void playerStoleRedFlagTasks(Player p) {
        FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        GameProperties.setRedFlagCarrier(p);
        GameProperties.setRedFlagCurrentLocation(null);
        GameProperties.setRedFlagOnGround(false);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1));
        Teams.playAlarm("Red");
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.blue.getEntries().contains(player.getName())) {
                player.sendMessage(ChatColor.GREEN + playerWhoStole + " stole red team's flag!");
                continue;
            }
            if (!Teams.red.getEntries().contains(player.getName())) continue;
            player.sendMessage(ChatColor.RED + playerWhoStole + " stole your flag!");
        }
    }

    private static void playerStoleBlueFlagTasks(Player p) {
        FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        GameProperties.setBlueFlagCarrier(p);
        GameProperties.setBlueFlagCurrentLocation(null);
        GameProperties.setBlueFlagOnGround(false);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 1.0f, 1.0f);
        p.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1));
        Teams.playAlarm("Blue");
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.red.getEntries().contains(player.getName())) {
                player.sendMessage(ChatColor.GREEN + playerWhoStole + " stole blue team's flag!");
                continue;
            }
            if (!Teams.blue.getEntries().contains(player.getName())) continue;
            player.sendMessage(ChatColor.RED + playerWhoStole + " stole your flag!");
        }
    }

    private static void playerCapturedRedFlagTasks(Player p) {
        GameProperties.setRedFlagCarrier(null);
        GameProperties.setBlueTeamScore(GameProperties.blueTeamScore() + 1);
        Teams.playVictory("Blue");
        p.removePotionEffect(PotionEffectType.GLOWING);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.blue.getEntries().contains(player.getName())) {
                player.sendMessage(ChatColor.GREEN + playerWhoStole + " captured red team's flag!");
                continue;
            }
            if (!Teams.red.getEntries().contains(player.getName())) continue;
            player.sendMessage(ChatColor.RED + playerWhoStole + " captured your flag!");
        }
        World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
        dbHandler dbHandler2 = new dbHandler();
        if (GameProperties.redFlagOnGround().booleanValue()) {
            FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        }
        if (GameProperties.blueFlagOnGround().booleanValue()) {
            FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        }
        double[] redCoordinates = dbHandler2.get_random_red();
        double[] blueCoordinates = dbHandler2.get_random_blue();
        if (GameProperties.blueFlagOnGround().booleanValue()) {
            GameProperties.setBlueFlagLocationBase(new Location(gameWorld, blueCoordinates[0], blueCoordinates[1], blueCoordinates[2]));
            GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
            GameProperties.setBlueFlagOnGround(true);
        }
        GameProperties.setRedFlagLocationBase(new Location(gameWorld, redCoordinates[0], redCoordinates[1], redCoordinates[2]));
        GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
        GameProperties.setRedFlagOnGround(true);
    }

    private static void playerCapturedBlueFlagTasks(Player p) {
        GameProperties.setBlueFlagCarrier(null);
        GameProperties.setRedTeamScore(GameProperties.redTeamScore() + 1);
        Teams.playVictory("Red");
        p.removePotionEffect(PotionEffectType.GLOWING);
        String playerWhoStole = p.getName();
        for (Player player : Players.getPlayers()) {
            if (Teams.red.getEntries().contains(player.getName())) {
                player.sendMessage(ChatColor.GREEN + playerWhoStole + " captured blue team's flag!");
                continue;
            }
            if (!Teams.blue.getEntries().contains(player.getName())) continue;
            player.sendMessage(ChatColor.RED + playerWhoStole + " captured your flag!");
        }
        World gameWorld = Bukkit.getWorld((String)val.getGameWorld());
        dbHandler dbHandler2 = new dbHandler();
        if (GameProperties.redFlagOnGround().booleanValue()) {
            FlagLogic.removeRedFlag(GameProperties.redFlagCurrentLocation());
        }
        if (GameProperties.blueFlagOnGround().booleanValue()) {
            FlagLogic.removeBlueFlag(GameProperties.blueFlagCurrentLocation());
        }
        double[] redCoordinates = dbHandler2.get_random_red();
        double[] blueCoordinates = dbHandler2.get_random_blue();
        if (GameProperties.redFlagOnGround().booleanValue()) {
            GameProperties.setRedFlagLocationBase(new Location(gameWorld, redCoordinates[0], redCoordinates[1], redCoordinates[2]));
            GameProperties.setRedFlagCurrentLocation(GameProperties.redFlagLocationBase());
            GameProperties.setRedFlagOnGround(true);
        }
        GameProperties.setBlueFlagLocationBase(new Location(gameWorld, blueCoordinates[0], blueCoordinates[1], blueCoordinates[2]));
        GameProperties.setBlueFlagCurrentLocation(GameProperties.blueFlagLocationBase());
        GameProperties.setBlueFlagOnGround(true);
    }
}

