/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Quaternionf;

public record GivensParameters(float sinHalf, float cosHalf) {
    public static GivensParameters fromUnnormalized(float var0, float var1) {
        float var2 = Math.invsqrt((float)(var0 * var0 + var1 * var1));
        return new GivensParameters(var2 * var0, var2 * var1);
    }

    public static GivensParameters fromPositiveAngle(float var0) {
        float var1 = Math.sin((float)(var0 / 2.0f));
        float var2 = Math.cosFromSin((float)var1, (float)(var0 / 2.0f));
        return new GivensParameters(var1, var2);
    }

    public GivensParameters inverse() {
        return new GivensParameters(-this.sinHalf, this.cosHalf);
    }

    public Quaternionf aroundX(Quaternionf var0) {
        return var0.set(this.sinHalf, 0.0f, 0.0f, this.cosHalf);
    }

    public Quaternionf aroundY(Quaternionf var0) {
        return var0.set(0.0f, this.sinHalf, 0.0f, this.cosHalf);
    }

    public Quaternionf aroundZ(Quaternionf var0) {
        return var0.set(0.0f, 0.0f, this.sinHalf, this.cosHalf);
    }

    public float cos() {
        return this.cosHalf * this.cosHalf - this.sinHalf * this.sinHalf;
    }

    public float sin() {
        return 2.0f * this.sinHalf * this.cosHalf;
    }

    public Matrix3f aroundX(Matrix3f var0) {
        var0.m01 = 0.0f;
        var0.m02 = 0.0f;
        var0.m10 = 0.0f;
        var0.m20 = 0.0f;
        float var1 = this.cos();
        float var2 = this.sin();
        var0.m11 = var1;
        var0.m22 = var1;
        var0.m12 = var2;
        var0.m21 = -var2;
        var0.m00 = 1.0f;
        return var0;
    }

    public Matrix3f aroundY(Matrix3f var0) {
        var0.m01 = 0.0f;
        var0.m10 = 0.0f;
        var0.m12 = 0.0f;
        var0.m21 = 0.0f;
        float var1 = this.cos();
        float var2 = this.sin();
        var0.m00 = var1;
        var0.m22 = var1;
        var0.m02 = -var2;
        var0.m20 = var2;
        var0.m11 = 1.0f;
        return var0;
    }

    public Matrix3f aroundZ(Matrix3f var0) {
        var0.m02 = 0.0f;
        var0.m12 = 0.0f;
        var0.m20 = 0.0f;
        var0.m21 = 0.0f;
        float var1 = this.cos();
        float var2 = this.sin();
        var0.m00 = var1;
        var0.m11 = var1;
        var0.m01 = var2;
        var0.m10 = -var2;
        var0.m22 = 1.0f;
        return var0;
    }
}

