/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.util.MemoryReserve;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class CrashReport {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private final String title;
    private final Throwable exception;
    private final List<CrashReportSystemDetails> details = Lists.newArrayList();
    @Nullable
    private Path saveFile;
    private boolean trackingStackTrace = true;
    private StackTraceElement[] uncategorizedStackTrace = new StackTraceElement[0];
    private final SystemReport systemReport = new SystemReport();

    public CrashReport(String var0, Throwable var1) {
        this.title = var0;
        this.exception = var1;
    }

    public String getTitle() {
        return this.title;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getDetails() {
        StringBuilder var0 = new StringBuilder();
        this.getDetails(var0);
        return var0.toString();
    }

    public void getDetails(StringBuilder var0) {
        if (!(this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0 || this.details.isEmpty())) {
            this.uncategorizedStackTrace = (StackTraceElement[])ArrayUtils.subarray((Object[])this.details.get(0).getStacktrace(), (int)0, (int)1);
        }
        if (this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0) {
            var0.append("-- Head --\n");
            var0.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            var0.append("Stacktrace:\n");
            for (StackTraceElement var4 : this.uncategorizedStackTrace) {
                var0.append("\t").append("at ").append(var4);
                var0.append("\n");
            }
            var0.append("\n");
        }
        for (CrashReportSystemDetails var2 : this.details) {
            var2.getDetails(var0);
            var0.append("\n\n");
        }
        this.systemReport.appendToCrashReportString(var0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionMessage() {
        String string;
        StringWriter var0 = null;
        PrintWriter var1 = null;
        Throwable var2 = this.exception;
        if (var2.getMessage() == null) {
            if (var2 instanceof NullPointerException) {
                var2 = new NullPointerException(this.title);
            } else if (var2 instanceof StackOverflowError) {
                var2 = new StackOverflowError(this.title);
            } else if (var2 instanceof OutOfMemoryError) {
                var2 = new OutOfMemoryError(this.title);
            }
            var2.setStackTrace(this.exception.getStackTrace());
        }
        try {
            var0 = new StringWriter();
            var1 = new PrintWriter(var0);
            var2.printStackTrace(var1);
            string = var0.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)var0);
            IOUtils.closeQuietly(var1);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)var0);
        IOUtils.closeQuietly((Writer)var1);
        return string;
    }

    public String getFriendlyReport(ReportType var0, List<String> var1) {
        StringBuilder var2 = new StringBuilder();
        var0.appendHeader(var2, var1);
        var2.append("Time: ");
        var2.append(DATE_TIME_FORMATTER.format(ZonedDateTime.now()));
        var2.append("\n");
        var2.append("Description: ");
        var2.append(this.title);
        var2.append("\n\n");
        var2.append(this.getExceptionMessage());
        var2.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int var3 = 0; var3 < 87; ++var3) {
            var2.append("-");
        }
        var2.append("\n\n");
        this.getDetails(var2);
        return var2.toString();
    }

    public String getFriendlyReport(ReportType var0) {
        return this.getFriendlyReport(var0, List.of());
    }

    @Nullable
    public Path getSaveFile() {
        return this.saveFile;
    }

    public boolean saveToFile(Path var0, ReportType var1, List<String> var2) {
        if (this.saveFile != null) {
            return false;
        }
        try {
            if (var0.getParent() != null) {
                FileUtils.createDirectoriesSafe(var0.getParent());
            }
            try (BufferedWriter var3 = Files.newBufferedWriter(var0, StandardCharsets.UTF_8, new OpenOption[0]);){
                var3.write(this.getFriendlyReport(var1, var2));
            }
            this.saveFile = var0;
            return true;
        }
        catch (Throwable var3) {
            LOGGER.error("Could not save crash report to {}", (Object)var0, (Object)var3);
            return false;
        }
    }

    public boolean saveToFile(Path var0, ReportType var1) {
        return this.saveToFile(var0, var1, List.of());
    }

    public SystemReport getSystemReport() {
        return this.systemReport;
    }

    public CrashReportSystemDetails addCategory(String var0) {
        return this.addCategory(var0, 1);
    }

    public CrashReportSystemDetails addCategory(String var0, int var1) {
        CrashReportSystemDetails var2 = new CrashReportSystemDetails(var0);
        if (this.trackingStackTrace) {
            int var3 = var2.fillInStackTrace(var1);
            StackTraceElement[] var4 = this.exception.getStackTrace();
            StackTraceElement var5 = null;
            StackTraceElement var6 = null;
            int var7 = var4.length - var3;
            if (var7 < 0) {
                LOGGER.error("Negative index in crash report handler ({}/{})", (Object)var4.length, (Object)var3);
            }
            if (var4 != null && 0 <= var7 && var7 < var4.length) {
                var5 = var4[var7];
                if (var4.length + 1 - var3 < var4.length) {
                    var6 = var4[var4.length + 1 - var3];
                }
            }
            this.trackingStackTrace = var2.validateStackTrace(var5, var6);
            if (var4 != null && var4.length >= var3 && 0 <= var7 && var7 < var4.length) {
                this.uncategorizedStackTrace = new StackTraceElement[var7];
                System.arraycopy(var4, 0, this.uncategorizedStackTrace, 0, this.uncategorizedStackTrace.length);
            } else {
                this.trackingStackTrace = false;
            }
        }
        this.details.add(var2);
        return var2;
    }

    public static CrashReport forThrowable(Throwable var0, String var1) {
        CrashReport var2;
        while (var0 instanceof CompletionException && var0.getCause() != null) {
            var0 = var0.getCause();
        }
        if (var0 instanceof ReportedException) {
            ReportedException var3 = (ReportedException)var0;
            var2 = var3.getReport();
        } else {
            var2 = new CrashReport(var1, var0);
        }
        return var2;
    }

    public static void preload() {
        MemoryReserve.allocate();
        new CrashReport("Don't panic!", new Throwable()).getFriendlyReport(ReportType.CRASH);
    }
}

