/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionDistance;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.phys.Vec3D;

public class FallAfterExplosionTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, Vec3D var1, @Nullable Entity var2) {
        Vec3D var3 = var0.position();
        LootTableInfo var42 = var2 != null ? CriterionConditionEntity.createContext(var0, var2) : null;
        this.trigger(var0, var4 -> var4.matches(var0.serverLevel(), var1, var3, var42));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<CriterionConditionLocation> startPosition, Optional<CriterionConditionDistance> distance, Optional<ContextAwarePredicate> cause) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(a::player), (App)CriterionConditionLocation.CODEC.optionalFieldOf("start_position").forGetter(a::startPosition), (App)CriterionConditionDistance.CODEC.optionalFieldOf("distance").forGetter(a::distance), (App)CriterionConditionEntity.ADVANCEMENT_CODEC.optionalFieldOf("cause").forGetter(a::cause)).apply((Applicative)var0, a::new));

        public static Criterion<a> fallAfterExplosion(CriterionConditionDistance var0, CriterionConditionEntity.a var1) {
            return CriterionTriggers.FALL_AFTER_EXPLOSION.createCriterion(new a(Optional.empty(), Optional.empty(), Optional.of(var0), Optional.of(CriterionConditionEntity.wrap(var1))));
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntity(this.cause(), ".cause");
        }

        public boolean matches(WorldServer var0, Vec3D var1, Vec3D var2, @Nullable LootTableInfo var3) {
            if (this.startPosition.isPresent() && !this.startPosition.get().matches(var0, var1.x, var1.y, var1.z)) {
                return false;
            }
            if (this.distance.isPresent() && !this.distance.get().matches(var1.x, var1.y, var1.z, var2.x, var2.y, var2.z)) {
                return false;
            }
            return !this.cause.isPresent() || var3 != null && this.cause.get().matches(var3);
        }
    }
}

