/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.ItemFireworkExplosionPredicate;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;

public record ItemFireworksPredicate(Optional<CollectionPredicate<FireworkExplosion, ItemFireworkExplosionPredicate.a>> explosions, CriterionConditionValue.IntegerRange flightDuration) implements SingleComponentItemPredicate<Fireworks>
{
    public static final Codec<ItemFireworksPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CollectionPredicate.codec(ItemFireworkExplosionPredicate.a.CODEC).optionalFieldOf("explosions").forGetter(ItemFireworksPredicate::explosions), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("flight_duration", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(ItemFireworksPredicate::flightDuration)).apply((Applicative)var0, ItemFireworksPredicate::new));

    @Override
    public DataComponentType<Fireworks> componentType() {
        return DataComponents.FIREWORKS;
    }

    @Override
    public boolean matches(ItemStack var0, Fireworks var1) {
        if (this.explosions.isPresent() && !this.explosions.get().test(var1.explosions())) {
            return false;
        }
        return this.flightDuration.matches(var1.flightDuration());
    }
}

