/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ParserUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;

public class StyleArgument
implements ArgumentType<ChatModifier> {
    private static final Collection<String> EXAMPLES = List.of("{\"bold\": true}\n");
    public static final DynamicCommandExceptionType ERROR_INVALID_JSON = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.style.invalid", var0));
    private final HolderLookup.a registries;

    private StyleArgument(HolderLookup.a var0) {
        this.registries = var0;
    }

    public static ChatModifier getStyle(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (ChatModifier)var0.getArgument(var1, ChatModifier.class);
    }

    public static StyleArgument style(CommandBuildContext var0) {
        return new StyleArgument(var0);
    }

    public ChatModifier parse(StringReader var0) throws CommandSyntaxException {
        try {
            return ParserUtils.parseJson(this.registries, var0, ChatModifier.ChatModifierSerializer.CODEC);
        }
        catch (Exception var1) {
            String var2 = var1.getCause() != null ? var1.getCause().getMessage() : var1.getMessage();
            throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)var0, (Object)var2);
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

