/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentRotation
implements ArgumentType<IVectorPosition> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "~-5 ~5");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.rotation.incomplete"));

    public static ArgumentRotation rotation() {
        return new ArgumentRotation();
    }

    public static IVectorPosition getRotation(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (IVectorPosition)var0.getArgument(var1, IVectorPosition.class);
    }

    public IVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        if (!var0.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        ArgumentParserPosition var2 = ArgumentParserPosition.parseDouble(var0, false);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var3 = ArgumentParserPosition.parseDouble(var0, false);
        return new VectorPosition(var3, var2, new ArgumentParserPosition(true, 0.0));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

