/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.features;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockHugeMushroom;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureMushroomConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeThreeLayers;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeTwoLayers;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerAcacia;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerBlob;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerBush;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerDarkOak;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerFancy;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerJungle;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerMegaPine;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerPine;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacerSpruce;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviderWeighted;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTreeAlterGround;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTreeBeehive;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTreeCocoa;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTreeVineLeaves;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTreeVineTrunk;
import net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerDarkOak;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerFancy;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerForking;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerGiant;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerMegaJungle;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerStraight;
import net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer;

public class TreeFeatures {
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> CRIMSON_FUNGUS = FeatureUtils.createKey("crimson_fungus");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> CRIMSON_FUNGUS_PLANTED = FeatureUtils.createKey("crimson_fungus_planted");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> WARPED_FUNGUS = FeatureUtils.createKey("warped_fungus");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> WARPED_FUNGUS_PLANTED = FeatureUtils.createKey("warped_fungus_planted");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> HUGE_BROWN_MUSHROOM = FeatureUtils.createKey("huge_brown_mushroom");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> HUGE_RED_MUSHROOM = FeatureUtils.createKey("huge_red_mushroom");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> OAK = FeatureUtils.createKey("oak");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> DARK_OAK = FeatureUtils.createKey("dark_oak");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BIRCH = FeatureUtils.createKey("birch");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> ACACIA = FeatureUtils.createKey("acacia");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SPRUCE = FeatureUtils.createKey("spruce");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> PINE = FeatureUtils.createKey("pine");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> JUNGLE_TREE = FeatureUtils.createKey("jungle_tree");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FANCY_OAK = FeatureUtils.createKey("fancy_oak");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> JUNGLE_TREE_NO_VINE = FeatureUtils.createKey("jungle_tree_no_vine");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MEGA_JUNGLE_TREE = FeatureUtils.createKey("mega_jungle_tree");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MEGA_SPRUCE = FeatureUtils.createKey("mega_spruce");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MEGA_PINE = FeatureUtils.createKey("mega_pine");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SUPER_BIRCH_BEES_0002 = FeatureUtils.createKey("super_birch_bees_0002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SUPER_BIRCH_BEES = FeatureUtils.createKey("super_birch_bees");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> SWAMP_OAK = FeatureUtils.createKey("swamp_oak");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> JUNGLE_BUSH = FeatureUtils.createKey("jungle_bush");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> AZALEA_TREE = FeatureUtils.createKey("azalea_tree");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> MANGROVE = FeatureUtils.createKey("mangrove");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> TALL_MANGROVE = FeatureUtils.createKey("tall_mangrove");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> CHERRY = FeatureUtils.createKey("cherry");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> OAK_BEES_0002 = FeatureUtils.createKey("oak_bees_0002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> OAK_BEES_002 = FeatureUtils.createKey("oak_bees_002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> OAK_BEES_005 = FeatureUtils.createKey("oak_bees_005");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BIRCH_BEES_0002 = FeatureUtils.createKey("birch_bees_0002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BIRCH_BEES_002 = FeatureUtils.createKey("birch_bees_002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> BIRCH_BEES_005 = FeatureUtils.createKey("birch_bees_005");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FANCY_OAK_BEES_0002 = FeatureUtils.createKey("fancy_oak_bees_0002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FANCY_OAK_BEES_002 = FeatureUtils.createKey("fancy_oak_bees_002");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FANCY_OAK_BEES_005 = FeatureUtils.createKey("fancy_oak_bees_005");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> FANCY_OAK_BEES = FeatureUtils.createKey("fancy_oak_bees");
    public static final ResourceKey<WorldGenFeatureConfigured<?, ?>> CHERRY_BEES_005 = FeatureUtils.createKey("cherry_bees_005");

    private static WorldGenFeatureTreeConfiguration.a createStraightBlobTree(Block var0, Block var1, int var2, int var3, int var4, int var5) {
        return new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(var0), new TrunkPlacerStraight(var2, var3, var4), WorldGenFeatureStateProvider.simple(var1), new WorldGenFoilagePlacerBlob(ConstantInt.of(var5), ConstantInt.of(0), 3), new FeatureSizeTwoLayers(1, 0, 1));
    }

    private static WorldGenFeatureTreeConfiguration.a createOak() {
        return TreeFeatures.createStraightBlobTree(Blocks.OAK_LOG, Blocks.OAK_LEAVES, 4, 2, 0, 2).ignoreVines();
    }

    private static WorldGenFeatureTreeConfiguration.a createBirch() {
        return TreeFeatures.createStraightBlobTree(Blocks.BIRCH_LOG, Blocks.BIRCH_LEAVES, 5, 2, 0, 2).ignoreVines();
    }

    private static WorldGenFeatureTreeConfiguration.a createSuperBirch() {
        return TreeFeatures.createStraightBlobTree(Blocks.BIRCH_LOG, Blocks.BIRCH_LEAVES, 5, 2, 6, 2).ignoreVines();
    }

    private static WorldGenFeatureTreeConfiguration.a createJungleTree() {
        return TreeFeatures.createStraightBlobTree(Blocks.JUNGLE_LOG, Blocks.JUNGLE_LEAVES, 4, 8, 0, 2);
    }

    private static WorldGenFeatureTreeConfiguration.a createFancyOak() {
        return new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.OAK_LOG), new TrunkPlacerFancy(3, 11, 0), WorldGenFeatureStateProvider.simple(Blocks.OAK_LEAVES), new WorldGenFoilagePlacerFancy(ConstantInt.of(2), ConstantInt.of(4), 4), new FeatureSizeTwoLayers(0, 0, 0, OptionalInt.of(4))).ignoreVines();
    }

    private static WorldGenFeatureTreeConfiguration.a cherry() {
        return new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.CHERRY_LOG), new CherryTrunkPlacer(7, 1, 0, new WeightedListInt(SimpleWeightedRandomList.builder().add(ConstantInt.of(1), 1).add(ConstantInt.of(2), 1).add(ConstantInt.of(3), 1).build()), UniformInt.of(2, 4), UniformInt.of(-4, -3), UniformInt.of(-1, 0)), WorldGenFeatureStateProvider.simple(Blocks.CHERRY_LEAVES), new CherryFoliagePlacer(ConstantInt.of(4), ConstantInt.of(0), ConstantInt.of(5), 0.25f, 0.5f, 0.16666667f, 0.33333334f), new FeatureSizeTwoLayers(1, 0, 2)).ignoreVines();
    }

    public static void bootstrap(BootstrapContext<WorldGenFeatureConfigured<?, ?>> var0) {
        HolderGetter<Block> var1 = var0.lookup(Registries.BLOCK);
        BlockPredicate var2 = BlockPredicate.matchesBlocks(Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.CHERRY_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.MANGROVE_PROPAGULE, Blocks.DANDELION, Blocks.TORCHFLOWER, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.WITHER_ROSE, Blocks.LILY_OF_THE_VALLEY, Blocks.BROWN_MUSHROOM, Blocks.RED_MUSHROOM, Blocks.WHEAT, Blocks.SUGAR_CANE, Blocks.ATTACHED_PUMPKIN_STEM, Blocks.ATTACHED_MELON_STEM, Blocks.PUMPKIN_STEM, Blocks.MELON_STEM, Blocks.LILY_PAD, Blocks.NETHER_WART, Blocks.COCOA, Blocks.CARROTS, Blocks.POTATOES, Blocks.CHORUS_PLANT, Blocks.CHORUS_FLOWER, Blocks.TORCHFLOWER_CROP, Blocks.PITCHER_CROP, Blocks.BEETROOTS, Blocks.SWEET_BERRY_BUSH, Blocks.WARPED_FUNGUS, Blocks.CRIMSON_FUNGUS, Blocks.WEEPING_VINES, Blocks.WEEPING_VINES_PLANT, Blocks.TWISTING_VINES, Blocks.TWISTING_VINES_PLANT, Blocks.CAVE_VINES, Blocks.CAVE_VINES_PLANT, Blocks.SPORE_BLOSSOM, Blocks.AZALEA, Blocks.FLOWERING_AZALEA, Blocks.MOSS_CARPET, Blocks.PINK_PETALS, Blocks.BIG_DRIPLEAF, Blocks.BIG_DRIPLEAF_STEM, Blocks.SMALL_DRIPLEAF);
        FeatureUtils.register(var0, CRIMSON_FUNGUS, WorldGenerator.HUGE_FUNGUS, new WorldGenFeatureHugeFungiConfiguration(Blocks.CRIMSON_NYLIUM.defaultBlockState(), Blocks.CRIMSON_STEM.defaultBlockState(), Blocks.NETHER_WART_BLOCK.defaultBlockState(), Blocks.SHROOMLIGHT.defaultBlockState(), var2, false));
        FeatureUtils.register(var0, CRIMSON_FUNGUS_PLANTED, WorldGenerator.HUGE_FUNGUS, new WorldGenFeatureHugeFungiConfiguration(Blocks.CRIMSON_NYLIUM.defaultBlockState(), Blocks.CRIMSON_STEM.defaultBlockState(), Blocks.NETHER_WART_BLOCK.defaultBlockState(), Blocks.SHROOMLIGHT.defaultBlockState(), var2, true));
        FeatureUtils.register(var0, WARPED_FUNGUS, WorldGenerator.HUGE_FUNGUS, new WorldGenFeatureHugeFungiConfiguration(Blocks.WARPED_NYLIUM.defaultBlockState(), Blocks.WARPED_STEM.defaultBlockState(), Blocks.WARPED_WART_BLOCK.defaultBlockState(), Blocks.SHROOMLIGHT.defaultBlockState(), var2, false));
        FeatureUtils.register(var0, WARPED_FUNGUS_PLANTED, WorldGenerator.HUGE_FUNGUS, new WorldGenFeatureHugeFungiConfiguration(Blocks.WARPED_NYLIUM.defaultBlockState(), Blocks.WARPED_STEM.defaultBlockState(), Blocks.WARPED_WART_BLOCK.defaultBlockState(), Blocks.SHROOMLIGHT.defaultBlockState(), var2, true));
        FeatureUtils.register(var0, HUGE_BROWN_MUSHROOM, WorldGenerator.HUGE_BROWN_MUSHROOM, new WorldGenFeatureMushroomConfiguration(WorldGenFeatureStateProvider.simple((IBlockData)((IBlockData)Blocks.BROWN_MUSHROOM_BLOCK.defaultBlockState().setValue(BlockHugeMushroom.UP, true)).setValue(BlockHugeMushroom.DOWN, false)), WorldGenFeatureStateProvider.simple((IBlockData)((IBlockData)Blocks.MUSHROOM_STEM.defaultBlockState().setValue(BlockHugeMushroom.UP, false)).setValue(BlockHugeMushroom.DOWN, false)), 3));
        FeatureUtils.register(var0, HUGE_RED_MUSHROOM, WorldGenerator.HUGE_RED_MUSHROOM, new WorldGenFeatureMushroomConfiguration(WorldGenFeatureStateProvider.simple((IBlockData)Blocks.RED_MUSHROOM_BLOCK.defaultBlockState().setValue(BlockHugeMushroom.DOWN, false)), WorldGenFeatureStateProvider.simple((IBlockData)((IBlockData)Blocks.MUSHROOM_STEM.defaultBlockState().setValue(BlockHugeMushroom.UP, false)).setValue(BlockHugeMushroom.DOWN, false)), 2));
        WorldGenFeatureTreeBeehive var3 = new WorldGenFeatureTreeBeehive(0.002f);
        WorldGenFeatureTreeBeehive var4 = new WorldGenFeatureTreeBeehive(0.01f);
        WorldGenFeatureTreeBeehive var5 = new WorldGenFeatureTreeBeehive(0.02f);
        WorldGenFeatureTreeBeehive var6 = new WorldGenFeatureTreeBeehive(0.05f);
        WorldGenFeatureTreeBeehive var7 = new WorldGenFeatureTreeBeehive(1.0f);
        FeatureUtils.register(var0, OAK, WorldGenerator.TREE, TreeFeatures.createOak().build());
        FeatureUtils.register(var0, DARK_OAK, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.DARK_OAK_LOG), new TrunkPlacerDarkOak(6, 2, 1), WorldGenFeatureStateProvider.simple(Blocks.DARK_OAK_LEAVES), new WorldGenFoilagePlacerDarkOak(ConstantInt.of(0), ConstantInt.of(0)), new FeatureSizeThreeLayers(1, 1, 0, 1, 2, OptionalInt.empty())).ignoreVines().build());
        FeatureUtils.register(var0, BIRCH, WorldGenerator.TREE, TreeFeatures.createBirch().build());
        FeatureUtils.register(var0, ACACIA, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.ACACIA_LOG), new TrunkPlacerForking(5, 2, 2), WorldGenFeatureStateProvider.simple(Blocks.ACACIA_LEAVES), new WorldGenFoilagePlacerAcacia(ConstantInt.of(2), ConstantInt.of(0)), new FeatureSizeTwoLayers(1, 0, 2)).ignoreVines().build());
        FeatureUtils.register(var0, CHERRY, WorldGenerator.TREE, TreeFeatures.cherry().build());
        FeatureUtils.register(var0, CHERRY_BEES_005, WorldGenerator.TREE, TreeFeatures.cherry().decorators(List.of(var6)).build());
        FeatureUtils.register(var0, SPRUCE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LOG), new TrunkPlacerStraight(5, 2, 1), WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LEAVES), new WorldGenFoilagePlacerSpruce(UniformInt.of(2, 3), UniformInt.of(0, 2), UniformInt.of(1, 2)), new FeatureSizeTwoLayers(2, 0, 2)).ignoreVines().build());
        FeatureUtils.register(var0, PINE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LOG), new TrunkPlacerStraight(6, 4, 0), WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LEAVES), new WorldGenFoilagePlacerPine(ConstantInt.of(1), ConstantInt.of(1), UniformInt.of(3, 4)), new FeatureSizeTwoLayers(2, 0, 2)).ignoreVines().build());
        FeatureUtils.register(var0, JUNGLE_TREE, WorldGenerator.TREE, TreeFeatures.createJungleTree().decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)new WorldGenFeatureTreeCocoa(0.2f), (Object)WorldGenFeatureTreeVineTrunk.INSTANCE, (Object)new WorldGenFeatureTreeVineLeaves(0.25f))).ignoreVines().build());
        FeatureUtils.register(var0, FANCY_OAK, WorldGenerator.TREE, TreeFeatures.createFancyOak().build());
        FeatureUtils.register(var0, JUNGLE_TREE_NO_VINE, WorldGenerator.TREE, TreeFeatures.createJungleTree().ignoreVines().build());
        FeatureUtils.register(var0, MEGA_JUNGLE_TREE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.JUNGLE_LOG), new TrunkPlacerMegaJungle(10, 2, 19), WorldGenFeatureStateProvider.simple(Blocks.JUNGLE_LEAVES), new WorldGenFoilagePlacerJungle(ConstantInt.of(2), ConstantInt.of(0), 2), new FeatureSizeTwoLayers(1, 1, 2)).decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)WorldGenFeatureTreeVineTrunk.INSTANCE, (Object)new WorldGenFeatureTreeVineLeaves(0.25f))).build());
        FeatureUtils.register(var0, MEGA_SPRUCE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LOG), new TrunkPlacerGiant(13, 2, 14), WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LEAVES), new WorldGenFoilagePlacerMegaPine(ConstantInt.of(0), ConstantInt.of(0), UniformInt.of(13, 17)), new FeatureSizeTwoLayers(1, 1, 2)).decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)new WorldGenFeatureTreeAlterGround(WorldGenFeatureStateProvider.simple(Blocks.PODZOL)))).build());
        FeatureUtils.register(var0, MEGA_PINE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LOG), new TrunkPlacerGiant(13, 2, 14), WorldGenFeatureStateProvider.simple(Blocks.SPRUCE_LEAVES), new WorldGenFoilagePlacerMegaPine(ConstantInt.of(0), ConstantInt.of(0), UniformInt.of(3, 7)), new FeatureSizeTwoLayers(1, 1, 2)).decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)new WorldGenFeatureTreeAlterGround(WorldGenFeatureStateProvider.simple(Blocks.PODZOL)))).build());
        FeatureUtils.register(var0, SUPER_BIRCH_BEES_0002, WorldGenerator.TREE, TreeFeatures.createSuperBirch().decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)var3)).build());
        FeatureUtils.register(var0, SUPER_BIRCH_BEES, WorldGenerator.TREE, TreeFeatures.createSuperBirch().decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)var7)).build());
        FeatureUtils.register(var0, SWAMP_OAK, WorldGenerator.TREE, TreeFeatures.createStraightBlobTree(Blocks.OAK_LOG, Blocks.OAK_LEAVES, 5, 3, 0, 3).decorators((List<WorldGenFeatureTree>)ImmutableList.of((Object)new WorldGenFeatureTreeVineLeaves(0.25f))).build());
        FeatureUtils.register(var0, JUNGLE_BUSH, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.JUNGLE_LOG), new TrunkPlacerStraight(1, 0, 0), WorldGenFeatureStateProvider.simple(Blocks.OAK_LEAVES), new WorldGenFoilagePlacerBush(ConstantInt.of(2), ConstantInt.of(1), 2), new FeatureSizeTwoLayers(0, 0, 0)).build());
        FeatureUtils.register(var0, AZALEA_TREE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.OAK_LOG), new BendingTrunkPlacer(4, 2, 0, 3, UniformInt.of(1, 2)), new WorldGenFeatureStateProviderWeighted(SimpleWeightedRandomList.builder().add(Blocks.AZALEA_LEAVES.defaultBlockState(), 3).add(Blocks.FLOWERING_AZALEA_LEAVES.defaultBlockState(), 1)), new RandomSpreadFoliagePlacer(ConstantInt.of(3), ConstantInt.of(0), ConstantInt.of(2), 50), new FeatureSizeTwoLayers(1, 0, 1)).dirt(WorldGenFeatureStateProvider.simple(Blocks.ROOTED_DIRT)).forceDirt().build());
        FeatureUtils.register(var0, MANGROVE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.MANGROVE_LOG), new UpwardsBranchingTrunkPlacer(2, 1, 4, UniformInt.of(1, 4), 0.5f, UniformInt.of(0, 1), var1.getOrThrow(TagsBlock.MANGROVE_LOGS_CAN_GROW_THROUGH)), WorldGenFeatureStateProvider.simple(Blocks.MANGROVE_LEAVES), new RandomSpreadFoliagePlacer(ConstantInt.of(3), ConstantInt.of(0), ConstantInt.of(2), 70), Optional.of(new MangroveRootPlacer(UniformInt.of(1, 3), WorldGenFeatureStateProvider.simple(Blocks.MANGROVE_ROOTS), Optional.of(new AboveRootPlacement(WorldGenFeatureStateProvider.simple(Blocks.MOSS_CARPET), 0.5f)), new MangroveRootPlacement(var1.getOrThrow(TagsBlock.MANGROVE_ROOTS_CAN_GROW_THROUGH), HolderSet.direct(Block::builtInRegistryHolder, Blocks.MUD, Blocks.MUDDY_MANGROVE_ROOTS), WorldGenFeatureStateProvider.simple(Blocks.MUDDY_MANGROVE_ROOTS), 8, 15, 0.2f))), new FeatureSizeTwoLayers(2, 0, 2)).decorators(List.of(new WorldGenFeatureTreeVineLeaves(0.125f), new AttachedToLeavesDecorator(0.14f, 1, 0, new RandomizedIntStateProvider((WorldGenFeatureStateProvider)WorldGenFeatureStateProvider.simple((IBlockData)Blocks.MANGROVE_PROPAGULE.defaultBlockState().setValue(MangrovePropaguleBlock.HANGING, true)), MangrovePropaguleBlock.AGE, (IntProvider)UniformInt.of(0, 4)), 2, List.of(EnumDirection.DOWN)), var4)).ignoreVines().build());
        FeatureUtils.register(var0, TALL_MANGROVE, WorldGenerator.TREE, new WorldGenFeatureTreeConfiguration.a(WorldGenFeatureStateProvider.simple(Blocks.MANGROVE_LOG), new UpwardsBranchingTrunkPlacer(4, 1, 9, UniformInt.of(1, 6), 0.5f, UniformInt.of(0, 1), var1.getOrThrow(TagsBlock.MANGROVE_LOGS_CAN_GROW_THROUGH)), WorldGenFeatureStateProvider.simple(Blocks.MANGROVE_LEAVES), new RandomSpreadFoliagePlacer(ConstantInt.of(3), ConstantInt.of(0), ConstantInt.of(2), 70), Optional.of(new MangroveRootPlacer(UniformInt.of(3, 7), WorldGenFeatureStateProvider.simple(Blocks.MANGROVE_ROOTS), Optional.of(new AboveRootPlacement(WorldGenFeatureStateProvider.simple(Blocks.MOSS_CARPET), 0.5f)), new MangroveRootPlacement(var1.getOrThrow(TagsBlock.MANGROVE_ROOTS_CAN_GROW_THROUGH), HolderSet.direct(Block::builtInRegistryHolder, Blocks.MUD, Blocks.MUDDY_MANGROVE_ROOTS), WorldGenFeatureStateProvider.simple(Blocks.MUDDY_MANGROVE_ROOTS), 8, 15, 0.2f))), new FeatureSizeTwoLayers(3, 0, 2)).decorators(List.of(new WorldGenFeatureTreeVineLeaves(0.125f), new AttachedToLeavesDecorator(0.14f, 1, 0, new RandomizedIntStateProvider((WorldGenFeatureStateProvider)WorldGenFeatureStateProvider.simple((IBlockData)Blocks.MANGROVE_PROPAGULE.defaultBlockState().setValue(MangrovePropaguleBlock.HANGING, true)), MangrovePropaguleBlock.AGE, (IntProvider)UniformInt.of(0, 4)), 2, List.of(EnumDirection.DOWN)), var4)).ignoreVines().build());
        FeatureUtils.register(var0, OAK_BEES_0002, WorldGenerator.TREE, TreeFeatures.createOak().decorators(List.of(var3)).build());
        FeatureUtils.register(var0, OAK_BEES_002, WorldGenerator.TREE, TreeFeatures.createOak().decorators(List.of(var5)).build());
        FeatureUtils.register(var0, OAK_BEES_005, WorldGenerator.TREE, TreeFeatures.createOak().decorators(List.of(var6)).build());
        FeatureUtils.register(var0, BIRCH_BEES_0002, WorldGenerator.TREE, TreeFeatures.createBirch().decorators(List.of(var3)).build());
        FeatureUtils.register(var0, BIRCH_BEES_002, WorldGenerator.TREE, TreeFeatures.createBirch().decorators(List.of(var5)).build());
        FeatureUtils.register(var0, BIRCH_BEES_005, WorldGenerator.TREE, TreeFeatures.createBirch().decorators(List.of(var6)).build());
        FeatureUtils.register(var0, FANCY_OAK_BEES_0002, WorldGenerator.TREE, TreeFeatures.createFancyOak().decorators(List.of(var3)).build());
        FeatureUtils.register(var0, FANCY_OAK_BEES_002, WorldGenerator.TREE, TreeFeatures.createFancyOak().decorators(List.of(var5)).build());
        FeatureUtils.register(var0, FANCY_OAK_BEES_005, WorldGenerator.TREE, TreeFeatures.createFancyOak().decorators(List.of(var6)).build());
        FeatureUtils.register(var0, FANCY_OAK_BEES, WorldGenerator.TREE, TreeFeatures.createFancyOak().decorators(List.of(var7)).build());
    }
}

